// Copyright 2000-2024 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.documentation.phpdoc.lexer;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocElementType;

public interface PhpDocTokenTypes extends TokenType {

  IElementType DOC_COMMENT_START = new PhpDocElementType("DOC_COMMENT_START");
  IElementType DOC_COMMENT_END = new PhpDocElementType("DOC_COMMENT_END");

  IElementType DOC_TAG_NAME = new PhpDocElementType("DOC_TAG_NAME");
  IElementType DOC_TAG_NAME_FOR_EDITOR = new PhpDocElementType("DOC_TAG_NAME_FOR_EDITOR");
  IElementType DOC_IDENTIFIER = new PhpDocElementType("DOC_IDENTIFIER");
  IElementType DOC_IDENTIFIER_FOR_EDITOR = new PhpDocElementType("DOC_IDENTIFIER_FOR_EDITOR");
  IElementType DOC_NAMESPACE = new PhpDocElementType("DOC_NAMESPACE");
  IElementType DOC_DOT = new PhpDocElementType("DOC_DOT");
  IElementType DOC_COMMA = new PhpDocElementType("DOC_COMMA");
  IElementType DOC_STRING = new PhpDocElementType("DOC_STRING");
  IElementType DOC_PATTERN = new PhpDocElementType("DOC_PATTERN");
  IElementType DOC_STATIC = new PhpDocElementType("DOC_STATIC");
  IElementType DOC_PIPE = new PhpDocElementType("DOC_PIPE");
  IElementType DOC_MAIL = new PhpDocElementType("DOC_MAIL");
  IElementType DOC_URL = new PhpDocElementType("DOC_URL");
  IElementType DOC_AMPERSAND = new PhpDocElementType("DOC_AMPERSAND");
  IElementType DOC_LBRACE = new PhpDocElementType("DOC_LBRACE");
  IElementType DOC_RBRACE = new PhpDocElementType("DOC_RBRACE");
  IElementType DOC_LPAREN = new PhpDocElementType("DOC_LPAREN");
  IElementType DOC_RPAREN = new PhpDocElementType("DOC_RPAREN");
  IElementType DOC_LAB = new PhpDocElementType("DOC_LAB");
  IElementType DOC_RAB = new PhpDocElementType("DOC_RAB");
  IElementType DOC_LBRACKET = new PhpDocElementType("DOC_LBRACKET");
  IElementType DOC_RBRACKET = new PhpDocElementType("DOC_RBRACKET");
  IElementType DOC_VARIABLE = new PhpDocElementType("DOC_VARIABLE");
  IElementType DOC_HASH = new PhpDocElementType("DOC_HASH");

  IElementType DOC_LEADING_ASTERISK = new PhpDocElementType("DOC_LEADING_ASTERISK");
  IElementType DOC_WHITESPACE = new PhpDocElementType("DOC_WHITESPACE");
  IElementType DOC_TEXT = new PhpDocElementType("DOC_TEXT");
  IElementType DOC_METHOD_DESCRIPTION = new PhpDocElementType("DOC_METHOD_DESCR");
  IElementType DOC_IGNORED = new PhpDocElementType("DOC_IGNORED");
  IElementType DOC_HTML_TAG = new PhpDocElementType("DOC_HTML_TAG");

  TokenSet DOC_TAG_VALUE_END = TokenSet.create(DOC_COMMENT_END, DOC_IGNORED, DOC_LEADING_ASTERISK);


  IElementType DOC_SPACE = new PhpDocElementType("DOC_SPACE");
  IElementType DOC_COMMENT_DATA = new PhpDocElementType("DOC_COMMENT_DATA");
  IElementType DOC_COMMENT_LEADING_ASTERISK = new PhpDocElementType("DOC_COMMENT_LEADING_ASTERISK");
  IElementType DOC_BAD_CHARACTER = TokenType.BAD_CHARACTER;
  //IElementType DOC_TAG_VALUE = new PhpDocCompositeElementType("DOC_TAG_VALUE");

  IElementType DOC_TAG_VALUE_LPAREN = new PhpDocElementType("DOC_TAG_VALUE_LPAREN");
  IElementType DOC_TAG_VALUE_RPAREN = new PhpDocElementType("DOC_TAG_VALUE_RPAREN");
  IElementType DOC_TAG_VALUE_SHARP = new PhpDocElementType("DOC_TAG_VALUE_SHARP");
  IElementType DOC_TAG_VALUE_COMMA = new PhpDocElementType("DOC_TAG_VALUE_COMMA");
  IElementType DOC_TAG_VALUE_LT = new PhpDocElementType("DOC_TAG_VALUE_LT");
  IElementType DOC_TAG_VALUE_GT = new PhpDocElementType("DOC_TAG_VALUE_GT");
  IElementType INLINE_TAG_START = new PhpDocElementType("DOC_INLINE_TAG_START");
  IElementType INLINE_TAG_END = new PhpDocElementType("DOC_INLINE_TAG_END");

  IElementType DOC_UNLIMITED = new PhpDocElementType("DOC_UNLIMITED");
  IElementType DOC_QUESTION_MARK = new PhpDocElementType("DOC_QUESTION_MARK");
  IElementType DOC_ARROW = new PhpDocElementType("DOC_ARROW");
}
