// Copyright 2000-2021 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

public interface PhpControlFlow {
  PhpInstruction @NotNull [] getInstructions();

  @NotNull
  PhpEntryPointInstruction getEntryPoint();

  @NotNull
  PhpExitPointInstruction getExitPoint();

  <T extends PhpInstruction> T getInstruction(PsiElement anchor, Class<T> instructionClass);
  <T extends PhpInstruction> Collection<T> getInstructions(PsiElement anchor, Class<T> instructionClass);
}
