/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.utils.DockerEngineUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerDebugErrorDetector;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.PhpDockerRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerSdkFileTransfer;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeInterpreterForm;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeRemoteProcessRunner;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeTypeData;
import com.jetbrains.php.remote.docker.phpunit.coverage.PhpDockerCoverageResultManager;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.remote.interpreter.ui.PhpInplaceEditRemoteSdkForm;
import com.jetbrains.php.remote.interpreter.ui.PhpInplaceInterpreterForm;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterComponent;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerRemoteProcessManager
extends PhpRemoteProcessManager {
    private static final Logger LOG = Logger.getInstance(PhpDockerRemoteProcessRunner.class);
    private static final String DOCKER_NETWORK = "docker0";
    private static final String DEFAULT_REMOTE_HOST = "10.0.2.2";
    public static final String DOCKER_DEFAULT_REMOTE_HOST = "host.docker.internal";

    public boolean accepts(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(0);
        }
        return data.getRemoteConnectionType() == DockerCredentialsType.getInstance() || data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance();
    }

    @NotNull
    public PhpRemoteProcessRunner getRemoteProcessRunner(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(1);
        }
        if (data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance()) {
            PhpRemoteProcessRunner phpRemoteProcessRunner = PhpDockerComposeRemoteProcessRunner.getInstance();
            if (phpRemoteProcessRunner == null) {
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(2);
            }
            return phpRemoteProcessRunner;
        }
        PhpRemoteProcessRunner phpRemoteProcessRunner = PhpDockerRemoteProcessRunner.getInstance();
        if (phpRemoteProcessRunner == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(3);
        }
        return phpRemoteProcessRunner;
    }

    @NotNull
    public PhpSdkHelpersManager getSdkHelpersManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(4);
        }
        return new PhpDockerHelpersManager(data);
    }

    @NotNull
    public PhpCoverageResultManager getCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(5);
        }
        return new PhpDockerCoverageResultManager(data);
    }

    @NotNull
    public PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(6);
        }
        return new PhpDockerSdkFileTransfer();
    }

    @Nullable
    public PhpDebugErrorDetector newErrorDetector(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data) {
        if (project == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(7);
        }
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(8);
        }
        return new PhpDockerDebugErrorDetector(project);
    }

    @NotNull
    public PhpInplaceInterpreterForm newSdkForm(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull PhpRemoteInterpreterComponent component) {
        if (project == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(9);
        }
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(10);
        }
        if (component == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(11);
        }
        if (data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance()) {
            return new PhpDockerComposeInterpreterForm(project, data, component);
        }
        return new PhpInplaceEditRemoteSdkForm(project, component);
    }

    @Nullable
    public PhpRemoteSdkTypeData loadDataType(@NotNull PhpRemoteSdkAdditionalData data, @Nullable Element type) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(12);
        }
        if (data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance()) {
            return PhpDockerComposeTypeData.load(type);
        }
        return null;
    }

    @Nullable
    public Element saveDataType(@NotNull String name, @NotNull PhpRemoteSdkAdditionalData data) {
        PhpRemoteSdkTypeData typeData;
        if (name == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(14);
        }
        if (data.getRemoteConnectionType() == DockerComposeCredentialsType.getInstance() && (typeData = data.getTypeData()) instanceof PhpDockerComposeTypeData) {
            Element element = new Element(name);
            return ((PhpDockerComposeTypeData)typeData).save(element);
        }
        return null;
    }

    @NotNull
    public Map<String, String> getSdkProperties(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(15);
        }
        final HashMap<String, String> keyToPattern = new HashMap<String, String>();
        data.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                String imageName = credentials.getImageName();
                ContainerUtil.putIfNotNull((Object)"image-name", (Object)StringUtil.nullize((String)imageName), (Map)keyToPattern);
                List split = StringUtil.split((String)imageName, (String)":");
                if (split.size() > 1) {
                    ContainerUtil.putIfNotNull((Object)"image-name-short", (Object)StringUtil.nullize((String)((String)split.get(0))), (Map)keyToPattern);
                }
            }
        }, new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                ContainerUtil.putIfNotNull((Object)"service", (Object)StringUtil.nullize((String)credentials.getComposeServiceName()), (Map)keyToPattern);
            }
        }});
        HashMap<String, String> hashMap = keyToPattern;
        if (hashMap == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getRemoteHost(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpRemoteSdkAdditionalData data) {
        String string;
        block15: {
            block14: {
                String string2;
                if (project == null) {
                    PhpDockerRemoteProcessManager.$$$reportNull$$$0(17);
                }
                if (interpreterName == null) {
                    PhpDockerRemoteProcessManager.$$$reportNull$$$0(18);
                }
                if (data == null) {
                    PhpDockerRemoteProcessManager.$$$reportNull$$$0(19);
                }
                if (SystemInfo.isMac || SystemInfo.isWindows) {
                    return DOCKER_DEFAULT_REMOTE_HOST;
                }
                try {
                    RemoteServer<DockerCloudConfiguration> docker = PhpDockerProcessUtil.getAccount((RemoteSdkAdditionalData)data);
                    if (!DockerEngineUtil.isUnixSocket((DockerCloudConfiguration)((DockerCloudConfiguration)docker.getConfiguration()))) break block14;
                    NetworkInterface docker0 = NetworkInterface.getByName(DOCKER_NETWORK);
                    if (docker0 == null) {
                        throw new RemoteSdkException(PhpBundle.message((String)"dialog.message.could.not.find.network.interface", (Object[])new Object[]{DOCKER_NETWORK}));
                    }
                    String address = PhpDockerRemoteProcessManager.getNetworkAddress(docker0);
                    if (StringUtil.isEmpty((String)address)) {
                        throw new RemoteSdkException(PhpBundle.message((String)"dialog.message.no.interface.addresses.for.network.interface", (Object[])new Object[]{DOCKER_NETWORK}));
                    }
                    string2 = address;
                }
                catch (RemoteSdkException | IllegalStateException | SocketException e) {
                    LOG.warn("Failed to find a host from docker0 network interface", e);
                    break block14;
                }
                if (string2 != null) return string2;
                PhpDockerRemoteProcessManager.$$$reportNull$$$0(20);
                return string2;
            }
            try {
                Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
                while (networks.hasMoreElements()) {
                    String address;
                    NetworkInterface network = networks.nextElement();
                    if (!PhpDockerRemoteProcessManager.accepts(network) || !StringUtil.isNotEmpty((String)(address = PhpDockerRemoteProcessManager.getNetworkAddress(network)))) continue;
                    string = address;
                    break block15;
                }
                return DEFAULT_REMOTE_HOST;
            }
            catch (SocketException e) {
                LOG.warn("Failed to find a local network address", (Throwable)e);
                return DEFAULT_REMOTE_HOST;
            }
        }
        if (string != null) return string;
        PhpDockerRemoteProcessManager.$$$reportNull$$$0(21);
        return string;
    }

    private static boolean accepts(@NotNull NetworkInterface network) {
        if (network == null) {
            PhpDockerRemoteProcessManager.$$$reportNull$$$0(22);
        }
        try {
            return !StringUtil.equalsIgnoreCase((CharSequence)network.getName(), (CharSequence)DOCKER_NETWORK) && !network.isLoopback() && network.isUp();
        }
        catch (SocketException e) {
            LOG.warn("Failed to find a local network address", (Throwable)e);
            return false;
        }
    }

    @Nullable
    private static String getNetworkAddress(NetworkInterface network) {
        String resultAddress = null;
        for (InterfaceAddress address : network.getInterfaceAddresses()) {
            if (address.getBroadcast() != null) {
                return address.getAddress().getHostAddress();
            }
            resultAddress = address.getAddress().getHostAddress();
        }
        return resultAddress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 16, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessManager";
                break;
            }
            case 7: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "network";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcessRunner";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkProperties";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcessRunner";
                break;
            }
            case 2: 
            case 3: 
            case 16: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHelpersManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageResultManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFileTransfer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newErrorDetector";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSdkForm";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDataType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDataType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSdkProperties";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHost";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 16, 20, 21 -> new IllegalStateException(string);
        };
    }
}

