/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.toolWindow;

import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileTargetIndex;
import com.jetbrains.lang.makefile.toolWindow.MakeToolWindowFactory;
import com.jetbrains.lang.makefile.toolWindow.MakefileCellRenderer;
import com.jetbrains.lang.makefile.toolWindow.MakefileTargetNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowAutoscrollToSourceAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowGoToTargetAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowOptions;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowRefreshAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowRunTargetAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowShowSpecialAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowSortAlphabeticallyAction;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowStripeController;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/lang/makefile/toolWindow/MakeToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "init", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createToolWindowContent", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.makefile"})
public final class MakeToolWindowFactory
implements ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ToolWindowEx toolWindowEx = toolWindow instanceof ToolWindowEx ? (ToolWindowEx)toolWindow : null;
        if (toolWindowEx == null || (toolWindowEx = toolWindowEx.getProject()) == null) {
            return;
        }
        ToolWindowEx project = toolWindowEx;
        StartupManager.getInstance((Project)project).runAfterOpened(() -> MakeToolWindowFactory.init$lambda$0((Project)project, toolWindow));
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setTitle(MakefileLangBundle.message("tool.window.title", new Object[0]));
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        MakefileToolWindowOptions options = new MakefileToolWindowOptions(project);
        DumbService.Companion.getInstance(project).runWhenSmart(() -> MakeToolWindowFactory.createToolWindowContent$lambda$2(options, project, contentManager2));
    }

    private static final void init$lambda$0(Project $project, ToolWindow $toolWindow) {
        ToolWindowManager manager = ToolWindowManager.Companion.getInstance($project);
        MakeToolWindowFactory.Companion.updateStripeButton($project, manager, $toolWindow);
    }

    private static final void createToolWindowContent$lambda$2(MakefileToolWindowOptions $options, Project $project, ContentManager $contentManager) {
        UiDataProvider uiDataProvider;
        DefaultTreeModel model = new DefaultTreeModel($options.getRootNode());
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(true);
        UiDataProvider $this$createToolWindowContent_u24lambda_u242_u24lambda_u241 = uiDataProvider = new UiDataProvider(model, $project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super((TreeModel)$model);
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Object[] objectArray = this.getSelectedNodes(MakefileTargetNode.class, arg_0 -> createToolWindowContent.1.tree.1.uiDataSnapshot$lambda$1(createToolWindowContent.1.tree.1::uiDataSnapshot$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
                Object[] selectedNodes = (MakefileTargetNode[])objectArray;
                MakefileTargetNode makefileTargetNode = (MakefileTargetNode)ArraysKt.firstOrNull((Object[])selectedNodes);
                if (makefileTargetNode == null) {
                    return;
                }
                MakefileTargetNode selected = makefileTargetNode;
                DataKey dataKey = CommonDataKeys.PSI_ELEMENT;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT");
                sink.lazy(dataKey, () -> createToolWindowContent.1.tree.1.uiDataSnapshot$lambda$2(selected, this.$project));
            }

            private static final boolean uiDataSnapshot$lambda$0(MakefileTargetNode it) {
                return true;
            }

            private static final boolean uiDataSnapshot$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final PsiElement uiDataSnapshot$lambda$2(MakefileTargetNode $selected, Project $project) {
                PsiFile psiFile = $selected.getParent$intellij_makefile().getPsiFile();
                if (psiFile == null) {
                    return null;
                }
                PsiFile psi = psiFile;
                MakefileTargetIndex makefileTargetIndex = MakefileTargetIndex.Companion.getInstance();
                String string = $selected.getName();
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)psi);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
                return (PsiElement)CollectionsKt.firstOrNull((Iterable)makefileTargetIndex.getTargets(string, $project, globalSearchScope));
            }
        };
        boolean bl = false;
        $this$createToolWindowContent_u24lambda_u242_u24lambda_u241.setCellRenderer((TreeCellRenderer)((Object)new MakefileCellRenderer($project)));
        $this$createToolWindowContent_u24lambda_u242_u24lambda_u241.getSelectionModel().setSelectionMode(1);
        $this$createToolWindowContent_u24lambda_u242_u24lambda_u241.setRootVisible(false);
        $this$createToolWindowContent_u24lambda_u242_u24lambda_u241.setShowsRootHandles(true);
        UiDataProvider tree2 = uiDataProvider;
        TreeUtil.installActions((JTree)((JTree)tree2));
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)tree2);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)tree2)));
        JPanel toolBarPanel = new JPanel(new GridLayout());
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl($project);
        AutoScrollToSourceHandler autoScrollHandler2 = new AutoScrollToSourceHandler($options){
            final /* synthetic */ MakefileToolWindowOptions $options;
            {
                this.$options = $options;
            }

            protected boolean isAutoScrollMode() {
                return this.$options.getAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                this.$options.setAutoScrollToSource(state);
            }
        };
        autoScrollHandler2.install((JTree)tree2);
        MakefileToolWindowRunTargetAction runTargetAction = new MakefileToolWindowRunTargetAction((Tree)tree2, $project, runManager);
        Integer[] integerArray = new Integer[]{10};
        runTargetAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(integerArray), (JComponent)panel);
        tree2.addMouseListener((MouseListener)new MouseAdapter(runTargetAction, tree2){
            final /* synthetic */ MakefileToolWindowRunTargetAction $runTargetAction;
            final /* synthetic */ createToolWindowContent.1.tree.1 $tree;
            {
                this.$runTargetAction = $runTargetAction;
                this.$tree = $tree;
            }

            public void mousePressed(MouseEvent e) {
                MouseEvent mouseEvent = e;
                boolean bl = mouseEvent != null ? mouseEvent.getClickCount() == 2 : false;
                if (bl && e.getButton() == 1) {
                    ActionManager.getInstance().tryToExecute((AnAction)this.$runTargetAction, (InputEvent)e, (Component)((Object)this.$tree), "", true);
                }
            }
        });
        MakefileToolWindowGoToTargetAction goToTargetAction = new MakefileToolWindowGoToTargetAction((Tree)tree2, $project);
        Integer[] integerArray2 = new Integer[]{115};
        goToTargetAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(integerArray2), (JComponent)panel);
        MakefileToolWindowRefreshAction refreshTargets = new MakefileToolWindowRefreshAction(model, $options);
        Integer[] integerArray3 = new Integer[]{116};
        refreshTargets.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(integerArray3), (JComponent)panel);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)runTargetAction);
        group.add((AnAction)refreshTargets);
        group.addSeparator();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)tree2);
        group.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)tree2));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)tree2));
        group.addAction((AnAction)new MakefileToolWindowAutoscrollToSourceAction($options, autoScrollHandler2, (JComponent)tree2));
        group.addSeparator();
        group.addAction((AnAction)new MakefileToolWindowSortAlphabeticallyAction($options, model));
        group.addAction((AnAction)new MakefileToolWindowShowSpecialAction($options, model));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("MakeToolWindowToolbar", (ActionGroup)group, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)tree2);
        toolBarPanel.add(toolbar.getComponent());
        panel.setToolbar((JComponent)toolBarPanel);
        $contentManager.addContent((Content)new ContentImpl((JComponent)panel, "", true));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/lang/makefile/toolWindow/MakeToolWindowFactory$Companion;", "", "<init>", "()V", "updateStripeButton", "", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "shouldDisableStripeButton", "", "intellij.makefile"})
    @SourceDebugExtension(value={"SMAP\nMakeToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakeToolWindowFactory.kt\ncom/jetbrains/lang/makefile/toolWindow/MakeToolWindowFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1761#2,3:163\n*S KotlinDebug\n*F\n+ 1 MakeToolWindowFactory.kt\ncom/jetbrains/lang/makefile/toolWindow/MakeToolWindowFactory$Companion\n*L\n153#1:163,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateStripeButton(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindowManager manager = ToolWindowManager.Companion.getInstance(project);
            ToolWindowEx toolWindowEx = this.getToolWindow(manager);
            if (toolWindowEx == null) {
                return;
            }
            ToolWindowEx toolWindow = toolWindowEx;
            this.updateStripeButton(project, manager, (ToolWindow)toolWindow);
        }

        private final void updateStripeButton(Project project, ToolWindowManager manager, ToolWindow toolWindow) {
            manager.invokeLater(() -> Companion.updateStripeButton$lambda$0(project, manager, toolWindow));
        }

        private final ToolWindowEx getToolWindow(ToolWindowManager manager) {
            ToolWindow toolWindow = manager.getToolWindow("make");
            return toolWindow instanceof ToolWindowEx ? (ToolWindowEx)toolWindow : null;
        }

        private final boolean shouldDisableStripeButton(Project project, ToolWindowManager manager) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
                WindowInfoImpl windowInfo = ((ToolWindowManagerEx)manager).getLayout().getInfo("make");
                if (windowInfo != null && windowInfo.isFromPersistentSettings()) {
                    return false;
                }
                Iterable $this$any$iv = MakefileToolWindowStripeController.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MakefileToolWindowStripeController it = (MakefileToolWindowStripeController)element$iv;
                        boolean bl2 = false;
                        if (!it.shouldHideStripeIconFor(project)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final void updateStripeButton$lambda$0(Project $project, ToolWindowManager $manager, ToolWindow $toolWindow) {
            if (Companion.shouldDisableStripeButton($project, $manager)) {
                $toolWindow.setShowStripeButton(false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

