/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.hooks.DrupalHooksIndex;
import com.jetbrains.php.drupal.init.DrupalExtensionMappingChecker;
import com.jetbrains.php.drupal.init.DrupalFormattingManager;
import com.jetbrains.php.drupal.init.DrupalIncludePathsManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DrupalConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DrupalDataService
implements PersistentStateComponent<State>,
Disposable {
    private static final String DRUPAL_PATH_PROPERTY = "drupal.support.drupalPath";
    private static final String DRUPAL_VERSION_PROPERTY = "drupal.support.drupalVersion";
    private static final int DRUPAL_VERSION_DEFAULT_VALUE = 0;
    @NotNull
    private final Project myProject;
    private boolean isEnabled;
    private String myDrupalPath;
    private DrupalVersion myVersion;
    private boolean myUpdateIncludePath;
    private boolean myDoNotAskAgain;

    public static DrupalDataService getInstance(Project project) {
        return (DrupalDataService)project.getService(DrupalDataService.class);
    }

    public DrupalDataService(@NotNull Project project) {
        if (project == null) {
            DrupalDataService.$$$reportNull$$$0(0);
        }
        this.myUpdateIncludePath = true;
        this.myProject = project;
    }

    public void setState(State state) {
        State oldState = this.getState();
        this.loadState(state);
        this.notifyListeners(state, oldState);
    }

    @NlsSafe
    public String getDrupalPath() {
        return this.myDrupalPath;
    }

    @Nullable
    public static String getLastDrupalPath() {
        return PropertiesComponent.getInstance().getValue(DRUPAL_PATH_PROPERTY);
    }

    @Nullable
    public static DrupalVersion getLastDrupalVersion() {
        int version = PropertiesComponent.getInstance().getInt(DRUPAL_VERSION_PROPERTY, 0);
        return DrupalVersion.getFromNumber(version);
    }

    public boolean isConfigValid() {
        return this.isVersionValid() && DrupalUtil.validateDrupalFolder(this.getDrupalPath(), this.getVersion()) == null;
    }

    public boolean isVersionValid() {
        return this.myVersion != null;
    }

    public DrupalVersion getVersion() {
        return this.myVersion;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isUpdateIncludePath() {
        return this.myUpdateIncludePath;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    public void setDoNotAskAgain(boolean doNotAsk) {
        this.myDoNotAskAgain = doNotAsk;
    }

    private void notifyListeners(State newState, State oldState) {
        if (newState.equals(oldState)) {
            return;
        }
        DrupalIncludePathsManager.getInstance().refreshIncludePaths(newState, oldState, this.myProject);
        DrupalHooksIndex.reindexIfNeeded(newState, oldState);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DrupalFormattingManager.offerDrupalFormatting(newState, oldState, this.myProject);
        }
        DrupalExtensionMappingChecker.checkFileTypeAssociation(this.myProject);
    }

    public void dispose() {
    }

    @NotNull
    public State getState() {
        return new State(this.isEnabled, this.myDrupalPath, this.myVersion == null ? 0 : this.myVersion.getNumber(), this.myUpdateIncludePath, this.myDoNotAskAgain);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DrupalDataService.$$$reportNull$$$0(1);
        }
        this.isEnabled = state.isEnabled();
        this.myDrupalPath = state.getDrupalPath();
        this.myVersion = DrupalVersion.getFromNumber(state.getVersion());
        this.myUpdateIncludePath = state.isUpdateIncludePath();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/drupal/settings/DrupalDataService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag
    public static class State {
        private boolean isEnabled;
        private String myDrupalPath;
        private int myVersion;
        private boolean myUpdateIncludePath = true;
        private boolean myDoNotAskAgain;

        public State() {
        }

        public State(boolean enabled, String drupalPath, int version, boolean updateIncludePath, boolean doNotAskAgain) {
            this.isEnabled = enabled;
            this.myDrupalPath = drupalPath;
            this.myVersion = version;
            this.myUpdateIncludePath = updateIncludePath;
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        @Tag(value="drupalPath")
        public String getDrupalPath() {
            return this.myDrupalPath;
        }

        public void setDrupalPath(String drupalPath) {
            this.myDrupalPath = drupalPath;
        }

        public void setDrupalPathVersionAndUpdateLastUsed(String drupalPath, @Nullable DrupalVersion version) {
            this.setDrupalPath(drupalPath);
            this.setVersion(version == null ? 0 : version.getNumber());
            if (!StringUtil.isEmptyOrSpaces((String)drupalPath)) {
                PropertiesComponent.getInstance().setValue(DrupalDataService.DRUPAL_PATH_PROPERTY, drupalPath);
            }
            PropertiesComponent.getInstance().setValue(DrupalDataService.DRUPAL_VERSION_PROPERTY, version == null ? 0 : version.getNumber(), 0);
        }

        @Attribute(value="version")
        public int getVersion() {
            return this.myVersion;
        }

        public void setVersion(int version) {
            this.myVersion = version;
        }

        @Attribute(value="updateIncludePath")
        public boolean isUpdateIncludePath() {
            return this.myUpdateIncludePath;
        }

        public void setUpdateIncludePath(boolean updateIncludePath) {
            this.myUpdateIncludePath = updateIncludePath;
        }

        @Attribute(value="doNotAskAgain")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.isEnabled != state.isEnabled) {
                return false;
            }
            if (this.myDoNotAskAgain != state.myDoNotAskAgain) {
                return false;
            }
            if (this.myUpdateIncludePath != state.myUpdateIncludePath) {
                return false;
            }
            if (this.myVersion != state.myVersion) {
                return false;
            }
            return Objects.equals(this.myDrupalPath, state.myDrupalPath);
        }

        public int hashCode() {
            int result = this.isEnabled ? 1 : 0;
            result = 31 * result + (this.myDrupalPath != null ? this.myDrupalPath.hashCode() : 0);
            result = 31 * result + this.myVersion;
            result = 31 * result + (this.myUpdateIncludePath ? 1 : 0);
            result = 31 * result + (this.myDoNotAskAgain ? 1 : 0);
            return result;
        }
    }
}

