/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.hooks.DrupalHookIndexDescription;
import com.jetbrains.php.drupal.hooks.DrupalHooksIndex;
import com.jetbrains.php.drupal.hooks.DrupalHooksUtils;
import com.jetbrains.php.drupal.hooks.NameSuffixFilesScope;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrupalHooksCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String HOOK_IMPLEMENTATION_DOC_COMMENT_TEMPLATE_NAME = "Drupal Hook Implementation Doc Comment";
    private static final String HOOK_NAME_ATTR = "HOOK_NAME";

    public DrupalHooksCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(PhpTokenTypes.IDENTIFIER)).withParent((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)PhpStubElementTypes.FUNCTION)), new DrupalHooksCompletionProvider());
    }

    private static Collection<String> getAllHooksInvocationsFromIndex(@NotNull PrefixMatcher prefixMatcher, String moduleName, DrupalVersion version, Project project) {
        if (prefixMatcher == null) {
            DrupalHooksCompletionContributor.$$$reportNull$$$0(0);
        }
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        FileBasedIndex index = FileBasedIndex.getInstance();
        index.processAllKeys(DrupalHooksIndex.KEY, (Processor)processor, project);
        String prefix = moduleName + "_";
        ArrayList<String> filtered = new ArrayList<String>();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        for (DrupalHookIndexDescription result : processor.getResults()) {
            Collection fileCollection;
            String hookImplementationText;
            if (!result.suits(version) || !prefixMatcher.prefixMatches(hookImplementationText = prefix + result.getName()) || (fileCollection = index.getContainingFiles(DrupalHooksIndex.KEY, (Object)result, searchScope)).isEmpty()) continue;
            filtered.add(hookImplementationText);
        }
        return filtered;
    }

    private static Collection<String> getAllHooksInvocationsFromDocs(@NotNull PrefixMatcher prefixMatcher, String moduleName, Project project) {
        if (prefixMatcher == null) {
            DrupalHooksCompletionContributor.$$$reportNull$$$0(1);
        }
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        FileBasedIndex.getInstance().processAllKeys(PhpFunctionNameIndex.KEY, (Processor)processor, project);
        ArrayList<String> filtered = new ArrayList<String>();
        NameSuffixFilesScope.ApiFilesScope apiFilesScope = new NameSuffixFilesScope.ApiFilesScope(project);
        Collection results = processor.getResults();
        String prefix = moduleName + "_";
        for (String key : results) {
            Collection fileCollection;
            String hookImplementationText;
            if (!key.startsWith("hook_") || !prefixMatcher.prefixMatches(hookImplementationText = prefix + key.substring("hook_".length())) || (fileCollection = FileBasedIndex.getInstance().getContainingFiles(PhpFunctionNameIndex.KEY, (Object)key, (GlobalSearchScope)apiFilesScope)).isEmpty()) continue;
            filtered.add(hookImplementationText);
        }
        return filtered;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "prefixMatcher";
        objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHooksCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllHooksInvocationsFromIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllHooksInvocationsFromDocs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DrupalHooksCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private DrupalHooksCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                DrupalHooksCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DrupalHooksCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                DrupalHooksCompletionProvider.$$$reportNull$$$0(2);
            }
            PrefixMatcher prefixMatcher = result.getPrefixMatcher();
            if (parameters.getInvocationCount() < 2 && prefixMatcher.getPrefix().isEmpty()) {
                return;
            }
            Project project = parameters.getOriginalFile().getProject();
            DrupalDataService service = DrupalDataService.getInstance(project);
            if (!service.isEnabled()) {
                return;
            }
            DrupalVersion drupalVersion = service.getVersion();
            if (drupalVersion == null) {
                return;
            }
            PsiFile psiFile = parameters.getOriginalFile();
            String hookBaseName = DrupalUtil.getHookBaseName(psiFile.getVirtualFile(), null, project);
            if (hookBaseName == null) {
                return;
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            if (position instanceof LeafPsiElement && parent instanceof Function && position.getNode().getElementType() == PhpTokenTypes.IDENTIFIER) {
                Collection<String> functionNamesFromIndex = DrupalHooksCompletionContributor.getAllHooksInvocationsFromIndex(prefixMatcher, hookBaseName, drupalVersion, project);
                Collection<String> functionNamesFromDocs = DrupalHooksCompletionContributor.getAllHooksInvocationsFromDocs(prefixMatcher, hookBaseName, project);
                HashSet<String> functionNames = new HashSet<String>();
                functionNames.addAll(functionNamesFromIndex);
                functionNames.addAll(functionNamesFromDocs);
                for (String name : functionNames) {
                    result.addElement((LookupElement)new HookImplementationLookupElement(name, hookBaseName));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/drupal/hooks/DrupalHooksCompletionContributor$DrupalHooksCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class HookImplementationLookupElement
    extends LookupElement {
        private final String myFunctionName;
        private final String myModuleName;

        private HookImplementationLookupElement(String functionName, String moduleName) {
            this.myFunctionName = functionName;
            this.myModuleName = moduleName;
        }

        @NotNull
        public String getLookupString() {
            String string = this.myFunctionName;
            if (string == null) {
                HookImplementationLookupElement.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void handleInsert(@NotNull InsertionContext context) {
            ParameterList parameterList;
            if (context == null) {
                HookImplementationLookupElement.$$$reportNull$$$0(1);
            }
            Editor editor = context.getEditor();
            super.handleInsert(context);
            Function docFunction = DrupalHooksUtils.getDescriptiveFunctionByHookName(this.getSimpleHookName(), context.getProject());
            Object parameterListText = "";
            if (docFunction != null && (parameterList = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)docFunction, (Condition)ParameterList.INSTANCEOF)) != null) {
                parameterListText = parameterList.getText();
            }
            parameterListText = "(" + (String)parameterListText + ")";
            PhpInsertHandlerUtil.insertStringAtCaret((Editor)editor, (String)parameterListText);
            HookImplementationLookupElement.completeFunction(editor, context.getProject());
            HookImplementationLookupElement.insertDocComment(this.getSimpleHookName(), context);
        }

        private static void completeFunction(Editor editor, @NotNull Project project) {
            if (project == null) {
                HookImplementationLookupElement.$$$reportNull$$$0(2);
            }
            DataContext context = SimpleDataContext.getProjectContext((Project)project);
            Caret caret = editor.getCaretModel().getCurrentCaret();
            EditorActionManager.getInstance().getActionHandler("EditorCompleteStatement").execute(editor, caret, context);
        }

        private static void insertDocComment(String simpleHookName, InsertionContext context) {
            PsiElement element = context.getFile().findElementAt(context.getStartOffset());
            if (element == null) {
                return;
            }
            IElementType elementType = element.getNode().getElementType();
            if (elementType != PhpTokenTypes.IDENTIFIER) {
                return;
            }
            PsiElement beforeElement = element.getParent();
            if (beforeElement instanceof Field || beforeElement instanceof Constant) {
                beforeElement = beforeElement.getParent();
            }
            if (beforeElement == null) {
                return;
            }
            PhpDocComment docComment = HookImplementationLookupElement.constructDocComment(simpleHookName, context.getProject());
            if (docComment != null) {
                PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange((PsiElement)beforeElement, (PhpDocComment)docComment);
            }
        }

        @Nullable
        private static PhpDocComment constructDocComment(String simpleHookName, Project project) {
            StringBuilder builder = new StringBuilder();
            builder.append("<?php\n");
            HookImplementationLookupElement.generateContent(simpleHookName, builder, project);
            PhpDocComment docComment = (PhpDocComment)PhpPsiElementFactory.createFromText((Project)project, PhpDocComment.class, (String)builder.toString());
            if (docComment == null) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Drupal", (String)DrupalBundle.message("drupal.title", new Object[0])), DrupalBundle.message("drupal.invalid.template", new Object[0]), DrupalBundle.message("drupal.can.not.build.a.php.doc.comment.0", builder.toString()), NotificationType.ERROR));
                } else assert (false) : "Invalid Drupal PHP Doc Comment Template.";
                docComment = (PhpDocComment)PhpPsiElementFactory.createFromText((Project)project, PhpDocComment.class, (String)"/**\n *\n */");
            }
            return docComment;
        }

        private static void generateContent(String simpleHookName, StringBuilder builder, Project project) {
            String docText = HookImplementationLookupElement.getTemplate(simpleHookName, project);
            if (docText != null && !HookImplementationLookupElement.isEmptyDoc(docText)) {
                try {
                    docText = Pattern.compile("(\\s*\\n)+").matcher(StringUtil.newBombedCharSequence((CharSequence)docText, (long)1000L)).replaceAll("\n");
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                builder.append(docText);
                return;
            }
            builder.append("/**\n *\n */");
        }

        @Nullable
        private static String getTemplate(String simpleHookName, Project project) {
            String template;
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getPattern(DrupalHooksCompletionContributor.HOOK_IMPLEMENTATION_DOC_COMMENT_TEMPLATE_NAME);
            if (fileTemplate == null) {
                return null;
            }
            Properties attributes = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            attributes.setProperty(DrupalHooksCompletionContributor.HOOK_NAME_ATTR, simpleHookName);
            try {
                template = fileTemplate.getText(attributes);
            }
            catch (IOException e) {
                template = fileTemplate.getText();
            }
            return template;
        }

        private static boolean isEmptyDoc(@NotNull String docText) {
            String textToCheck;
            if (docText == null) {
                HookImplementationLookupElement.$$$reportNull$$$0(3);
            }
            if ((textToCheck = docText.trim()).isEmpty()) {
                return true;
            }
            for (int i = 0; i < textToCheck.length(); ++i) {
                char c = textToCheck.charAt(i);
                if (c == '*' || c == '/' || Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public String getSimpleHookName() {
            assert (this.myFunctionName.startsWith(this.myModuleName + "_")) : "funName = " + this.myFunctionName + ", moduleName = " + this.myModuleName;
            String string = this.myFunctionName.substring(this.myModuleName.length() + 1);
            if (string == null) {
                HookImplementationLookupElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/drupal/hooks/DrupalHooksCompletionContributor$HookImplementationLookupElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHooksCompletionContributor$HookImplementationLookupElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleHookName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "completeFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmptyDoc";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

