/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.hooks.DrupalHooksUtils;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import icons.DrupalIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DrupalHookDocLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            DrupalHookDocLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            DrupalHookDocLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            DrupalHookDocLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return;
        }
        DrupalDataService dataService = DrupalDataService.getInstance(elements.get(0).getProject());
        if (!dataService.isEnabled() || !dataService.isVersionValid()) {
            return;
        }
        ArrayList<String> functionNamesCache = new ArrayList<String>();
        HashMap<VirtualFile, String> moduleNamesCache = new HashMap<VirtualFile, String>();
        for (PsiElement psiElement : elements) {
            DrupalHookDocLineMarkerProvider.handlePotentialDoc(psiElement, result, functionNamesCache, moduleNamesCache);
        }
    }

    private static void handlePotentialDoc(PsiElement element, Collection<? super LineMarkerInfo<?>> result, List<String> functionNamesCache, @NotNull Map<VirtualFile, String> moduleNamesCache) {
        String hookFunctionName;
        if (moduleNamesCache == null) {
            DrupalHookDocLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((hookFunctionName = DrupalHooksUtils.getHookNameFromDocFunction(element)) == null) {
            return;
        }
        Project project = element.getProject();
        String hookName = hookFunctionName.substring("hook_".length());
        if (functionNamesCache.isEmpty()) {
            functionNamesCache.addAll(PhpIndex.getInstance((Project)project).getAllFunctionNames(null));
        }
        GlobalSearchScope modulesFilesScope = GlobalSearchScope.allScope((Project)project);
        ArrayList<Function> impls = new ArrayList<Function>();
        for (String functionName : functionNamesCache) {
            if (!functionName.endsWith(hookName)) continue;
            Collection functionCollection = StubIndex.getElements((StubIndexKey)PhpFunctionIndex.KEY, (Object)functionName, (Project)project, (GlobalSearchScope)modulesFilesScope, Function.class);
            for (Function function : functionCollection) {
                if (!hookName.equals(DrupalHooksUtils.getPotentialHookName((PsiElement)function, moduleNamesCache))) continue;
                impls.add(function);
            }
        }
        if (impls.isEmpty()) {
            return;
        }
        PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
        result.add(new LineMarkerInfo(anchor, anchor.getTextRange(), DrupalIcons.ImplementedHook, (com.intellij.util.Function)new HookDocTooltipGenerator(impls), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(impls, DrupalBundle.message("drupal.choose.implementation.of.hook.0", hookName)), GutterIconRenderer.Alignment.LEFT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesCache";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHookDocLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePotentialDoc";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HookDocTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final List<? extends Function> myImpls;

        private HookDocTooltipGenerator(List<? extends Function> impls) {
            this.myImpls = impls;
        }

        public String fun(PsiElement __) {
            if (this.myImpls.size() > 6) {
                return DrupalBundle.message("drupal.has.implementations", new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(DrupalBundle.message("drupal.is.implemented.in", new Object[0])).append("<br/>");
            HashSet<String> fileNames = new HashSet<String>();
            boolean hasRealInvocations = false;
            for (Function function : this.myImpls) {
                PsiFile file = function.getContainingFile();
                if (file == null) continue;
                String fileName = file.getName();
                if (!fileNames.contains(fileName)) {
                    sb.append(" '").append(fileName).append("'").append("<br/>");
                    fileNames.add(fileName);
                }
                hasRealInvocations = true;
            }
            return hasRealInvocations ? sb.toString() : DrupalBundle.message("drupal.has.implementations", new Object[0]);
        }
    }
}

