/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class CreateTemplateFix
implements LocalQuickFix {
    private static final String DUMMY_NS = "urn:x__dummy__";
    private static final String DUMMY_TAG = "<dummy xmlns='urn:x__dummy__' />";
    private final String myName;

    public CreateTemplateFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = XPathBundle.message("intention.name.create.template", this.myName);
        if (string == null) {
            CreateTemplateFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.create.template", new Object[0]);
        if (string == null) {
            CreateTemplateFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        VirtualFile file;
        XmlTag myTag;
        XmlTag tag;
        if (project == null) {
            CreateTemplateFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CreateTemplateFix.$$$reportNull$$$0(3);
        }
        if ((tag = XsltCodeInsightUtil.getTemplateTag((PsiElement)(myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class)), false)) == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        assert (parentTag != null);
        XmlTag templateTag = parentTag.createChildTag("template", "http://www.w3.org/1999/XSL/Transform", DUMMY_TAG, false);
        templateTag.setAttribute("name", this.myName);
        XmlTag[] arguments = myTag.findSubTags("with-param", "http://www.w3.org/1999/XSL/Transform");
        if (arguments.length > 0) {
            XmlTag dummy = templateTag.findFirstSubTag("dummy");
            for (XmlTag arg : arguments) {
                String argName = arg.getAttributeValue("name");
                if (argName == null) continue;
                XmlTag paramTag = parentTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
                paramTag.setAttribute("name", argName);
                templateTag.addBefore((PsiElement)paramTag, (PsiElement)dummy);
            }
        }
        if ((file = myTag.getContainingFile().getVirtualFile()) == null) {
            return;
        }
        XmlTag newTemplateTag = (XmlTag)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)templateTag);
        Navigatable openFileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(project, file, newTemplateTag.getTextRange().getStartOffset());
        openFileDescriptor.navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

