/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddParamBase
extends AbstractFix {
    protected abstract String getParamName();

    @Nullable
    protected abstract XmlTag findTemplateTag();

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            AddParamBase.$$$reportNull$$$0(0);
        }
        XmlTag templateTag = this.findTemplateTag();
        assert (templateTag != null);
        XmlTag paramTag = templateTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
        paramTag.setAttribute("name", this.getParamName());
        RefactoringUtil.addParameter(templateTag, paramTag);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AddParamBase", "invoke"));
    }
}

