/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass;

import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Cluster;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Distance;

public class AverageClusterDistance<T>
implements Distance<Cluster<T>> {
    private final Distance<? super T> myDistanceOperator;

    public AverageClusterDistance(Distance<? super T> distanceOperator) {
        this.myDistanceOperator = distanceOperator;
    }

    @Override
    public double distance(Cluster<T> cluster1, Cluster<T> cluster2) {
        double distanceSum = 0.0;
        for (T entity1 : cluster1.getEntities()) {
            for (T entity2 : cluster2.getEntities()) {
                distanceSum += this.myDistanceOperator.distance(entity1, entity2);
            }
        }
        return distanceSum / (double)(cluster1.getEntities().size() * cluster2.getEntities().size());
    }
}

