/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.architecture.complexityMetrics.PhpRecursiveElementWalkingVisitor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.While;

public class CyclomaticComplexityVisitor
extends PhpRecursiveElementWalkingVisitor {
    private static final int STRICT_LIMIT = 100;
    private Ref<Integer> myCounter = new Ref((Object)1);

    public void visitPhpIf(If ifStatement) {
        this.increaseValueOrStop();
        super.visitPhpIf(ifStatement);
    }

    public void visitPhpForeach(ForeachStatement foreach) {
        this.increaseValueOrStop();
        super.visitPhpForeach(foreach);
    }

    public void visitPhpElseIf(ElseIf elseIfStatement) {
        this.increaseValueOrStop();
        super.visitPhpElseIf(elseIfStatement);
    }

    public void visitPhpWhile(While whileStatement) {
        this.increaseValueOrStop();
        super.visitPhpWhile(whileStatement);
    }

    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.increaseValueOrStop();
        super.visitPhpDoWhile(doWhileStatement);
    }

    public void visitPhpFor(For forStatement) {
        this.increaseValueOrStop();
        super.visitPhpFor(forStatement);
    }

    public void visitPhpSwitch(PhpSwitch switchStatement) {
        this.increaseValueOrStop(switchStatement.getAllCases().length);
        super.visitPhpSwitch(switchStatement);
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        if (matchExpression.getDefaultMatchArm() != null) {
            this.increaseValueOrStop();
        }
        this.increaseValueOrStop(matchExpression.getMatchArms().size());
        super.visitPhpMatchExpression(matchExpression);
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        PsiElement expressionOperation = expression.getOperation();
        if (PhpPsiUtil.isOfType((PsiElement)expressionOperation, (TokenSet)PhpTokenTypes.tsLOGICAL_OPS) || PhpPsiUtil.isOfType((PsiElement)expressionOperation, (IElementType)PhpTokenTypes.opCOALESCE)) {
            this.increaseValueOrStop();
        }
        super.visitPhpBinaryExpression(expression);
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.increaseValueOrStop();
        super.visitPhpTernaryExpression(expression);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        if (fieldReference.hasNullSafeDereference()) {
            this.increaseValueOrStop();
        }
        super.visitPhpFieldReference(fieldReference);
    }

    public void visitPhpMethodReference(MethodReference reference) {
        if (reference.hasNullSafeDereference()) {
            this.increaseValueOrStop();
        }
        super.visitPhpMethodReference(reference);
    }

    public void visitPhpCatch(Catch phpCatch) {
        this.increaseValueOrStop();
        super.visitPhpCatch(phpCatch);
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        if (PhpPsiUtil.isOfType((PsiElement)expression.getOperation(), (IElementType)PhpTokenTypes.opCOALESCE_ASGN)) {
            this.increaseValueOrStop();
        }
        super.visitPhpSelfAssignmentExpression(expression);
    }

    private void increaseValueOrStop() {
        this.increaseValueOrStop(1);
    }

    private void increaseValueOrStop(int value) {
        if ((Integer)this.myCounter.get() == 100) {
            this.stopWalking();
        } else {
            this.myCounter.set((Object)((Integer)this.myCounter.get() + value));
        }
    }

    public int getValue() {
        return (Integer)this.myCounter.get();
    }

    public void reset() {
        this.myCounter = new Ref((Object)1);
    }
}

