/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.PhpFeatureEnvyLocalInspection;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpDialog;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpHandler;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpMemberCanBePulledUpInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMemberCanBePulledUpInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PhpClass containingClass = method.getContainingClass();
                if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR || PhpFeatureEnvyLocalInspection.isTestMethod(method) || PhpLangUtil.isMagicMethod((CharSequence)method.getName())) {
                    return;
                }
                if (containingClass == null) {
                    return;
                }
                PhpIndex index = PhpIndex.getInstance((Project)method.getProject());
                @NotNull List superClasses = PhpPullUpHandler.collectAllParentClasses((PhpClass)containingClass);
                if (!PhpClassHierarchyUtils.hasSuperMethod((Method)method)) {
                    for (PhpClass superClass : superClasses) {
                        Collection subclasses = index.getDirectSubclasses(superClass.getFQN());
                        if (subclasses.size() <= 1 || !PhpMemberCanBePulledUpInspection.allSubClassesHasSimilarMethod(method, superClass, subclasses)) continue;
                        this.registerProblem(containingClass, method.getNameIdentifier(), PhpArchitectureBundle.message("inspection.php.method.can.be.pulled.up.to.class.0", superClass.getFQN()));
                        break;
                    }
                }
                super.visitPhpMethod(method);
            }

            private void registerProblem(PhpClass containingClass, PsiElement identifier, @NotNull @Nls String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (identifier != null) {
                    holder.registerProblem(identifier, message, new LocalQuickFix[]{new MyPhpQuickFixBase(containingClass)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpMemberCanBePulledUpInspection$1", "registerProblem"));
            }
        };
    }

    private static boolean allSubClassesHasSimilarMethod(Method method, PhpClass clazz, Collection<PhpClass> subclasses) {
        if (clazz.findMethodByName((CharSequence)method.getName()) != null) {
            return false;
        }
        for (PhpClass subclass : subclasses) {
            Method methodByName = subclass.findMethodByName((CharSequence)method.getName());
            if (methodByName != null && PhpMemberCanBePulledUpInspection.areDeclarationsFullyCompatible(method, methodByName)) continue;
            return false;
        }
        return true;
    }

    public static boolean areDeclarationsFullyCompatible(@NotNull Method childMethod, @NotNull Method superMethod) {
        if (childMethod == null) {
            PhpMemberCanBePulledUpInspection.$$$reportNull$$$0(1);
        }
        if (superMethod == null) {
            PhpMemberCanBePulledUpInspection.$$$reportNull$$$0(2);
        }
        return PhpHierarchyChecksInspection.areDeclarationsFullyCompatible((Method)childMethod, (Method)superMethod, (PhpClass)childMethod.getContainingClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpMemberCanBePulledUpInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areDeclarationsFullyCompatible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPhpQuickFixBase
    extends LocalQuickFixOnPsiElement {
        private MyPhpQuickFixBase(PhpClass containingClass) {
            super((PsiElement)containingClass);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpArchitectureBundle.message("quickfix.php.pull.up.member", new Object[0]);
            if (string == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(5);
            }
            PhpClass containingClass = (PhpClass)this.getStartElement();
            List superClasses = PhpPullUpHandler.collectAllParentClasses((PhpClass)containingClass);
            PhpPullUpDialog dialog = new PhpPullUpDialog(project, containingClass, (Collection)superClasses, new PhpMemberInfoStorage(containingClass));
            dialog.show();
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(6);
            }
            if (previewDescriptor == null) {
                MyPhpQuickFixBase.$$$reportNull$$$0(7);
            }
            return new IntentionPreviewInfo.Html(PhpArchitectureBundle.message("show.pull.members.up.dialog", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpMemberCanBePulledUpInspection$MyPhpQuickFixBase";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpMemberCanBePulledUpInspection$MyPhpQuickFixBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

