/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.clazz;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.calculators.LCOM4MetricsCalculator;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpExtractClassQuickFix;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.CyclomaticComplexityVisitor;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.PhpAccessesToDataMetric;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpComplexClassInspection
extends PhpInspection {
    public static final double TCC_THRESHOLD = 0.333;
    public static final int WMC_THRESHOLD = 50;
    public static final int ATFD_THRESHOLD = 5;
    public double myTccThreshold = 0.333;
    public int myWmcThreshold = 50;
    public int myAtfdThreshold = 5;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpComplexClassInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                PsiElement nameIdentifier;
                if (PhpComplexClassInspection.isClassComplex(PhpComplexClassInspection.this.myAtfdThreshold, PhpComplexClassInspection.this.myTccThreshold, PhpComplexClassInspection.this.myWmcThreshold, clazz) && (nameIdentifier = clazz.getNameIdentifier()) != null) {
                    holder.registerProblem(nameIdentifier, PhpArchitectureBundle.message("inspection.php.complex.clazz.message.complex.class.should.be.refactored", new Object[0]), new LocalQuickFix[]{new PhpExtractClassQuickFix(clazz)});
                }
            }
        };
    }

    public static boolean isClassComplex(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpComplexClassInspection.$$$reportNull$$$0(1);
        }
        return PhpComplexClassInspection.isClassComplex(5, 0.333, 50, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassComplex(int atfdThreshold, double tccThreshold, int wmcThreshold, @NotNull PhpClass phpClass) {
        void clazz;
        if (phpClass == null) {
            PhpComplexClassInspection.$$$reportNull$$$0(2);
        }
        int wmc = PhpComplexClassInspection.getWmc((PhpClass)clazz);
        double tcc = new LCOM4MetricsCalculator((PhpClass)clazz).getTcc();
        PhpAccessesToDataMetric accessesToDataMetric = new PhpAccessesToDataMetric((PhpClass)clazz);
        int accessesToDataMetricAccessToForeignDataMetric = accessesToDataMetric.getAccessToForeignDataMetric();
        return wmc > wmcThreshold && tcc < tccThreshold && accessesToDataMetricAccessToForeignDataMetric > atfdThreshold;
    }

    public static int getWmc(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpComplexClassInspection.$$$reportNull$$$0(3);
        }
        int wmc = 0;
        for (Method method : clazz.getOwnMethods()) {
            if (!PhpComplexClassInspection.isMemberToConsider((PhpClassMember)method)) continue;
            CyclomaticComplexityVisitor cyclomaticComplexityVisitor = new CyclomaticComplexityVisitor();
            method.accept((PsiElementVisitor)cyclomaticComplexityVisitor);
            wmc += cyclomaticComplexityVisitor.getValue();
        }
        return wmc;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myTccThreshold", (String)PhpArchitectureBundle.message("inspection.php.complex.class.tcc.threshold", new Object[0]), (int)0, (int)2), OptPane.number((String)"myWmcThreshold", (String)PhpArchitectureBundle.message("inspection.php.complex.class.wmc.threshold", new Object[0]), (int)0, (int)Integer.MAX_VALUE), OptPane.number((String)"myAtfdThreshold", (String)PhpArchitectureBundle.message("inspection.php.complex.class.atfd.threshold", new Object[0]), (int)0, (int)Integer.MAX_VALUE)});
        if (optPane == null) {
            PhpComplexClassInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    public static boolean isMemberToConsider(PhpClassMember e) {
        return (!(e instanceof Method) || !((Method)e).isAbstract()) && !(e instanceof PhpDocMethod) && !(e instanceof PhpDocProperty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpComplexClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpComplexClassInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isClassComplex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWmc";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

