/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.jetbrains.php.behat.steps.BehatPatternPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class BehatTurnipPatterPolicy
implements BehatPatternPolicy {
    public static final BehatTurnipPatterPolicy INSTANCE = new BehatTurnipPatterPolicy();
    @VisibleForTesting
    public static final String ANY_TOKEN = "((\"[^\"]+\")|('[^']+')|(\\w+([.,]\\w+)?))";

    private BehatTurnipPatterPolicy() {
    }

    @Override
    public boolean isApplicable(@NotNull String regex) {
        if (regex == null) {
            BehatTurnipPatterPolicy.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @NotNull
    public String process(@NotNull String regex) {
        if (regex == null) {
            BehatTurnipPatterPolicy.$$$reportNull$$$0(1);
        }
        String str = BehatTurnipPatterPolicy.replaceOptionalWordToken(regex);
        str = BehatTurnipPatterPolicy.replaceAlternativeWordToken(str);
        String string = str = BehatTurnipPatterPolicy.replacePlaceholderWordToken(str);
        if (string == null) {
            BehatTurnipPatterPolicy.$$$reportNull$$$0(2);
        }
        return string;
    }

    @VisibleForTesting
    public static String replaceOptionalWordToken(String regex) {
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int prevI = 0;
        while ((i = regex.indexOf(40, i + 1)) >= 0) {
            boolean left = i > 0 && Character.isWhitespace(regex.charAt(i - 1));
            int start = i;
            while (i + 1 < regex.length() && (BehatTurnipPatterPolicy.isLiteralCharacter(regex.charAt(i + 1)) || Character.isWhitespace(regex.charAt(i + 1)))) {
                ++i;
            }
            if (i <= start || i + 1 >= regex.length() || regex.charAt(i + 1) != ')') continue;
            boolean right = ++i + 1 < regex.length() && Character.isWhitespace(regex.charAt(i + 1));
            sb.append(regex, prevI, left ? start - 1 : start);
            sb.append("(");
            if (left) {
                sb.append("( )?");
            } else {
                sb.append("()?");
            }
            sb.append(regex, start, i + 1);
            sb.append("?");
            if (right) {
                sb.append("( )?");
                ++i;
            } else {
                sb.append("()?");
            }
            sb.append(")");
            prevI = i + 1;
        }
        sb.append(regex, prevI, regex.length());
        return sb.toString();
    }

    @VisibleForTesting
    public static String replaceAlternativeWordToken(String regex) {
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int prevI = 0;
        while ((i = regex.indexOf(47, i + 1)) > 0) {
            int l = i;
            int r = i;
            while (l - 1 >= prevI && BehatTurnipPatterPolicy.isLiteralCharacter(regex.charAt(l - 1))) {
                --l;
            }
            while (r + 1 < regex.length() && BehatTurnipPatterPolicy.isLiteralCharacter(regex.charAt(r + 1))) {
                ++r;
            }
            if (l >= i || r <= i) continue;
            sb.append(regex, prevI, l);
            sb.append('(');
            sb.append(regex, l, i);
            sb.append('|');
            sb.append(regex, i + 1, r + 1);
            sb.append(')');
            i = r;
            prevI = i + 1;
        }
        sb.append(regex, prevI, regex.length());
        return sb.toString();
    }

    @VisibleForTesting
    public static String replacePlaceholderWordToken(String regex) {
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int prevI = 0;
        while ((i = regex.indexOf(58, i + 1)) >= 0) {
            int start = i;
            while (i + 1 < regex.length() && BehatTurnipPatterPolicy.isLiteralCharacter(regex.charAt(i + 1))) {
                ++i;
            }
            if (i <= start) continue;
            sb.append(regex, prevI, start);
            sb.append(ANY_TOKEN);
            prevI = i + 1;
        }
        sb.append(regex, prevI, regex.length());
        return sb.toString();
    }

    public static boolean isLiteralCharacter(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/BehatTurnipPatterPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/BehatTurnipPatterPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

