/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.behat.BehatBundle;
import com.jetbrains.php.behat.BehatFrameworkType;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.behat.run.BehatRunConfiguration;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BehatRerunFailedTestsAction
extends AbstractRerunFailedTestsAction {
    private static final Logger LOG = Logger.getInstance(BehatRerunFailedTestsAction.class);
    private static final int TIMEOUT = 5000;
    private static final String RERUN = "--rerun";
    private static final String TEMP_DIRECTORY = "behat_rerun_temp.tmp";

    public BehatRerunFailedTestsAction(@NotNull ComponentContainer componentContainer, SMTRunnerConsoleProperties properties) {
        if (componentContainer == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        super(componentContainer);
        this.init((TestConsoleProperties)properties);
    }

    @Nullable
    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        RunProfile profile;
        if (environment == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        if (!((profile = this.myConsoleProperties.getConfiguration()) instanceof BehatRunConfiguration)) {
            LOG.warn(BehatBundle.message("php.behat.run.configuration.rerun.incorrect.configuration", profile.getClass()));
            return null;
        }
        BehatRunConfiguration runConfiguration = (BehatRunConfiguration)profile;
        return new AbstractRerunFailedTestsAction.MyRunProfile((RunConfigurationBase)runConfiguration){

            @Nullable
            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(1);
                }
                BehatRunConfiguration runConfiguration = (BehatRunConfiguration)this.getPeer();
                final Project project = runConfiguration.getProject();
                PhpInterpreter interpreter = runConfiguration.getInterpreter();
                if (interpreter != null) {
                    VirtualFile baseFile = runConfiguration.getBaseFile(null, interpreter);
                    PhpTestFrameworkConfiguration configuration = PhpTestFrameworkSettingsManager.getInstance((Project)project).getOrCreateByInterpreter(BehatFrameworkType.getInstance(), interpreter, baseFile, true);
                    if (configuration != null) {
                        final PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer((PhpSdkAdditionalData)interpreter.getPhpSdkAdditionalData());
                        ProcessListener cleanupListener = null;
                        SmartList arguments = new SmartList();
                        String version = PhpTestFrameworkVersionCache.getCache((Project)project, (PhpTestFrameworkConfiguration)configuration);
                        if (StringUtil.isNotEmpty((String)version) && "3".compareTo(version) > 0) {
                            try {
                                String filePath = BehatRerunFailedTestsAction.this.writeFailedTestsToFile(interpreter, transfer, runConfiguration);
                                arguments.add("--rerun=" + filePath);
                                cleanupListener = new ProcessListener(){

                                    public void processTerminated(@NotNull ProcessEvent event) {
                                        if (event == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        try {
                                            transfer.delete(project, 5000, true);
                                        }
                                        catch (ExecutionException e) {
                                            LOG.warn("Failed to deleted temporary rerun file for Behat", (Throwable)e);
                                        }
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/behat/actions/BehatRerunFailedTestsAction$1$1", "processTerminated"));
                                    }
                                };
                            }
                            catch (ExecutionException | IOException e) {
                                BehatRerunFailedTestsAction.showWarning(project, e.getMessage(), (Exception)e);
                                return null;
                            }
                        } else {
                            arguments.add(BehatRerunFailedTestsAction.RERUN);
                        }
                        Map envParameters = Collections.emptyMap();
                        PhpCommandSettings command = runConfiguration.createCommand(interpreter, envParameters, (List)arguments, configuration, false);
                        transfer.updateCommand(command);
                        return runConfiguration.getState(environment, command, cleanupListener);
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "environment";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/behat/actions/BehatRerunFailedTestsAction$1";
                objectArray[2] = "getState";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private String writeFailedTestsToFile(@NotNull PhpInterpreter interpreter, @NotNull PhpSdkFileTransfer transfer, @NotNull BehatRunConfiguration runConfiguration) throws IOException, ExecutionException {
        if (interpreter == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        if (transfer == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(4);
        }
        Project project = runConfiguration.getProject();
        List failedTests = this.getFailedTests(project);
        StringBuilder failedTestPath = new StringBuilder();
        String separator = interpreter.isRemote() ? LineSeparator.LF.getSeparatorString() : LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (AbstractTestProxy testProxy : failedTests) {
            String path;
            AbstractTestProxy parent;
            if (!testProxy.isLeaf() || (parent = testProxy.getParent()) == null) continue;
            String url = parent.getLocationUrl();
            String string = path = StringUtil.isEmpty((String)url) ? null : PathUtil.toPresentableUrl((String)url);
            if (StringUtil.isEmpty((String)path)) {
                LOG.warn(BehatBundle.message("php.behat.run.configuration.rerun.empty.test.path", testProxy.getName(), url));
                continue;
            }
            failedTestPath.append(path);
            failedTestPath.append(separator);
        }
        String fileName = StringUtil.join((String[])NameUtil.nameToWords((String)runConfiguration.getName()), (String)"_");
        String string = transfer.createFile(project, fileName, failedTestPath.toString(), TEMP_DIRECTORY, 5000);
        if (string == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void showWarning(@NotNull Project project, @NlsContexts.NotificationContent @NotNull String message, @Nullable Exception e) {
        if (project == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(6);
        }
        if (message == null) {
            BehatRerunFailedTestsAction.$$$reportNull$$$0(7);
        }
        String title = BehatBundle.message("php.behat.run.configuration.rerun.failed.to.create.files.title", new Object[0]);
        BehatUtil.showErrorNotification(project, title, message);
        LOG.warn(message, (Throwable)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/actions/BehatRerunFailedTestsAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/actions/BehatRerunFailedTestsAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFailedTestsToFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeFailedTestsToFile";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

