/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.blade.BladeFileType;
import com.jetbrains.php.lang.PhpFileType;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeFileReferenceSet
extends FileReferenceSet {
    @NonNls
    public static final String BLADE_PHP_EXTENSION = ".blade.php";
    private static final FileType[] FILE_TYPES = new FileType[]{BladeFileType.INSTANCE, PhpFileType.INSTANCE};
    private static final String NAMESPACE_SEPARATOR = "::";

    public BladeFileReferenceSet(String str, @NotNull PsiElement element, int startInElement) {
        if (element == null) {
            BladeFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(BladeFileReferenceSet.trimNamespace(str), element, BladeFileReferenceSet.getStartOffset(str, startInElement), null, SystemInfo.isFileSystemCaseSensitive, true, FILE_TYPES);
        this.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
            PsiFileSystemItem viewsRoot = BladeFileReferenceSet.findViewsRoot((PsiFileSystemItem)file.getParent());
            return Collections.singleton(viewsRoot == null ? file : viewsRoot);
        });
    }

    @Nullable
    private static PsiFileSystemItem findViewsRoot(PsiFileSystemItem item) {
        PsiFileSystemItem viewsRoot = null;
        while (item != null) {
            if (item.isDirectory() && "views".equals(item.getName())) {
                viewsRoot = item;
                break;
            }
            item = item.getParent();
        }
        return viewsRoot;
    }

    private static String trimNamespace(String fullName) {
        int i = fullName.lastIndexOf(NAMESPACE_SEPARATOR);
        return i < 0 ? fullName : fullName.substring(i + NAMESPACE_SEPARATOR.length());
    }

    private static int getStartOffset(String fullName, int beginningOffset) {
        int i = fullName.lastIndexOf(NAMESPACE_SEPARATOR);
        return i < 0 ? beginningOffset : beginningOffset + i + NAMESPACE_SEPARATOR.length();
    }

    @NotNull
    private String getCurrentPath() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return "";
        }
        PsiFileSystemItem root = BladeFileReferenceSet.findViewsRoot((PsiFileSystemItem)file);
        if (root == null) {
            String string = file.getName();
            if (string == null) {
                BladeFileReferenceSet.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)root.getVirtualFile()));
        if (string == null) {
            BladeFileReferenceSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getSeparatorString() {
        return ".";
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new BladeFileReference(this, range, index, text);
    }

    public boolean isAbsolutePathReference() {
        return false;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return item -> item.isDirectory() || FileTypeRegistry.getInstance().isFileOfType(item.getVirtualFile(), (FileType)BladeFileType.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeFileReferenceSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private final class BladeFileReference
    extends FileReference {
        private BladeFileReference(BladeFileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                BladeFileReference.$$$reportNull$$$0(0);
            }
            super((FileReferenceSet)fileReferenceSet, range, index, text);
        }

        public String getText() {
            FileReferenceSet refSet = this.getFileReferenceSet();
            if (this == refSet.getLastReference()) {
                return super.getText() + BladeFileReferenceSet.BLADE_PHP_EXTENSION;
            }
            return super.getText();
        }

        protected Object createLookupItem(PsiElement candidate) {
            block2: {
                PsiFile file;
                block4: {
                    block3: {
                        FileReferenceSet refSet = this.getFileReferenceSet();
                        if (this != refSet.getLastReference()) break block2;
                        if (!(candidate instanceof PsiFile)) break block3;
                        file = (PsiFile)candidate;
                        if (candidate.isPhysical()) break block4;
                    }
                    return candidate;
                }
                String name = file.getName();
                name = StringUtil.trimEnd((String)name, (String)BladeFileReferenceSet.BLADE_PHP_EXTENSION);
                return FileInfoManager._getLookupItem((PsiFile)file, (String)name, (Icon)file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        protected PsiElement rename(String newName) throws IncorrectOperationException {
            newName = StringUtil.trimEnd((String)newName, (String)BladeFileReferenceSet.BLADE_PHP_EXTENSION);
            ArrayList newPathPieces = new ArrayList(StringUtil.split((String)newName, (String)"/"));
            String currentPath = BladeFileReferenceSet.this.getCurrentPath();
            ArrayList currentPathPieces = new ArrayList(StringUtil.split((String)currentPath, (String)"/"));
            currentPathPieces.remove(currentPathPieces.size() - 1);
            while (!newPathPieces.isEmpty() && "..".equals(newPathPieces.get(0))) {
                newPathPieces.remove(0);
                if (currentPathPieces.isEmpty()) continue;
                currentPathPieces.remove(currentPathPieces.size() - 1);
            }
            currentPathPieces.addAll(newPathPieces);
            newName = StringUtil.join(currentPathPieces, (String)".");
            return super.rename(newName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/jetbrains/php/blade/injection/BladeFileReferenceSet$BladeFileReference", "<init>"));
        }
    }
}

