/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementFactory;
import com.jetbrains.twig.elements.TwigPsiReference;
import java.util.LinkedList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigFieldReference
extends TwigPsiReference {
    private static final ResolveCache.PolyVariantResolver<TwigPsiReference> RESOLVER = (expression, incompleteCode) -> {
        TwigFieldReference targetField = (TwigFieldReference)((Object)((Object)ObjectUtils.tryCast((Object)expression, TwigFieldReference.class)));
        if (targetField == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        LinkedList myDeclarations = new LinkedList();
        PsiTreeUtil.processElements((PsiElement)expression.getContainingFile(), e -> {
            if (targetField.getTextRange().getStartOffset() < e.getTextRange().getStartOffset()) {
                return false;
            }
            TwigFieldReference field = (TwigFieldReference)((Object)((Object)((Object)ObjectUtils.tryCast((Object)e, TwigFieldReference.class))));
            if (!TwigFieldReference.equalsName(field, expression) || !targetField.isOwnerEquivalent(field.getOwner())) {
                return true;
            }
            myDeclarations.add(field);
            return false;
        });
        return PsiElementResolveResult.createResults(myDeclarations);
    };

    public TwigFieldReference(@NotNull ASTNode node) {
        if (node == null) {
            TwigFieldReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public String getName() {
        PsiElement lastChild = this.getLastChild();
        if (TwigFieldReference.isOfType(lastChild, TwigTokenTypes.IDENTIFIER)) {
            return lastChild.getText();
        }
        if (TwigFieldReference.isOfType(lastChild, TwigTokenTypes.RBRACE_SQ)) {
            PsiElement quoteOrNumber = lastChild.getPrevSibling();
            if (quoteOrNumber == null) {
                return null;
            }
            if (TwigFieldReference.isOfType(quoteOrNumber, TwigTokenTypes.NUMBER) && TwigFieldReference.isOfType(quoteOrNumber.getPrevSibling(), TwigTokenTypes.LBRACE_SQ)) {
                return quoteOrNumber.getText();
            }
            PsiElement text = this.getNameElementOfFieldWithBrackets();
            if (text != null) {
                return text.getText();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        int end;
        int start;
        PsiElement lbrace = this.findChildByType(TwigTokenTypes.LBRACE_SQ);
        if (lbrace != null && this.getNameElementOfFieldWithBrackets() != null && (start = lbrace.getTextRangeInParent().getStartOffset() + 2) < (end = this.getTextLength() - 2)) {
            return new TextRange(start, end);
        }
        TextRange textRange = super.getRangeInElement();
        if (textRange == null) {
            TwigFieldReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    private PsiElement getNameElementOfFieldWithBrackets() {
        PsiElement rbrace = this.getLastChild();
        if (TwigFieldReference.isOfType(rbrace, TwigTokenTypes.RBRACE_SQ)) {
            PsiElement rFieldName;
            PsiElement lbrace = this.findChildByType(TwigTokenTypes.LBRACE_SQ);
            PsiElement lQuote = lbrace != null ? lbrace.getNextSibling() : null;
            PsiElement lFieldName = lQuote != null ? lQuote.getNextSibling() : null;
            PsiElement rQuote = rbrace.getPrevSibling();
            PsiElement psiElement = rFieldName = rQuote != null ? rQuote.getPrevSibling() : null;
            if (rFieldName == lFieldName && TwigFieldReference.isOfType(lFieldName, TwigTokenTypes.STRING_TEXT)) {
                return lFieldName;
            }
        }
        return null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement lastChild;
        if (name == null) {
            TwigFieldReference.$$$reportNull$$$0(2);
        }
        if (TwigFieldReference.isOfType(lastChild = this.getLastChild(), TwigTokenTypes.IDENTIFIER)) {
            return lastChild.replace(TwigElementFactory.createFieldIdentifier(this.getProject(), name));
        }
        PsiElement fieldNameText = this.getNameElementOfFieldWithBrackets();
        if (fieldNameText != null) {
            fieldNameText.replace(TwigElementFactory.createFieldNameText(this.getProject(), name));
        }
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement lastChild = this.getLastChild();
        if (TwigFieldReference.isOfType(lastChild, TwigTokenTypes.IDENTIFIER)) {
            return lastChild;
        }
        PsiElement fieldNameText = this.getNameElementOfFieldWithBrackets();
        if (fieldNameText != null) {
            return fieldNameText;
        }
        return null;
    }

    @Nullable
    public TwigPsiReference getOwner() {
        TwigPsiReference ownerReference = (TwigPsiReference)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.getLastChild(), TwigPsiReference.class);
        if (ownerReference == null) {
            return null;
        }
        TwigPsiReference resolved = (TwigPsiReference)((Object)ObjectUtils.tryCast((Object)ownerReference.resolve(), TwigPsiReference.class));
        return resolved != null ? resolved : ownerReference;
    }

    @Override
    ResolveCache.PolyVariantResolver<TwigPsiReference> getReferenceResolver() {
        return RESOLVER;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (this == another) {
            return true;
        }
        TwigFieldReference field = (TwigFieldReference)((Object)ObjectUtils.tryCast((Object)another, TwigFieldReference.class));
        if (!TwigFieldReference.equalsName(field, this)) {
            return false;
        }
        return this.isOwnerEquivalent(field.getOwner()) || super.isEquivalentTo(another);
    }

    private boolean isOwnerEquivalent(@Nullable TwigPsiReference anotherOwner) {
        TwigPsiReference thisOwner = this.getOwner();
        if (thisOwner == anotherOwner) {
            return true;
        }
        return thisOwner != null && this.getOwner().getManager().areElementsEquivalent((PsiElement)thisOwner, (PsiElement)anotherOwner);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        TwigFieldReference field;
        if (element == null) {
            TwigFieldReference.$$$reportNull$$$0(3);
        }
        if ((field = (TwigFieldReference)((Object)ObjectUtils.tryCast((Object)element, TwigFieldReference.class))) == null) {
            return super.isReferenceTo(element);
        }
        if (!TwigFieldReference.equalsName(field, this)) {
            return false;
        }
        return this.isOwnerEquivalent(field.getOwner()) || super.isReferenceTo(element);
    }

    private static boolean equalsName(TwigPsiReference ref1, TwigPsiReference ref2) {
        if (ref1 == null || ref2 == null) {
            return false;
        }
        if (ref1.getName() == null || ref2.getName() == null) {
            return false;
        }
        return ref1.getName().equals(ref2.getName());
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/elements/TwigFieldReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/elements/TwigFieldReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

