/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDdlMappingAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateDdlMappingAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        RawDataSource dataSource;
        if (e == null) {
            CreateDdlMappingAction.$$$reportNull$$$0(1);
        }
        if ((dataSource = CreateDdlMappingAction.getDataSource(e)) != null) {
            String id = dataSource.getUniqueId();
            DdlMapping mapping = (DdlMapping)DdlMappingsManager.getInstance((Project)e.getProject()).iterateMappings().find(m -> m.isDataSourceId(id) || m.isDdlDataSourceId(id));
            if (mapping != null) {
                dataSource = null;
            }
        }
        e.getPresentation().setEnabledAndVisible(dataSource != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RawDataSource dataSource;
        if (e == null) {
            CreateDdlMappingAction.$$$reportNull$$$0(2);
        }
        if ((dataSource = CreateDdlMappingAction.getDataSource(e)) == null) {
            return;
        }
        DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)e.getProject()), null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)editor2 -> {
            DdlMapping mapping = new DdlMapping(null);
            mapping.setName(dataSource.getName() + " Mapping");
            String id = dataSource.getUniqueId();
            if (dataSource instanceof LocalDataSource) {
                mapping.setDataSourceId(id);
            } else if (dataSource instanceof SqlDataSource) {
                mapping.setDdlDataSourceId(id);
            }
            editor2.onCreated(mapping);
        }));
    }

    @Nullable
    private static RawDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateDdlMappingAction.$$$reportNull$$$0(3);
        }
        return (RawDataSource)DatabaseContextFun.getSelectedDataSources(e.getDataContext()).single();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/CreateDdlMappingAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/CreateDdlMappingAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

