/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.php.ideolog.filter;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.ideolog.filters.PrioritizedFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/php/ideolog/filter/LaravelFileFilter;", "Lcom/intellij/ideolog/filters/PrioritizedFilter;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/LocalFileSystem;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "filterNestedResults", "", "Lcom/intellij/execution/filters/Filter$ResultItem;", "results", "collectFilterResultItems", "textStartOffset", "matcher", "Ljava/util/regex/Matcher;", "buildFileHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "filePath", "documentLineString", "Companion", "LinedFileHyperlinkInfo", "intellij.php.ideolog"})
@SourceDebugExtension(value={"SMAP\nLaravelFileFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaravelFileFilter.kt\ncom/intellij/php/ideolog/filter/LaravelFileFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,112:1\n1056#2:113\n1803#2,3:114\n1563#2:117\n1634#2,3:118\n1#3:121\n434#4:122\n507#4,5:123\n*S KotlinDebug\n*F\n+ 1 LaravelFileFilter.kt\ncom/intellij/php/ideolog/filter/LaravelFileFilter\n*L\n72#1:113\n73#1:114,3\n79#1:117\n79#1:118,3\n98#1:122\n98#1:123,5\n*E\n"})
public final class LaravelFileFilter
implements PrioritizedFilter,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LocalFileSystem localFileSystem;
    @NotNull
    private static final String FILE_LINE_REGEX = "(\\(\\d+\\)|:\\d+)";
    @NotNull
    private static final String LINUX_MACOS_PATH_REGEX = "(/(?:[\\w.-]+/)*\\w+\\.\\w+)";
    @NotNull
    private static final String WINDOWS_PATH_REGEX = "\\b((?:[a-zA-Z]:\\\\(?:[^\\\\/:*?\"<>|\\r\\n]+\\\\)*)?[^\\\\/:*?\"<>|\\r\\n]*)";
    private static final Pattern LINUX_MACOS_FILE_PATTERN = Pattern.compile("(/(?:[\\w.-]+/)*\\w+\\.\\w+)(\\(\\d+\\)|:\\d+)");
    private static final Pattern WINDOWS_FILE_PATTERN = Pattern.compile("\\b((?:[a-zA-Z]:\\\\(?:[^\\\\/:*?\"<>|\\r\\n]+\\\\)*)?[^\\\\/:*?\"<>|\\r\\n]*)(\\(\\d+\\)|:\\d+)");

    public LaravelFileFilter(@NotNull Project project, @NotNull LocalFileSystem localFileSystem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        this.project = project;
        this.localFileSystem = localFileSystem;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Filter.Result result;
        block8: {
            List list;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (!LaravelFileFilter.Companion.canContainFilePathFromLaravelLogs(line)) {
                return null;
            }
            int textStartOffset = entireLength - line.length();
            CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)line, (long)100L);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
            CharSequence bombedCharSequence = charSequence;
            boolean isWindows = SystemInfo.isWindows;
            boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            List $this$applyFilter_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (isUnitTestMode || isWindows) {
                Matcher matcher = WINDOWS_FILE_PATTERN.matcher(bombedCharSequence);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
                $this$applyFilter_u24lambda_u240.addAll((Collection)this.collectFilterResultItems(textStartOffset, matcher));
            }
            if (isUnitTestMode || !isWindows) {
                Matcher matcher = LINUX_MACOS_FILE_PATTERN.matcher(bombedCharSequence);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
                $this$applyFilter_u24lambda_u240.addAll((Collection)this.collectFilterResultItems(textStartOffset, matcher));
            }
            List unprocessedFilterResultItems = CollectionsKt.build((List)list);
            List<Filter.ResultItem> filterResultItems = this.filterNestedResults(unprocessedFilterResultItems);
            Filter.Result $this$applyFilter_u24lambda_u242 = result = (switch (filterResultItems.size()) {
                case 0 -> null;
                case 1 -> {
                    Filter.ResultItem it = (Filter.ResultItem)CollectionsKt.first(filterResultItems);
                    boolean $i$a$-let-LaravelFileFilter$applyFilter$1 = false;
                    yield new Filter.Result(it.getHighlightStartOffset(), it.getHighlightEndOffset(), it.getHyperlinkInfo());
                }
                default -> new Filter.Result(filterResultItems);
            });
            boolean bl2 = false;
            Filter.Result result2 = $this$applyFilter_u24lambda_u242;
            if ((result2 != null ? result2.getFirstHyperlinkInfo() : null) != null) break block8;
            Filter.Result result3 = $this$applyFilter_u24lambda_u242;
            if (result3 != null) {
                result3.setNextAction(Filter.NextAction.CONTINUE_FILTERING);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Filter.ResultItem> filterNestedResults(List<? extends Filter.ResultItem> results) {
        void $this$mapTo$iv$iv;
        List acc;
        void $this$fold$iv;
        Iterable $this$sortedBy$iv = results;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Filter.ResultItem it = (Filter.ResultItem)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHighlightStartOffset());
                it = (Filter.ResultItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHighlightStartOffset()));
            }
        });
        List initial$iv = new ArrayList();
        boolean $i$f$fold22 = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void result;
            Filter.ResultItem resultItem = (Filter.ResultItem)element$iv;
            acc = accumulator$iv;
            boolean bl = false;
            Pair pair = (Pair)CollectionsKt.lastOrNull((List)acc);
            if ((pair != null ? ((Number)pair.getFirst()).intValue() : -1) < result.getHighlightStartOffset()) {
                acc.add(TuplesKt.to((Object)result.getHighlightEndOffset(), (Object)result));
            }
            accumulator$iv = acc;
        }
        Iterable $this$map$iv = accumulator$iv;
        boolean $i$f$map = false;
        Iterable $i$f$fold22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            acc = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Filter.ResultItem)it.getSecond());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Filter.ResultItem> collectFilterResultItems(int textStartOffset, Matcher matcher) {
        List resultItems = new ArrayList();
        while (matcher.find()) {
            String string;
            void it;
            Matcher matcher2;
            int n = textStartOffset + matcher.start();
            int n2 = textStartOffset + matcher.end();
            Intrinsics.checkNotNullExpressionValue((Object)matcher.group(1), (String)"group(...)");
            Matcher matcher3 = matcher2 = matcher;
            LaravelFileFilter laravelFileFilter = this;
            int n3 = n2;
            int n4 = n;
            List list = resultItems;
            boolean bl = false;
            boolean bl2 = it.groupCount() >= 2;
            Matcher matcher4 = bl2 ? matcher2 : null;
            HyperlinkInfo hyperlinkInfo = laravelFileFilter.buildFileHyperlinkInfo(string, matcher4 != null ? matcher4.group(2) : null);
            int n5 = n3;
            int n6 = n4;
            list.add(new Filter.ResultItem(n6, n5, hyperlinkInfo));
        }
        return resultItems;
    }

    /*
     * Unable to fully structure code
     */
    private final HyperlinkInfo buildFileHyperlinkInfo(String filePath, String documentLineString) {
        block4: {
            block3: {
                v0 = this.localFileSystem.findFileByPath(filePath);
                if (v0 == null) break block3;
                it = v0;
                $i$a$-let-LaravelFileFilter$buildFileHyperlinkInfo$1 = false;
                if (documentLineString == null) ** GOTO lbl-1000
                var5_5 = documentLineString;
                $i$f$filter = false;
                var7_8 = (CharSequence)$this$filter$iv;
                destination$iv$iv = new StringBuilder();
                $i$f$filterTo = false;
                var11_13 = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < var11_13; ++index$iv$iv) {
                    it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    $i$a$-filter-LaravelFileFilter$buildFileHyperlinkInfo$1$lineNumber$1 = false;
                    if (!Character.isDigit(it)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                var15_17 = ((StringBuilder)destination$iv$iv).toString();
                if (var15_17 == null) ** GOTO lbl-1000
                var6_7 = var15_17;
                it = var6_7;
                $i$a$-takeIf-LaravelFileFilter$buildFileHyperlinkInfo$1$lineNumber$2 = false;
                v1 = var5_5 = ((CharSequence)it).length() > 0 != false ? var6_7 : null;
                if (var5_5 != null && (var6_7 = StringsKt.toIntOrNull((String)var5_5)) != null) {
                    it = ((Number)var6_7).intValue();
                    $i$a$-let-LaravelFileFilter$buildFileHyperlinkInfo$1$lineNumber$3 = false;
                    v2 = it - 1;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = 0;
                }
                lineNumber = v2;
                v3 = new LinedFileHyperlinkInfo(this.project, filePath, lineNumber);
                break block4;
            }
            v3 = null;
        }
        return (HyperlinkInfo)v3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/php/ideolog/filter/LaravelFileFilter$Companion;", "", "<init>", "()V", "FILE_LINE_REGEX", "", "LINUX_MACOS_PATH_REGEX", "WINDOWS_PATH_REGEX", "LINUX_MACOS_FILE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "WINDOWS_FILE_PATTERN", "canContainFilePathFromLaravelLogs", "", "line", "intellij.php.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean canContainFilePathFromLaravelLogs(String line) {
            return (StringsKt.contains$default((CharSequence)line, (CharSequence)":\\", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (char)'/', (boolean)false, (int)2, null)) && (StringsKt.contains$default((CharSequence)line, (char)'(', (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (char)')', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (char)':', (boolean)false, (int)2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/php/ideolog/filter/LaravelFileFilter$LinedFileHyperlinkInfo;", "Lcom/intellij/execution/filters/LazyFileHyperlinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "documentLine", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;I)V", "getFilePath", "()Ljava/lang/String;", "getDocumentLine", "()I", "intellij.php.ideolog"})
    public static final class LinedFileHyperlinkInfo
    extends LazyFileHyperlinkInfo {
        @NotNull
        private final String filePath;
        private final int documentLine;

        public LinedFileHyperlinkInfo(@NotNull Project project, @NotNull String filePath, int documentLine) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            super(project, filePath, documentLine, 0, false);
            this.filePath = filePath;
            this.documentLine = documentLine;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getDocumentLine() {
            return this.documentLine;
        }
    }
}

