/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.util;

import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.ideolog.largeFile.IdeologLargeFileDocumentContext;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.RegexLogParser;
import com.intellij.ideolog.statistics.IdeologUsagesCollector;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0007\b\u0016\u0018\u0000 :2\u00020\u0001:\u0002:;B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u00020$2\b\b\u0002\u0010*\u001a\u00020\u000bH\u0016J$\u0010+\u001a\u00020$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000bJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000bH\u0004J\u0010\u00107\u001a\u00020&2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002J\u0010\u00109\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u000f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0010j\b\u0012\u0004\u0012\u00020\u0012`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0010j\b\u0012\u0004\u0012\u00020\u0012`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R9\u0010\u001a\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u001fR\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/ideolog/util/IdeologDocumentContext;", "", "document", "Lcom/intellij/openapi/editor/Document;", "cache", "Lcom/intellij/ideolog/util/IdeologDocumentContext$EventCache;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/ideolog/util/IdeologDocumentContext$EventCache;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "numberFirstLines", "", "getNumberFirstLines", "()I", "eventParsingLock", "hiddenItems", "Ljava/util/HashSet;", "Lkotlin/Pair;", "", "Lkotlin/collections/HashSet;", "getHiddenItems", "()Ljava/util/HashSet;", "hiddenSubstrings", "getHiddenSubstrings", "whitelistedSubstrings", "getWhitelistedSubstrings", "whitelistedItems", "getWhitelistedItems", "hideLinesAbove", "getHideLinesAbove", "setHideLinesAbove", "(I)V", "hideLinesBelow", "getHideLinesBelow", "setHideLinesBelow", "format", "Lcom/intellij/ideolog/lex/LogFileFormat;", "needLogging", "", "clear", "", "detectLogFileFormat", "startOffset", "getLogFileFormat", "fileLines", "Lkotlin/sequences/Sequence;", "regexMatchers", "", "Lcom/intellij/ideolog/lex/RegexLogParser;", "getEvent", "Lkotlin/ranges/IntRange;", "atLine", "lineCharSequence", "", "line", "isLineEventStart", "getEventEndLine", "getEventStartLine", "Companion", "EventCache", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nIdeologDocumentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeologDocumentContext.kt\ncom/intellij/ideolog/util/IdeologDocumentContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,232:1\n1617#2,9:233\n1869#2:242\n1870#2:245\n1626#2:246\n1563#2:247\n1634#2,2:248\n1636#2:253\n774#2:254\n865#2,2:255\n1999#2,14:257\n24#3:243\n1#4:244\n1#4:271\n1276#5,3:250\n*S KotlinDebug\n*F\n+ 1 IdeologDocumentContext.kt\ncom/intellij/ideolog/util/IdeologDocumentContext\n*L\n83#1:233,9\n83#1:242\n83#1:245\n83#1:246\n114#1:247\n114#1:248,2\n114#1:253\n119#1:254\n119#1:255,2\n119#1:257,14\n96#1:243\n83#1:244\n115#1:250,3\n*E\n"})
public class IdeologDocumentContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @Nullable
    private final EventCache cache;
    @NotNull
    private final Object eventParsingLock;
    @NotNull
    private final HashSet<Pair<Integer, String>> hiddenItems;
    @NotNull
    private final HashSet<String> hiddenSubstrings;
    @NotNull
    private final HashSet<String> whitelistedSubstrings;
    @NotNull
    private final HashSet<Pair<Integer, String>> whitelistedItems;
    private int hideLinesAbove;
    private int hideLinesBelow;
    @Nullable
    private LogFileFormat format;
    private final boolean needLogging;
    private static final int NUMBER_FIRST_LINES = 25;
    private static final int MIN_FORMAT_MATCHES = 1;
    private static final int INTERRUPT_AFTER_NS = 500000000;

    public IdeologDocumentContext(@NotNull Document document, @Nullable EventCache cache) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.cache = cache;
        this.eventParsingLock = new Object();
        this.hiddenItems = new HashSet();
        this.hiddenSubstrings = new HashSet();
        this.whitelistedSubstrings = new HashSet();
        this.whitelistedItems = new HashSet();
        this.hideLinesAbove = -1;
        this.hideLinesBelow = Integer.MAX_VALUE;
        this.needLogging = this.getClass() == IdeologDocumentContext.class || this.getClass() == IdeologLargeFileDocumentContext.class;
    }

    public /* synthetic */ IdeologDocumentContext(Document document, EventCache eventCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            eventCache = new EventCache(null, null, 3, null);
        }
        this(document, eventCache);
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public int getNumberFirstLines() {
        return 25;
    }

    @NotNull
    public final HashSet<Pair<Integer, String>> getHiddenItems() {
        return this.hiddenItems;
    }

    @NotNull
    public final HashSet<String> getHiddenSubstrings() {
        return this.hiddenSubstrings;
    }

    @NotNull
    public final HashSet<String> getWhitelistedSubstrings() {
        return this.whitelistedSubstrings;
    }

    @NotNull
    public final HashSet<Pair<Integer, String>> getWhitelistedItems() {
        return this.whitelistedItems;
    }

    public final int getHideLinesAbove() {
        return this.hideLinesAbove;
    }

    public final void setHideLinesAbove(int n) {
        this.hideLinesAbove = n;
    }

    public final int getHideLinesBelow() {
        return this.hideLinesBelow;
    }

    public final void setHideLinesBelow(int n) {
        this.hideLinesBelow = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.eventParsingLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            EventCache eventCache = this.cache;
            if (eventCache != null) {
                eventCache.clear();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        this.format = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LogFileFormat detectLogFileFormat(int startOffset) {
        LogFileFormat detectedLogFormat;
        void $this$mapNotNullTo$iv$iv;
        int logFileOffset;
        int n = logFileOffset = this.getClass() == IdeologDocumentContext.class ? 0 : startOffset;
        if (this.cache != null || logFileOffset == 0) {
            LogFileFormat currentFormat;
            LogFileFormat logFileFormat = currentFormat = this.format;
            boolean bl = logFileFormat != null ? IdeologDocumentContextKt.access$isEnabled(logFileFormat) : false;
            if (bl) {
                return currentFormat;
            }
            this.clear();
        }
        Iterable $this$mapNotNull$iv = LogHighlightingSettingsStore.Companion.getInstance().getMyState().getParsingPatterns();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RegexLogParser regexLogParser;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LogParsingPattern it = (LogParsingPattern)element$iv$iv;
            boolean bl2 = false;
            if (!it.getEnabled()) {
                regexLogParser = null;
            } else {
                try {
                    UUID uUID = it.getUuid();
                    Pattern pattern = Pattern.compile(it.getPattern(), 32);
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
                    Pattern pattern2 = Pattern.compile(it.getLineStartPattern());
                    Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
                    regexLogParser = new RegexLogParser(uUID, pattern, pattern2, it, new SimpleDateFormat(it.getTimePattern()));
                }
                catch (PatternSyntaxException e) {
                    IdeologDocumentContext $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(IdeologDocumentContext.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info((Throwable)e);
                    regexLogParser = null;
                }
            }
            if (regexLogParser == null) continue;
            RegexLogParser it$iv$iv = regexLogParser;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List regexMatchers = (List)destination$iv$iv;
        CharSequence charSequence = this.document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence documentAfterOffset = StringsKt.drop((CharSequence)charSequence, (int)logFileOffset);
        Sequence firstLinesAfterOffset = SequencesKt.take((Sequence)StringsKt.lineSequence((CharSequence)documentAfterOffset), (int)this.getNumberFirstLines());
        this.format = detectedLogFormat = this.getLogFileFormat((Sequence<String>)firstLinesAfterOffset, regexMatchers);
        if (this.needLogging) {
            IdeologUsagesCollector.INSTANCE.logDetectedLogFormat(this.format);
        }
        return detectedLogFormat;
    }

    public static /* synthetic */ LogFileFormat detectLogFileFormat$default(IdeologDocumentContext ideologDocumentContext, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: detectLogFileFormat");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ideologDocumentContext.detectLogFileFormat(n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LogFileFormat getLogFileFormat(@NotNull Sequence<String> fileLines, @NotNull List<RegexLogParser> regexMatchers) {
        Object v0;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileLines, (String)"fileLines");
        Intrinsics.checkNotNullParameter(regexMatchers, (String)"regexMatchers");
        long startTime = System.nanoTime();
        Iterable $this$map$iv = regexMatchers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$count$iv;
            void it;
            RegexLogParser regexLogParser = (RegexLogParser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Sequence<String> sequence = fileLines;
            void var16_27 = it;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String line = (String)element$iv;
                boolean bl2 = false;
                if (!(System.nanoTime() - startTime < 500000000L && it.getRegex().matcher(line).find()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int n = count$iv;
            collection.add(TuplesKt.to((Object)var16_27, (Object)n));
        }
        List sumByMatcher = (List)destination$iv$iv;
        Iterable $this$filter$iv = sumByMatcher;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() >= 1)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Pair it = (Pair)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-maxByOrNull-IdeologDocumentContext$getLogFileFormat$2 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Pair pair = v0;
        RegexLogParser regexLogParser = pair != null ? (RegexLogParser)pair.getFirst() : null;
        return new LogFileFormat(regexLogParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IntRange getEvent(int atLine) {
        if (atLine < 0) {
            return new IntRange(-1, -1);
        }
        Object object = this.eventParsingLock;
        synchronized (object) {
            boolean bl = false;
            int startLine = this.getEventStartLine(atLine);
            int endLine = this.getEventEndLine(atLine);
            IntRange intRange = new IntRange(startLine, endLine);
            return intRange;
        }
    }

    @NotNull
    protected final CharSequence lineCharSequence(int line) {
        return this.document.getImmutableCharSequence().subSequence(this.document.getLineStartOffset(line), this.document.getLineEndOffset(line));
    }

    public boolean isLineEventStart(int atLine) {
        LogFileFormat format = this.detectLogFileFormat(this.document.getLineStartOffset(atLine));
        return format.isLineEventStart(this.lineCharSequence(atLine));
    }

    private final int getEventEndLine(int atLine) {
        Object object;
        HashMap<Integer, Integer> hashMap;
        EventCache eventCache = this.cache;
        if (eventCache != null && (hashMap = eventCache.getEventEndLines()) != null && (object = hashMap.get(atLine)) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            return it;
        }
        int lineCount = this.document.getLineCount();
        int currentLine = 0;
        currentLine = atLine;
        while (currentLine < lineCount - 1 && !this.isLineEventStart(currentLine + 1)) {
            Integer n;
            HashMap<Integer, Integer> hashMap2;
            int n2 = currentLine;
            currentLine = n2 + 1;
            object = this.cache;
            if (object == null || (hashMap2 = ((EventCache)object).getEventEndLines()) == null || (n = hashMap2.get(currentLine)) == null) continue;
            Integer n3 = n;
            int it = ((Number)n3).intValue();
            boolean bl = false;
            IdeologDocumentContext.getEventEndLine$updateCache(atLine, this, currentLine, it);
            it = ((Number)n3).intValue();
            boolean bl2 = false;
            return it;
        }
        IdeologDocumentContext.getEventEndLine$updateCache(atLine, this, currentLine, currentLine);
        return currentLine;
    }

    private final int getEventStartLine(int atLine) {
        Serializable serializable;
        Object object;
        EventCache eventCache = this.cache;
        if (eventCache != null && (object = eventCache.getEventStartLines()) != null && (serializable = ((HashMap)object).get(atLine)) != null) {
            int it = ((Number)serializable).intValue();
            boolean bl = false;
            return it;
        }
        int currentLine = 0;
        currentLine = atLine;
        while (currentLine > 0 && !this.isLineEventStart(currentLine)) {
            Integer n;
            int n2 = currentLine;
            currentLine = n2 + -1;
            object = this.cache;
            if (object == null || (serializable = ((EventCache)object).getEventStartLines()) == null || (n = (Integer)((HashMap)serializable).get(currentLine)) == null) continue;
            Integer n3 = n;
            int it = ((Number)n3).intValue();
            boolean bl = false;
            IdeologDocumentContext.getEventStartLine$updateCache$11(atLine, this, currentLine, it);
            it = ((Number)n3).intValue();
            boolean bl2 = false;
            return it;
        }
        IdeologDocumentContext.getEventStartLine$updateCache$11(atLine, this, currentLine, currentLine);
        return currentLine;
    }

    private static final void getEventEndLine$updateCache(int $atLine, IdeologDocumentContext this$0, int highLine, int value) {
        int i = $atLine;
        if (i <= highLine) {
            while (true) {
                Object object;
                if ((object = this$0.cache) != null && (object = ((EventCache)object).getEventEndLines()) != null) {
                    ((HashMap)object).put(i, value);
                }
                if (i == highLine) break;
                ++i;
            }
        }
    }

    private static final void getEventStartLine$updateCache$11(int $atLine, IdeologDocumentContext this$0, int lowLine, int targetLine) {
        int i = lowLine;
        if (i <= $atLine) {
            while (true) {
                Object object;
                if ((object = this$0.cache) != null && (object = ((EventCache)object).getEventStartLines()) != null) {
                    ((HashMap)object).put(i, targetLine);
                }
                if (i == $atLine) break;
                ++i;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ideolog/util/IdeologDocumentContext$Companion;", "", "<init>", "()V", "NUMBER_FIRST_LINES", "", "MIN_FORMAT_MATCHES", "INTERRUPT_AFTER_NS", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005\u0012$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ%\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005H\u00c6\u0003J%\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005H\u00c6\u0003JU\u0010\u0010\u001a\u00020\u00002$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u00052$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ideolog/util/IdeologDocumentContext$EventCache;", "", "eventStartLines", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "eventEndLines", "<init>", "(Ljava/util/HashMap;Ljava/util/HashMap;)V", "getEventStartLines", "()Ljava/util/HashMap;", "getEventEndLines", "clear", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ideolog"})
    public static final class EventCache {
        @NotNull
        private final HashMap<Integer, Integer> eventStartLines;
        @NotNull
        private final HashMap<Integer, Integer> eventEndLines;

        public EventCache(@NotNull HashMap<Integer, Integer> eventStartLines, @NotNull HashMap<Integer, Integer> eventEndLines) {
            Intrinsics.checkNotNullParameter(eventStartLines, (String)"eventStartLines");
            Intrinsics.checkNotNullParameter(eventEndLines, (String)"eventEndLines");
            this.eventStartLines = eventStartLines;
            this.eventEndLines = eventEndLines;
        }

        public /* synthetic */ EventCache(HashMap hashMap, HashMap hashMap2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                hashMap = new HashMap<Integer, Integer>();
            }
            if ((n & 2) != 0) {
                hashMap2 = new HashMap<Integer, Integer>();
            }
            this(hashMap, hashMap2);
        }

        @NotNull
        public final HashMap<Integer, Integer> getEventStartLines() {
            return this.eventStartLines;
        }

        @NotNull
        public final HashMap<Integer, Integer> getEventEndLines() {
            return this.eventEndLines;
        }

        public final void clear() {
            this.eventStartLines.clear();
            this.eventEndLines.clear();
        }

        @NotNull
        public final HashMap<Integer, Integer> component1() {
            return this.eventStartLines;
        }

        @NotNull
        public final HashMap<Integer, Integer> component2() {
            return this.eventEndLines;
        }

        @NotNull
        public final EventCache copy(@NotNull HashMap<Integer, Integer> eventStartLines, @NotNull HashMap<Integer, Integer> eventEndLines) {
            Intrinsics.checkNotNullParameter(eventStartLines, (String)"eventStartLines");
            Intrinsics.checkNotNullParameter(eventEndLines, (String)"eventEndLines");
            return new EventCache(eventStartLines, eventEndLines);
        }

        public static /* synthetic */ EventCache copy$default(EventCache eventCache, HashMap hashMap, HashMap hashMap2, int n, Object object) {
            if ((n & 1) != 0) {
                hashMap = eventCache.eventStartLines;
            }
            if ((n & 2) != 0) {
                hashMap2 = eventCache.eventEndLines;
            }
            return eventCache.copy(hashMap, hashMap2);
        }

        @NotNull
        public String toString() {
            return "EventCache(eventStartLines=" + this.eventStartLines + ", eventEndLines=" + this.eventEndLines + ")";
        }

        public int hashCode() {
            int result = this.eventStartLines.hashCode();
            result = result * 31 + this.eventEndLines.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EventCache)) {
                return false;
            }
            EventCache eventCache = (EventCache)other;
            if (!Intrinsics.areEqual(this.eventStartLines, eventCache.eventStartLines)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventEndLines, eventCache.eventEndLines);
        }

        public EventCache() {
            this(null, null, 3, null);
        }
    }
}

