/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.ideolog.highlighting.LineSegment;
import com.intellij.ideolog.highlighting.LogColorsKt;
import com.intellij.ideolog.highlighting.LogFileHighlighterFactoryKt;
import com.intellij.ideolog.highlighting.LogHeavyFilterService;
import com.intellij.ideolog.highlighting.LogHighlightingIteratorKt;
import com.intellij.ideolog.highlighting.settings.LogHighlightingAction;
import com.intellij.ideolog.highlighting.settings.LogHighlightingPattern;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.util.IdeologContextDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 Z2\u00020\u0001:\u0002YZB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020)H\u0002J\u0018\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020)2\u0006\u00100\u001a\u00020)H\u0002J \u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u0003H\u0002J \u00107\u001a\u0002082\u0006\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0003H\u0014J\u0018\u0010=\u001a\u00020-2\u0006\u00105\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u0003H\u0014J8\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020$2\u0006\u00106\u001a\u00020\u00032\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u0002082\u0006\u0010E\u001a\u000208H\u0002J4\u0010F\u001a\u0004\u0018\u00010'2\u0006\u0010G\u001a\u00020$2\b\u0010H\u001a\u0004\u0018\u00010$2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u00106\u001a\u00020\u0003H\u0002J\u0018\u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u0002082\u0006\u0010K\u001a\u000208H\u0002J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020\u0003H\u0016J\b\u0010O\u001a\u00020\u0003H\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020-H\u0016J\b\u0010S\u001a\u00020-H\u0016J\b\u0010T\u001a\u000208H\u0016J\b\u0010U\u001a\u00020VH\u0016J\u001a\u0010W\u001a\u00020;2\u0006\u0010X\u001a\u00020\u00052\b\b\u0002\u00106\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f\u0012\u0004\u0012\u00020!0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020'0#j\b\u0012\u0004\u0012\u00020'`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/intellij/ideolog/highlighting/LogHighlightingIterator;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "textGetter", "Lkotlin/Function0;", "", "colorGetter", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(ILcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getMyEditor", "()Lcom/intellij/openapi/editor/Editor;", "getTextGetter", "()Lkotlin/jvm/functions/Function0;", "getColorGetter", "myText", "getMyText", "()Ljava/lang/CharSequence;", "myColors", "getMyColors", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "settingsStore", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "getSettingsStore", "()Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "myPatterns", "", "Lkotlin/Pair;", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingPattern;", "parsedTokens", "Ljava/util/ArrayList;", "Lcom/intellij/ideolog/lex/LogToken;", "Lkotlin/collections/ArrayList;", "eventPieces", "Lcom/intellij/ideolog/highlighting/LogHighlightingIterator$EventPiece;", "currentEventLineRange", "Lkotlin/ranges/IntRange;", "eventPiecePointer", "curEvent", "parseNextEvent", "", "parsePreviousEvent", "linesSubSequence", "lineRange", "reparsePiecesLines", "prevEventLineRange", "reparsePieces", "prevEvent", "event", "offset", "acceptHighlighter", "", "logHighlightingPattern", "fileFormat", "Lcom/intellij/ideolog/lex/LogFileFormat;", "captureGroup", "tryHighlightStacktrace", "eventOffset", "highlightSeparator", "separator", "valueForeground", "Ljava/awt/Color;", "valueBackground", "valueBold", "valueItalic", "calculateDateTokenForHighlighting", "token", "dateToken", "getFont", "bold", "italic", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getStart", "getEnd", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "advance", "retreat", "atEnd", "getDocument", "Lcom/intellij/openapi/editor/Document;", "detectLogFileFormatByOffset", "editor", "EventPiece", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogHighlightingIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHighlightingIterator.kt\ncom/intellij/ideolog/highlighting/LogHighlightingIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,463:1\n774#2:464\n865#2,2:465\n1617#2,9:467\n1869#2:476\n1870#2:478\n1626#2:479\n1878#2,3:480\n774#2:484\n865#2,2:485\n1563#2:487\n1634#2,3:488\n774#2:491\n865#2,2:492\n774#2:494\n865#2,2:495\n1878#2,2:497\n774#2:499\n865#2,2:500\n1387#2:502\n1475#2,5:503\n1573#2:508\n1604#2,4:509\n1563#2:513\n1634#2,3:514\n1880#2:517\n1617#2,9:518\n1869#2:527\n1870#2:529\n1626#2:530\n1#3:477\n1#3:483\n1#3:528\n*S KotlinDebug\n*F\n+ 1 LogHighlightingIterator.kt\ncom/intellij/ideolog/highlighting/LogHighlightingIterator\n*L\n38#1:464\n38#1:465,2\n38#1:467,9\n38#1:476\n38#1:478\n38#1:479\n60#1:480,3\n147#1:484\n147#1:485,2\n147#1:487\n147#1:488,3\n196#1:491\n196#1:492,2\n197#1:494\n197#1:495,2\n201#1:497,2\n235#1:499\n235#1:500,2\n237#1:502\n237#1:503,5\n273#1:508\n273#1:509,4\n279#1:513\n279#1:514,3\n201#1:517\n239#1:518,9\n239#1:527\n239#1:529\n239#1:530\n38#1:477\n239#1:528\n*E\n"})
public class LogHighlightingIterator
implements HighlighterIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Function0<CharSequence> textGetter;
    @NotNull
    private final Function0<EditorColorsScheme> colorGetter;
    @NotNull
    private final LogHighlightingSettingsStore settingsStore;
    @NotNull
    private final List<Pair<Pattern, LogHighlightingPattern>> myPatterns;
    @NotNull
    private ArrayList<LogToken> parsedTokens;
    @NotNull
    private final ArrayList<EventPiece> eventPieces;
    @NotNull
    private IntRange currentEventLineRange;
    private int eventPiecePointer;
    @NotNull
    private CharSequence curEvent;
    @NotNull
    private static final float[] myHsbVals = new float[3];

    /*
     * WARNING - void declaration
     */
    public LogHighlightingIterator(int startOffset, @NotNull Editor myEditor, @NotNull Function0<? extends CharSequence> textGetter, @NotNull Function0<? extends EditorColorsScheme> colorGetter) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        Intrinsics.checkNotNullParameter(colorGetter, (String)"colorGetter");
        this.myEditor = myEditor;
        this.textGetter = textGetter;
        this.colorGetter = colorGetter;
        this.settingsStore = LogHighlightingSettingsStore.Companion.getInstance();
        Iterable iterable = this.settingsStore.getMyState().getPatterns();
        LogHighlightingIterator logHighlightingIterator = this;
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LogHighlightingPattern it = (LogHighlightingPattern)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LogHighlightingPattern it = (LogHighlightingPattern)element$iv$iv;
            boolean bl2 = false;
            try {
                pair = TuplesKt.to((Object)Pattern.compile(it.getPattern(), 2), (Object)it);
            }
            catch (PatternSyntaxException e) {
                pair = null;
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        logHighlightingIterator.myPatterns = (List)destination$iv$iv;
        this.parsedTokens = new ArrayList();
        this.eventPieces = new ArrayList();
        this.currentEventLineRange = new IntRange(0, 0);
        this.curEvent = "";
        int startLine = this.myEditor.getDocument().getLineNumber(startOffset);
        this.currentEventLineRange = IdeologContextDetectorKt.detectIdeologContext(this.myEditor).getEvent(startLine);
        IntRange prevEventLineRange = IdeologContextDetectorKt.detectIdeologContext(this.myEditor).getEvent(this.currentEventLineRange.getFirst() - 1);
        this.reparsePiecesLines(prevEventLineRange, this.currentEventLineRange);
        Iterable $this$forEachIndexed$iv = this.eventPieces;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EventPiece eventPiece = (EventPiece)item$iv;
            int index = n;
            boolean bl = false;
            int offsetStart = eventPiece.component1();
            int offsetEnd = eventPiece.component2();
            boolean bl4 = offsetStart <= startOffset ? startOffset <= offsetEnd : false;
            if (!bl4) continue;
            this.eventPiecePointer = index;
        }
    }

    @NotNull
    protected final Editor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public final Function0<CharSequence> getTextGetter() {
        return this.textGetter;
    }

    @NotNull
    public final Function0<EditorColorsScheme> getColorGetter() {
        return this.colorGetter;
    }

    private final CharSequence getMyText() {
        return (CharSequence)this.textGetter.invoke();
    }

    private final EditorColorsScheme getMyColors() {
        return (EditorColorsScheme)this.colorGetter.invoke();
    }

    @NotNull
    protected final LogHighlightingSettingsStore getSettingsStore() {
        return this.settingsStore;
    }

    private final void parseNextEvent() {
        int nextStartLine = 0;
        nextStartLine = this.currentEventLineRange.getLast() + 1;
        if (nextStartLine >= this.myEditor.getDocument().getLineCount()) {
            this.eventPieces.clear();
            return;
        }
        int nextStart = 0;
        nextStart = this.getDocument().getLineStartOffset(nextStartLine);
        FoldingModel foldingModel = this.myEditor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel foldingModel2 = foldingModel;
        FoldRegion foldRegion = foldingModel2.getCollapsedRegionAtOffset(nextStart);
        if (foldRegion != null) {
            FoldRegion it = foldRegion;
            boolean bl = false;
            if (!it.isExpanded()) {
                nextStartLine = this.getDocument().getLineNumber(it.getEndOffset()) + 1;
                if (nextStartLine >= this.myEditor.getDocument().getLineCount()) {
                    this.eventPieces.clear();
                    return;
                }
                nextStart = this.getDocument().getLineStartOffset(nextStartLine);
            }
        }
        IntRange nextLineRange = IdeologContextDetectorKt.detectIdeologContext(this.myEditor).getEvent(nextStartLine);
        this.reparsePiecesLines(this.currentEventLineRange, nextLineRange);
        this.currentEventLineRange = nextLineRange;
        this.eventPiecePointer = 0;
    }

    private final void parsePreviousEvent() {
        if (this.currentEventLineRange.getFirst() == 0) {
            this.eventPieces.clear();
            return;
        }
        IntRange prevLineRange = IdeologContextDetectorKt.detectIdeologContext(this.myEditor).getEvent(this.currentEventLineRange.getFirst() - 1);
        IntRange prevPrevLineRange = IdeologContextDetectorKt.detectIdeologContext(this.myEditor).getEvent(prevLineRange.getFirst() - 1);
        this.reparsePiecesLines(prevPrevLineRange, prevLineRange);
        this.currentEventLineRange = prevLineRange;
        this.eventPiecePointer = this.eventPieces.size() - 1;
    }

    private final CharSequence linesSubSequence(IntRange lineRange) {
        if (lineRange.getFirst() < 0 || lineRange.getLast() < lineRange.getFirst() || this.myEditor.getDocument().getLineCount() <= 0) {
            return "";
        }
        Document document = this.myEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int startOffset = document2.getLineStartOffset(lineRange.getFirst());
        int endOffset = document2.getLineEndOffset(Math.min(document2.getLineCount() - 1, lineRange.getLast()));
        return document2.getImmutableCharSequence().subSequence(startOffset, endOffset);
    }

    private final void reparsePiecesLines(IntRange prevEventLineRange, IntRange lineRange) {
        this.reparsePieces(this.linesSubSequence(prevEventLineRange), this.linesSubSequence(lineRange), this.getDocument().getLineStartOffset(lineRange.getFirst()));
    }

    /*
     * WARNING - void declaration
     */
    private final void reparsePieces(CharSequence prevEvent, CharSequence event, int offset) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object info;
        int highlightColumn;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv3;
        Long l;
        Long l2;
        Object object;
        Color.RGBtoHSB(this.getMyColors().getDefaultBackground().getRed(), this.getMyColors().getDefaultBackground().getGreen(), this.getMyColors().getDefaultBackground().getBlue(), myHsbVals);
        this.curEvent = event;
        this.parsedTokens.clear();
        LogFileFormat fileFormat = this.detectLogFileFormatByOffset(this.myEditor, offset);
        if (Intrinsics.areEqual((Object)this.myEditor.getUserData(LogFileHighlighterFactoryKt.getHighlightTimeKey()), (Object)true)) {
            LogFileFormat.tokenize$default(fileFormat, prevEvent, this.parsedTokens, false, 4, null);
        }
        if ((object = fileFormat.extractDate((List<LogToken>)this.parsedTokens)) != null && (object = ((LogToken)object).takeFrom(prevEvent)) != null) {
            Object it2 = object;
            boolean bl = false;
            l2 = fileFormat.parseLogEventTimeSeconds((CharSequence)it2);
        } else {
            l2 = null;
        }
        Long prevTime = l2;
        this.eventPieces.clear();
        Color lineForeground = null;
        Color color = this.getMyColors().getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        lineForeground = color;
        Color lineBackground = null;
        Color color2 = this.getMyColors().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        lineBackground = color2;
        boolean bold = false;
        boolean italic = false;
        this.parsedTokens.clear();
        LogFileFormat.tokenize$default(fileFormat, event, this.parsedTokens, false, 4, null);
        LogToken dateToken = fileFormat.extractDate((List<LogToken>)this.parsedTokens);
        Object object2 = dateToken;
        if (object2 != null && (object2 = ((LogToken)object2).takeFrom(event)) != null) {
            Object it3 = object2;
            boolean bl = false;
            l = fileFormat.parseLogEventTimeSeconds((CharSequence)it3);
        } else {
            l = null;
        }
        Long currentTime = l;
        Iterable $this$filter$iv = this.parsedTokens;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Iterator destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            it = (LogToken)element$iv$iv;
            boolean bl22 = false;
            if (!(!((LogToken)it).isSeparator())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)((Object)destination$iv$iv);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv3 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LogToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl32 = false;
            collection.add(((LogToken)it).takeFrom(event));
        }
        List columnValues = (List)((Object)destination$iv$iv);
        int numColumns = columnValues.size();
        Integer n = (Integer)this.myEditor.getUserData(LogFileHighlighterFactoryKt.getHighlightingUserKey());
        int n2 = highlightColumn = n != null ? n : -1;
        boolean bl4 = 0 <= highlightColumn ? highlightColumn < numColumns : false;
        if (bl4) {
            CharSequence columnValue = (CharSequence)columnValues.get(highlightColumn);
            Color color3 = this.getMyColors().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getDefaultBackground(...)");
            Color color4 = Companion.getLineBackground(columnValue, color3);
            if (color4 == null) {
                color4 = lineBackground;
            }
            lineBackground = color4;
        }
        HashSet hashSet = (HashSet)this.myEditor.getUserData(LogFileHighlighterFactoryKt.getHighlightingSetUserKey());
        Set highlightingSet = hashSet != null ? (Set)hashSet : SetsKt.emptySet();
        block2: for (Pair pair : this.myPatterns) {
            Pattern pattern = (Pattern)pair.component1();
            info = (LogHighlightingPattern)pair.component2();
            if (!fileFormat.validateFormatUUID(((LogHighlightingPattern)info).getFormatId()) || ((LogHighlightingPattern)info).getAction() != LogHighlightingAction.HIGHLIGHT_LINE) continue;
            if (((LogHighlightingPattern)info).getCaptureGroup() >= 0) {
                Color color5;
                if ((CharSequence)CollectionsKt.getOrNull((List)columnValues, (int)((LogHighlightingPattern)info).getCaptureGroup()) == null) break;
                if (!pattern.matcher((CharSequence)it).find()) continue;
                Color color6 = ((LogHighlightingPattern)info).getBackgroundColor();
                if (color6 == null) {
                    color6 = lineBackground = lineBackground;
                }
                if ((color5 = ((LogHighlightingPattern)info).getForegroundColor()) == null) {
                    color5 = lineForeground;
                }
                lineForeground = color5;
                italic = ((LogHighlightingPattern)info).getItalic();
                bold = ((LogHighlightingPattern)info).getBold();
                break;
            }
            it = columnValues.iterator();
            while (it.hasNext()) {
                Color color7;
                CharSequence it4 = (CharSequence)it.next();
                if (!pattern.matcher(it4).find()) continue;
                Color color8 = ((LogHighlightingPattern)info).getBackgroundColor();
                if (color8 == null) {
                    color8 = lineBackground = lineBackground;
                }
                if ((color7 = ((LogHighlightingPattern)info).getForegroundColor()) == null) {
                    color7 = lineForeground;
                }
                lineForeground = color7;
                italic = ((LogHighlightingPattern)info).getItalic();
                bold = ((LogHighlightingPattern)info).getBold();
                continue block2;
            }
        }
        for (String string : highlightingSet) {
            if (!StringsKt.contains$default((CharSequence)event, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            CharSequence charSequence = string;
            Color color9 = this.getMyColors().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color9, (String)"getDefaultBackground(...)");
            Color color10 = Companion.getLineBackground(charSequence, color9);
            if (color10 == null) {
                color10 = lineBackground;
            }
            lineBackground = color10;
        }
        Iterable iterable = this.myPatterns;
        boolean $i$f$filter2 = false;
        info = iterable;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Pair it5 = (Pair)element$iv$iv;
            boolean bl5 = false;
            if (!(((LogHighlightingPattern)it5.getSecond()).getAction() == LogHighlightingAction.HIGHLIGHT_MATCH)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List partHighlighters = (List)destination$iv$iv2;
        Iterable $this$filter$iv3 = this.myPatterns;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it6 = (Pair)element$iv$iv;
            boolean bl6 = false;
            if (!(((LogHighlightingPattern)it6.getSecond()).getAction() == LogHighlightingAction.HIGHLIGHT_FIELD)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv3;
        int valueIndex = 0;
        int timeIndex = fileFormat.getTimeFieldIndex();
        Iterable $this$forEachIndexed$iv = this.parsedTokens;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Collection collection;
            Object item$iv$iv;
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv;
            Object pattern;
            int n3;
            Object element$iv$iv2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Pair pair;
            void $this$filterTo$iv$iv4;
            Object info2;
            void token;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LogToken bl6 = (LogToken)item$iv;
            int captureGroup = n4;
            boolean bl7 = false;
            if (token.isSeparator()) {
                this.highlightSeparator((LogToken)token, offset, lineForeground, lineBackground, bold, italic);
                continue;
            }
            CharSequence value = token.takeFrom(event);
            Ref.ObjectRef valueForeground = new Ref.ObjectRef();
            valueForeground.element = lineForeground;
            Ref.ObjectRef valueBackground = new Ref.ObjectRef();
            valueBackground.element = lineBackground;
            boolean valueBold = bold;
            boolean valueItalic = italic;
            if (prevTime != null && currentTime != null && valueIndex == timeIndex && Intrinsics.areEqual((Object)this.myEditor.getUserData(LogFileHighlighterFactoryKt.getHighlightTimeKey()), (Object)true)) {
                long diff = Math.abs(prevTime - currentTime);
                long diffLtd = Math.min(15000L, diff);
                valueBackground.element = new Color(Color.HSBtoRGB((float)((long)120 - diffLtd * (long)120 / 15000L) / 360.0f, myHsbVals[2] < 0.5f ? 0.9f : 0.2f, myHsbVals[2] < 0.5f ? 0.3f : 0.9f));
            }
            for (Pair pair2 : list) {
                Color color11;
                Pattern pattern2 = (Pattern)pair2.component1();
                info2 = (LogHighlightingPattern)pair2.component2();
                if (!this.acceptHighlighter((LogHighlightingPattern)info2, fileFormat, captureGroup) || !pattern2.matcher(value).find()) continue;
                Object object3 = ((LogHighlightingPattern)info2).getForegroundColor();
                if (object3 == null) {
                    object3 = valueForeground.element = (Color)valueForeground.element;
                }
                if ((color11 = ((LogHighlightingPattern)info2).getBackgroundColor()) == null) {
                    color11 = (Color)valueBackground.element;
                }
                valueBackground.element = color11;
                valueBold = ((LogHighlightingPattern)info2).getBold();
                valueItalic = ((LogHighlightingPattern)info2).getItalic();
                break;
            }
            Iterable $this$filter$iv4 = partHighlighters;
            boolean $i$f$filter4 = false;
            info2 = $this$filter$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv4) {
                pair = (Pair)element$iv$iv2;
                boolean bl8 = false;
                LogHighlightingPattern info3 = (LogHighlightingPattern)pair.component2();
                if (!this.acceptHighlighter(info3, fileFormat, captureGroup)) continue;
                destination$iv$iv4.add(element$iv$iv2);
            }
            $this$filter$iv4 = (List)destination$iv$iv4;
            boolean $i$f$flatMapSequence = false;
            $this$filterTo$iv$iv4 = $this$flatMap$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                pair = (Pair)element$iv$iv2;
                n3 = 0;
                pattern = (Pattern)pair.component1();
                LogHighlightingPattern info4 = (LogHighlightingPattern)pair.component2();
                Intrinsics.checkNotNull((Object)pattern);
                Sequence list$iv$iv = SequencesKt.flatMapIterable((Sequence)Regex.findAll$default((Regex)new Regex((Pattern)pattern), (CharSequence)value, (int)0, (int)2, null), arg_0 -> LogHighlightingIterator.reparsePieces$lambda$17$lambda$14$lambda$13((LogToken)token, offset, info4, valueForeground, valueBackground, this, arg_0));
                CollectionsKt.addAll((Collection)destination$iv$iv5, (Sequence)list$iv$iv);
            }
            List matchedPieces = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv5));
            matchedPieces.add(new EventPiece(token.getStartOffset() + offset, token.getEndOffset() + offset, new TextAttributes((Color)valueForeground.element, (Color)valueBackground.element, null, null, this.getFont(valueBold, valueItalic)), false));
            UtilKt.addIfNotNull((List)matchedPieces, (Object)this.calculateDateTokenForHighlighting((LogToken)token, dateToken, (Color)valueForeground.element, (Color)valueBackground.element, offset));
            $this$flatMap$iv = matchedPieces;
            ArrayList<EventPiece> arrayList = this.eventPieces;
            boolean $i$f$mapIndexed = false;
            $this$flatMapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            element$iv$iv2 = $this$mapIndexedTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                void index;
                void piece;
                item$iv$iv = element$iv$iv2.next();
                if ((n3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                pattern = (EventPiece)item$iv$iv;
                int info4 = n3;
                collection = destination$iv$iv5;
                boolean bl9 = false;
                collection.add(new LineSegment(piece.getOffsetStart(), piece.getOffsetEnd(), (int)index));
            }
            $this$mapIndexed$iv = LogHighlightingIteratorKt.solveNestedLines((List)destination$iv$iv5);
            boolean $i$f$map2 = false;
            $this$mapIndexedTo$iv$iv = $this$map$iv2;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void lineSegment;
                item$iv$iv = (LineSegment)item$iv$iv2;
                collection = destination$iv$iv5;
                boolean bl10 = false;
                collection.add(new EventPiece(lineSegment.getStart(), lineSegment.getEnd(), ((EventPiece)matchedPieces.get(lineSegment.getId())).getTextAttributes(), ((EventPiece)matchedPieces.get(lineSegment.getId())).isSeparator()));
            }
            arrayList.addAll((List)destination$iv$iv5);
            ++valueIndex;
        }
        this.tryHighlightStacktrace(event, offset);
    }

    protected boolean acceptHighlighter(@NotNull LogHighlightingPattern logHighlightingPattern, @NotNull LogFileFormat fileFormat, int captureGroup) {
        Intrinsics.checkNotNullParameter((Object)logHighlightingPattern, (String)"logHighlightingPattern");
        Intrinsics.checkNotNullParameter((Object)fileFormat, (String)"fileFormat");
        return fileFormat.validateFormatUUID(logHighlightingPattern.getFormatId()) && (logHighlightingPattern.getCaptureGroup() < 0 || logHighlightingPattern.getCaptureGroup() == captureGroup);
    }

    protected void tryHighlightStacktrace(@NotNull CharSequence event, int eventOffset) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = this.myEditor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!this.settingsStore.getMyState().getHighlightLinks() || !ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> LogHighlightingIterator.tryHighlightStacktrace$lambda$19(project2, this, eventOffset, event));
    }

    private final void highlightSeparator(LogToken separator, int offset, Color valueForeground, Color valueBackground, boolean valueBold, boolean valueItalic) {
        this.eventPieces.add(new EventPiece(separator.getStartOffset() + offset, separator.getEndOffset() + offset, new TextAttributes(valueForeground, valueBackground, null, null, this.getFont(valueBold, valueItalic)), false));
    }

    private final EventPiece calculateDateTokenForHighlighting(LogToken token, LogToken dateToken, Color valueForeground, Color valueBackground, int offset) {
        if (Intrinsics.areEqual((Object)token, (Object)dateToken) && !Intrinsics.areEqual((Object)valueForeground, (Object)this.getMyColors().getDefaultForeground())) {
            return new EventPiece(token.getStartOffset() + offset, token.getEndOffset() + offset, new TextAttributes((Color)LogColorsKt.getDATE_COLOR(), valueBackground, null, null, this.getFont(false, false)), false);
        }
        return null;
    }

    private final int getFont(boolean bold, boolean italic) {
        return (bold ? 1 : 0) + (italic ? 2 : 0);
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        return this.eventPieces.get(this.eventPiecePointer).getTextAttributes();
    }

    public int getStart() {
        return this.eventPieces.get(this.eventPiecePointer).getOffsetStart();
    }

    public int getEnd() {
        return this.eventPieces.get(this.eventPiecePointer).getOffsetEnd();
    }

    @NotNull
    public IElementType getTokenType() {
        return LogFileHighlighterFactoryKt.getLOG_TOKEN_SEPARATOR();
    }

    public void advance() {
        if (this.eventPiecePointer < this.eventPieces.size() - 1) {
            int n = this.eventPiecePointer;
            this.eventPiecePointer = n + 1;
        } else {
            this.parseNextEvent();
        }
    }

    public void retreat() {
        if (this.eventPiecePointer > 0) {
            int n = this.eventPiecePointer;
            this.eventPiecePointer = n + -1;
        } else {
            this.parsePreviousEvent();
        }
    }

    public boolean atEnd() {
        return this.eventPieces.isEmpty();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    @NotNull
    public LogFileFormat detectLogFileFormatByOffset(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return LogFileFormatsKt.detectLogFileFormat(this.myEditor);
    }

    public static /* synthetic */ LogFileFormat detectLogFileFormatByOffset$default(LogHighlightingIterator logHighlightingIterator, Editor editor, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: detectLogFileFormatByOffset");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return logHighlightingIterator.detectLogFileFormatByOffset(editor, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable reparsePieces$lambda$17$lambda$14$lambda$13(LogToken $token, int $offset, LogHighlightingPattern $info, Ref.ObjectRef $valueForeground, Ref.ObjectRef $valueBackground, LogHighlightingIterator this$0, MatchResult it) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$mapNotNull$iv = CollectionsKt.drop((Iterable)((Iterable)it.getGroups()), (int)1);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EventPiece eventPiece;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MatchGroup matchGroup = (MatchGroup)element$iv$iv;
            boolean bl2 = false;
            if (matchGroup != null) {
                Color color;
                boolean bl3 = false;
                int n = $token.getStartOffset() + $offset + matchGroup.getRange().getFirst();
                int n2 = $token.getStartOffset() + $offset + matchGroup.getRange().getLast() + 1;
                Color color2 = $info.getForegroundColor();
                if (color2 == null) {
                    color2 = (Color)$valueForeground.element;
                }
                if ((color = $info.getBackgroundColor()) == null) {
                    color = (Color)$valueBackground.element;
                }
                eventPiece = new EventPiece(n, n2, new TextAttributes(color2, color, null, null, this$0.getFont($info.getBold(), $info.getItalic())), false);
            } else {
                eventPiece = null;
            }
            if (eventPiece == null) continue;
            EventPiece it$iv$iv = eventPiece;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void tryHighlightStacktrace$lambda$19$lambda$18(LogHeavyFilterService $service, LogHighlightingIterator this$0, int $eventOffset, CharSequence $event) {
        $service.enqueueHeavyFiltering(this$0.myEditor, $eventOffset, $event);
    }

    private static final void tryHighlightStacktrace$lambda$19(Project $project, LogHighlightingIterator this$0, int $eventOffset, CharSequence $event) {
        LogHeavyFilterService service = LogHeavyFilterService.Companion.getInstance($project);
        ApplicationManager.getApplication().runReadAction(() -> LogHighlightingIterator.tryHighlightStacktrace$lambda$19$lambda$18(service, this$0, $eventOffset, $event));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ideolog/highlighting/LogHighlightingIterator$Companion;", "", "<init>", "()V", "myHsbVals", "", "getMyHsbVals", "()[F", "getLineBackground", "Ljava/awt/Color;", "columnValue", "", "defaultBackground", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final float[] getMyHsbVals() {
            return myHsbVals;
        }

        @Nullable
        public final Color getLineBackground(@Nullable CharSequence columnValue, @NotNull Color defaultBackground) {
            Intrinsics.checkNotNullParameter((Object)defaultBackground, (String)"defaultBackground");
            if (columnValue == null) {
                return null;
            }
            int hash = Math.abs(columnValue.hashCode()) % 360;
            float[] bgHsl = Color.RGBtoHSB(defaultBackground.getRed(), defaultBackground.getGreen(), defaultBackground.getBlue(), this.getMyHsbVals());
            bgHsl[0] = (float)hash / 360.0f;
            float f = bgHsl[1] = bgHsl[2] < 0.5f ? 1.0f : 0.2f;
            if (bgHsl[2] < 0.5f) {
                bgHsl[2] = 0.3f;
            }
            return new Color(Color.HSBtoRGB(bgHsl[0], bgHsl[1], bgHsl[2]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ideolog/highlighting/LogHighlightingIterator$EventPiece;", "", "offsetStart", "", "offsetEnd", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "isSeparator", "", "<init>", "(IILcom/intellij/openapi/editor/markup/TextAttributes;Z)V", "getOffsetStart", "()I", "getOffsetEnd", "getTextAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "intellij.ideolog"})
    private static final class EventPiece {
        private final int offsetStart;
        private final int offsetEnd;
        @NotNull
        private final TextAttributes textAttributes;
        private final boolean isSeparator;

        public EventPiece(int offsetStart, int offsetEnd, @NotNull TextAttributes textAttributes, boolean isSeparator) {
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            this.offsetStart = offsetStart;
            this.offsetEnd = offsetEnd;
            this.textAttributes = textAttributes;
            this.isSeparator = isSeparator;
        }

        public final int getOffsetStart() {
            return this.offsetStart;
        }

        public final int getOffsetEnd() {
            return this.offsetEnd;
        }

        @NotNull
        public final TextAttributes getTextAttributes() {
            return this.textAttributes;
        }

        public final boolean isSeparator() {
            return this.isSeparator;
        }

        public final int component1() {
            return this.offsetStart;
        }

        public final int component2() {
            return this.offsetEnd;
        }

        @NotNull
        public final TextAttributes component3() {
            return this.textAttributes;
        }

        public final boolean component4() {
            return this.isSeparator;
        }

        @NotNull
        public final EventPiece copy(int offsetStart, int offsetEnd, @NotNull TextAttributes textAttributes, boolean isSeparator) {
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            return new EventPiece(offsetStart, offsetEnd, textAttributes, isSeparator);
        }

        public static /* synthetic */ EventPiece copy$default(EventPiece eventPiece, int n, int n2, TextAttributes textAttributes, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = eventPiece.offsetStart;
            }
            if ((n3 & 2) != 0) {
                n2 = eventPiece.offsetEnd;
            }
            if ((n3 & 4) != 0) {
                textAttributes = eventPiece.textAttributes;
            }
            if ((n3 & 8) != 0) {
                bl = eventPiece.isSeparator;
            }
            return eventPiece.copy(n, n2, textAttributes, bl);
        }

        @NotNull
        public String toString() {
            return "EventPiece(offsetStart=" + this.offsetStart + ", offsetEnd=" + this.offsetEnd + ", textAttributes=" + this.textAttributes + ", isSeparator=" + this.isSeparator + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.offsetStart);
            result = result * 31 + Integer.hashCode(this.offsetEnd);
            result = result * 31 + this.textAttributes.hashCode();
            result = result * 31 + Boolean.hashCode(this.isSeparator);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EventPiece)) {
                return false;
            }
            EventPiece eventPiece = (EventPiece)other;
            if (this.offsetStart != eventPiece.offsetStart) {
                return false;
            }
            if (this.offsetEnd != eventPiece.offsetEnd) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textAttributes, (Object)eventPiece.textAttributes)) {
                return false;
            }
            return this.isSeparator == eventPiece.isSeparator;
        }
    }
}

