/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.file;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.file.LogFileEditor;
import com.intellij.ideolog.file.LogFileFormatNotificationProviderKt;
import com.intellij.ideolog.highlighting.settings.LogHighlightingConfigurable;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.PlatformUtils;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ideolog/file/LogFileFormatNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.ideolog"})
public final class LogFileFormatNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DONT_SHOW_AGAIN_KEY = "log.file.format.editor.notification.disabled";

    @NotNull
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return arg_0 -> LogFileFormatNotificationProvider.collectNotificationData$lambda$4(project, file, arg_0);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$0(Project $project, VirtualFile $file) {
        ShowSettingsUtil.getInstance().editConfigurable($project, (Configurable)new LogHighlightingConfigurable());
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$1(Editor $editor, VirtualFile $file, Project $project) {
        $editor.putUserData(LogFileFormatNotificationProviderKt.getHIDDEN_KEY(), LogFileFormatNotificationProviderKt.getHIDDEN_KEY());
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$2(PropertiesComponent $propertiesComponent, VirtualFile $file, Project $project) {
        $propertiesComponent.setValue(DONT_SHOW_AGAIN_KEY, true);
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$4(Project $project, VirtualFile $file, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        boolean formatDetected;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof LogFileEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)it).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        LogFileFormat logFormat = LogFileFormatsKt.detectLogFileFormat(editor2);
        if (propertiesComponent.getBoolean(DONT_SHOW_AGAIN_KEY) || editor2.getUserData(LogFileFormatNotificationProviderKt.getHIDDEN_KEY()) != null) {
            return null;
        }
        boolean bl = formatDetected = logFormat.getMyRegexLogParser() != null;
        if (formatDetected && PlatformUtils.isPhpStorm()) {
            return null;
        }
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u244_u24lambda_u243 = editorNotificationPanel = new EditorNotificationPanel();
        boolean bl2 = false;
        if (formatDetected) {
            String formatName = logFormat.getMyRegexLogParser().getOtherParsingSettings().getName();
            Object[] objectArray = new Object[]{formatName};
            v2 = $this$collectNotificationData_u24lambda_u244_u24lambda_u243.text(IdeologBundle.message("label.log.format.recognized", objectArray));
        } else {
            $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.configure.log.formats", new Object[0]), () -> LogFileFormatNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$0($project, $file));
            v2 = $this$collectNotificationData_u24lambda_u244_u24lambda_u243.text(IdeologBundle.message("label.log.format.not.recognized", new Object[0]));
        }
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.hide.notification", new Object[0]), () -> LogFileFormatNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$1(editor2, $file, $project));
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.don.t.show.again", new Object[0]), () -> LogFileFormatNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$2(propertiesComponent, $file, $project));
        EditorNotificationPanel panel = editorNotificationPanel;
        return panel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ideolog/file/LogFileFormatNotificationProvider$Companion;", "", "<init>", "()V", "DONT_SHOW_AGAIN_KEY", "", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

