/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 38868790755807L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(663214200 + (char)-19642, 663214200 + (char)-4810, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(663214200 + (char)-19641, -663214200 + -((char)-4484), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 4236988731118L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.Z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(2144043060 - (char)-1113, -2144043060 - -((char)-28703), (int)l2) + string + WindowsNamedPipeAgentIpc.b(2144043060 - (char)-1112, -2144043060 - -((char)-8501), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(2144043060 - (char)-1111, 2144043060 - (char)-2154, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 40269973607384L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.Z();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1092), -360311430 - -((char)-3520), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1095), -360180360 + -((char)-8615), (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1094), 360180360 + (char)-23423, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1081), 360180360 + (char)-15626, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1080), 360180360 + (char)-4813, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1083), 360180360 + (char)-9997, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1081), 360180360 + (char)-15626, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-360180360 + -((char)-1082), -360180360 + -((char)-16017), (int)l2));
                            if (ActionTimestamp.Z() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.Z(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 3452190089212L;
                    bl = SshAgentIpcService.Z();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 129647922645476L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                bl = SshAgentIpcService.Z();
                synchronized (object3) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl3 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39845280 + -16087, 39845280 + 15227, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16088, 39845280 + 5835, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16085, -39845280 + -11689, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39845280 + -16087, 39845280 + 15227, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16086, -39845280 + -19940, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39845280 + -16087, 39845280 + 15227, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16075, -39845280 + -19500, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16076, 39845280 + 29817, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl8;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl9 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl8 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl8) {
                boolean bl10 = false;
                String string = WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16085, -39845280 + -11689, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl11 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-39845280 + -16087, 39845280 + 15227, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-39845280 + -16083, 39845280 + 31138, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-39845280 + -16073, 39845280 + 16230, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 135135489536148L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1361424090 + -((char)-16268), -1361424090 + -((char)-29163), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 49518424538278L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1746638820 - (char)-1181, -1746638820 - -((char)-3682), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u001e\u0013\u001f)Q^r\u00e6\u00fcZ\u001f\u0091\u00d5\u0018\u00f8\u00d7\u0014\u00f4\u0005\u0014]ywbG\u00f5\u00cd\u0016\u0089BtFz\u001b\u00cc<\u007fOo@";
                        var4_3 = "\u001e\u0013\u001f)Q^r\u00e6\u00fcZ\u001f\u0091\u00d5\u0018\u00f8\u00d7\u0014\u00f4\u0005\u0014]ywbG\u00f5\u00cd\u0016\u0089BtFz\u001b\u00cc<\u007fOo@".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 117;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 63;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 43;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 52;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 117;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 30;
                                        break;
                                    }
                                    default: {
                                        v11 = 86;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x2026) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 184;
                            case 1 -> 54;
                            case 2 -> 18;
                            case 3 -> 93;
                            case 4 -> 123;
                            case 5 -> 20;
                            case 6 -> 205;
                            case 7 -> 59;
                            case 8 -> 64;
                            case 9 -> 92;
                            case 10 -> 125;
                            case 11 -> 248;
                            case 12 -> 206;
                            case 13 -> 131;
                            case 14 -> 73;
                            case 15 -> 154;
                            case 16 -> 23;
                            case 17 -> 199;
                            case 18 -> 223;
                            case 19 -> 147;
                            case 20 -> 180;
                            case 21 -> 215;
                            case 22 -> 65;
                            case 23 -> 163;
                            case 24 -> 246;
                            case 25 -> 218;
                            case 26 -> 12;
                            case 27 -> 98;
                            case 28 -> 235;
                            case 29 -> 58;
                            case 30 -> 171;
                            case 31 -> 77;
                            case 32 -> 208;
                            case 33 -> 5;
                            case 34 -> 207;
                            case 35 -> 130;
                            case 36 -> 35;
                            case 37 -> 87;
                            case 38 -> 224;
                            case 39 -> 96;
                            case 40 -> 127;
                            case 41 -> 244;
                            case 42 -> 101;
                            case 43 -> 102;
                            case 44 -> 95;
                            case 45 -> 25;
                            case 46 -> 57;
                            case 47 -> 118;
                            case 48 -> 158;
                            case 49 -> 135;
                            case 50 -> 55;
                            case 51 -> 197;
                            case 52 -> 225;
                            case 53 -> 60;
                            case 54 -> 156;
                            case 55 -> 56;
                            case 56 -> 22;
                            case 57 -> 0;
                            case 58 -> 217;
                            case 59 -> 100;
                            case 60 -> 42;
                            case 61 -> 67;
                            case 62 -> 2;
                            case 63 -> 116;
                            case 64 -> 124;
                            case 65 -> 214;
                            case 66 -> 14;
                            case 67 -> 83;
                            case 68 -> 17;
                            case 69 -> 232;
                            case 70 -> 255;
                            case 71 -> 53;
                            case 72 -> 13;
                            case 73 -> 150;
                            case 74 -> 104;
                            case 75 -> 138;
                            case 76 -> 177;
                            case 77 -> 194;
                            case 78 -> 122;
                            case 79 -> 106;
                            case 80 -> 121;
                            case 81 -> 21;
                            case 82 -> 62;
                            case 83 -> 157;
                            case 84 -> 75;
                            case 85 -> 52;
                            case 86 -> 140;
                            case 87 -> 172;
                            case 88 -> 186;
                            case 89 -> 107;
                            case 90 -> 250;
                            case 91 -> 4;
                            case 92 -> 15;
                            case 93 -> 178;
                            case 94 -> 190;
                            case 95 -> 82;
                            case 96 -> 45;
                            case 97 -> 32;
                            case 98 -> 63;
                            case 99 -> 166;
                            case 100 -> 192;
                            case 101 -> 66;
                            case 102 -> 71;
                            case 103 -> 30;
                            case 104 -> 72;
                            case 105 -> 203;
                            case 106 -> 249;
                            case 107 -> 148;
                            case 108 -> 238;
                            case 109 -> 112;
                            case 110 -> 201;
                            case 111 -> 242;
                            case 112 -> 222;
                            case 113 -> 40;
                            case 114 -> 161;
                            case 115 -> 196;
                            case 116 -> 151;
                            case 117 -> 168;
                            case 118 -> 143;
                            case 119 -> 189;
                            case 120 -> 19;
                            case 121 -> 113;
                            case 122 -> 76;
                            case 123 -> 28;
                            case 124 -> 50;
                            case 125 -> 254;
                            case 126 -> 165;
                            case 127 -> 216;
                            case 128 -> 99;
                            case 129 -> 119;
                            case 130 -> 78;
                            case 131 -> 134;
                            case 132 -> 94;
                            case 133 -> 110;
                            case 134 -> 74;
                            case 135 -> 111;
                            case 136 -> 152;
                            case 137 -> 47;
                            case 138 -> 90;
                            case 139 -> 142;
                            case 140 -> 182;
                            case 141 -> 187;
                            case 142 -> 137;
                            case 143 -> 230;
                            case 144 -> 97;
                            case 145 -> 149;
                            case 146 -> 229;
                            case 147 -> 132;
                            case 148 -> 68;
                            case 149 -> 16;
                            case 150 -> 210;
                            case 151 -> 89;
                            case 152 -> 33;
                            case 153 -> 120;
                            case 154 -> 220;
                            case 155 -> 39;
                            case 156 -> 105;
                            case 157 -> 43;
                            case 158 -> 227;
                            case 159 -> 145;
                            case 160 -> 179;
                            case 161 -> 188;
                            case 162 -> 91;
                            case 163 -> 251;
                            case 164 -> 34;
                            case 165 -> 153;
                            case 166 -> 3;
                            case 167 -> 176;
                            case 168 -> 88;
                            case 169 -> 133;
                            case 170 -> 170;
                            case 171 -> 173;
                            case 172 -> 126;
                            case 173 -> 61;
                            case 174 -> 26;
                            case 175 -> 198;
                            case 176 -> 211;
                            case 177 -> 155;
                            case 178 -> 234;
                            case 179 -> 185;
                            case 180 -> 212;
                            case 181 -> 226;
                            case 182 -> 8;
                            case 183 -> 195;
                            case 184 -> 11;
                            case 185 -> 48;
                            case 186 -> 114;
                            case 187 -> 174;
                            case 188 -> 209;
                            case 189 -> 219;
                            case 190 -> 239;
                            case 191 -> 115;
                            case 192 -> 1;
                            case 193 -> 36;
                            case 194 -> 146;
                            case 195 -> 252;
                            case 196 -> 85;
                            case 197 -> 41;
                            case 198 -> 51;
                            case 199 -> 27;
                            case 200 -> 183;
                            case 201 -> 139;
                            case 202 -> 44;
                            case 203 -> 79;
                            case 204 -> 162;
                            case 205 -> 253;
                            case 206 -> 247;
                            case 207 -> 136;
                            case 208 -> 231;
                            case 209 -> 129;
                            case 210 -> 117;
                            case 211 -> 228;
                            case 212 -> 245;
                            case 213 -> 202;
                            case 214 -> 233;
                            case 215 -> 200;
                            case 216 -> 69;
                            case 217 -> 141;
                            case 218 -> 221;
                            case 219 -> 181;
                            case 220 -> 159;
                            case 221 -> 204;
                            case 222 -> 128;
                            case 223 -> 70;
                            case 224 -> 103;
                            case 225 -> 38;
                            case 226 -> 175;
                            case 227 -> 29;
                            case 228 -> 109;
                            case 229 -> 213;
                            case 230 -> 9;
                            case 231 -> 46;
                            case 232 -> 240;
                            case 233 -> 160;
                            case 234 -> 80;
                            case 235 -> 191;
                            case 236 -> 81;
                            case 237 -> 37;
                            case 238 -> 144;
                            case 239 -> 164;
                            case 240 -> 6;
                            case 241 -> 84;
                            case 242 -> 31;
                            case 243 -> 7;
                            case 244 -> 167;
                            case 245 -> 237;
                            case 246 -> 243;
                            case 247 -> 241;
                            case 248 -> 236;
                            case 249 -> 86;
                            case 250 -> 193;
                            case 251 -> 108;
                            case 252 -> 169;
                            case 253 -> 49;
                            case 254 -> 10;
                            default -> 24;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.Z("I1XWZ");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 36434008776881L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.Z();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(198833190 - (char)-30390, -198833190 - -((char)-31628), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(198833190 - (char)-30386, -198833190 - -((char)-11715), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(198833190 - (char)-30365, 198833190 - (char)-5098, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(198833190 - (char)-30390, -198833190 - -((char)-31628), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(198833190 - (char)-30386, -198833190 - -((char)-11715), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(198833190 - (char)-30366, 198833190 - (char)-27010, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 101652532995740L;
                        boolean bl3 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(752997150 - 26166, 752997150 - 21729, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(752997150 - 26163, 752997150 - (char)-31224, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 92216907273439L;
                boolean bl2 = SshAgentIpcService.Z();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(335539200 - 3406, -335539200 - -4128, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(335539200 - 3402, -335539200 - -22137, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(335539200 - 3415, 335539200 - 23435, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(335539200 - 3402, -335539200 - -22137, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(335539200 - 3408, 335539200 - 8820, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(335539200 - 3406, -335539200 - -4128, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(335539200 - 3402, -335539200 - -22137, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(335539200 - 3418, 335539200 + 1601, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(335539200 - 3406, -335539200 - -4128, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(335539200 - 3402, -335539200 - -22137, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(335539200 - 3417, -335539200 - -13136, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(335539200 - 3406, -335539200 - -4128, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(335539200 - 3402, -335539200 - -22137, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(335539200 - 3420, 335539200 - 25773, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 134380326046919L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.Z();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21744, -610655130 + -((char)-22482), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(610655130 + (char)-21740, -610655130 + -((char)-3579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21725, 610655130 + (char)-9571, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21728, -610655130 + -((char)-1105), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21744, -610655130 + -((char)-22482), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(610655130 + (char)-21740, -610655130 + -((char)-3579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21727, 610655130 + (char)-729, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21744, -610655130 + -((char)-22482), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(610655130 + (char)-21740, -610655130 + -((char)-3579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21730, -610655130 + -((char)-17679), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21744, -610655130 + -((char)-22482), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(610655130 + (char)-21740, -610655130 + -((char)-3579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21729, -610655130 + -((char)-4042), (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21744, -610655130 + -((char)-22482), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(610655130 + (char)-21740, -610655130 + -((char)-3579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(610655130 + (char)-21780, -610655130 + -((char)-17975), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(610655130 + (char)-21779, -610655130 + -((char)-5511), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00cb4\u00b4o\u00c78\u00a5\u00c9\u0014\u00e7\u0092\t\\\u008e\u00d6#\u000e\u0012\u00f7\u0085\u00ac\u0006o\u00b1\u00a4\u0000\u008cCl\u0006\u00a1\u00a7\u00f9\u001d\u00047\u0018\u008fZdu\u00a16\u00c4\u00d2&\u0011\f\u0000Q\u0005\tk\u00be\u001c\u00ba\u00e3\u0099\u00fd_\u0088\t\u00eb\u0094v\u001d\u0088\u00a4\u00f9\u00c8\u00bd\u0005\u00e8z\u00d0\u00a6;\b+\r\u00a89\u0016\u00d4\u0099\u00b6\u0014\u00f3\u00ae\u00f3@\u00bc]P\u00e8\u0012\u00f6.89^\u00edo\u0099&\u0089{\u0005\u00ca\u00f2\u0094\u00b7\u00b3\u001e?\u009d?>[\u009b9\u001d<\u00fc\u0004:\u001cb\u0002\u00e3>\u009cx\u0007mN\u00cd3)\u0091\u00c7\u0012]\u000f\u0010\u0088>-\u008fN\u009fmd\u00cbawtt\u00fe\u00a0\u00ef\t\u0015l\u007f\u0013\u00faB\u0091\u008b^\u0010q\u00bd\u0012\u00ff\u00a9\u0091\u0091\u00a5TY\u0084s\n\u001eo\u00f3?\u00cf2)\u00cb\u0094,E\u0087\u00c2~\u009e\u0091\u00f0\u00e1\u00a2\u00aa\u00ef\u00d0?K\u000b\u0095z.\u00cf\u00da\u0016\u00cfP\u00e2N\u00c2\u0014z\u00b9\u00c4W\u00b0QJ\u00d8\u0091:\u0085\u00e5[\u000f\u00c10H\u00b3\u00e4\u00d4\u009cZ\u00b0z|\u00dc;j2\u00f9\b\u000ew\fv\u0082=\u000b\u008b\f\u00c3\u00ad\u00a56\u00aaW\u00e0\u00c1S\u009d6\u00efF\u00bd\u00cdj:S\u00d6\u00df\u00f1\u00b4\u0097\u00c0j\u00ad\u0096\u0016b\u0085\u00aer+\u00b0\u00cb\u000e\u00d7w\u00ce\u00f2Fs\u00fa\u0010\u00fd\u00e3+\u0085\u00cf\n\u009cQ\u000bK\u00ac\u00c3\u00d9\u0004Ug}\u00da'\u0088\u00a3\\\u00e2]d\u0005\u0092\u00a5Zvw&\u00ef\u001e\u009a\u0092\u00ad\u0005\u00e7\u001f\u00db^\u00a3F\u00c8\u0094K\u00fcr\u00c0\u00cd\u00bd%\u008f.\u00ef\u00c0\u00f5\u00da\u00e0\u00f22\u00e9\u0017\u00cc\u00c5lT56\u00da\u000b\u00c6w\u0005m\u00be<b\u00ac\u0003<6\u0015\u00dd\u00c5f8\u00d5\u00fe\u00e3\u0089\rx?a\u00c5\u00b8/_\u001bw|\u00c9\u0010)p\u009f\u00d6~f\u0093\u009e\u001c\u00c8\u00dc\u009a>\u00cb\u00f5m\u00a5\u00f74\u00e7\u007f\u00a5\u00b9\u00c5~&\u00a1\u00e6\u00a0K\\\u0097\u0017\u00ed\u00d3\"]\u00e0\u00d3\u0087K2\u0007\u00a8\u00ea\u00c7\u00ca`X\u00c5\u0007y\u008f\u0099\nL\u00afV(\f\u0006\u0015l\u00ae\u00bbq>EO\u0001z\u009b\u00fc%\u0007\u00f9\u00cd\u0088\u0003)\b;\u0083i\u00a2\u00b9\u00bb\u0097_\u00d7n\u001e\u0097\u00c2xF\n\u00c0\u0083\u000f\u00b1z\u00ec\u00cay\u0003.\u00ea\u00dbXs\u00c9u\u00def\"\u00cf\b!\u008c\u0098\u00cdA\u00d73\u00a5\u00e5\u0011'\u001c\u0094V#c\u00f7\u00d7M\u00acx\u008c\u0002\u00ab\u00af?F\u009d\u0094(\u00a3\u00c7\u000e\u0011\u0019\u00f8\u00a6\u00fb\u008e~[\u00d1n2\u000fQ\f\u001b\u00f7\u00fe#_{\u0004\u00fbV6HC\u00ca/\u0082\u00b3\u0093oq\u00c3\t\u00f0C\u00bc\u00d7\u00d1\u00ad\u0080\n\u00c5\u00ec\u00a1\u001a?H\u00a0\u00f5\u00f6^\u0018\u0014\u0085_=\u00f5\u00f4\u000b\u00166\u0089\u0081m\u00ce%sF\u0000\u00ca\u00f9\u0007\u00cf\u00c9\u0000\u00d5)\u0093#\u00aa\u00e9\u00e9aoB\u00f6\u0017]G7\u00d3m\u001a\u0089\u00b6\u00f7\u00ea\u009d\u001b\u008b&\u009a8\u00ec\u007fY\u00fbnr\u00f7\u00a1\u00b4\u0087\u00ec\u00ac\u0006\u00a4\u0002\t\u0084\u0000M\u0080\u00b6\u00ffNg\u0018";
                var4_3 = "\u00cb4\u00b4o\u00c78\u00a5\u00c9\u0014\u00e7\u0092\t\\\u008e\u00d6#\u000e\u0012\u00f7\u0085\u00ac\u0006o\u00b1\u00a4\u0000\u008cCl\u0006\u00a1\u00a7\u00f9\u001d\u00047\u0018\u008fZdu\u00a16\u00c4\u00d2&\u0011\f\u0000Q\u0005\tk\u00be\u001c\u00ba\u00e3\u0099\u00fd_\u0088\t\u00eb\u0094v\u001d\u0088\u00a4\u00f9\u00c8\u00bd\u0005\u00e8z\u00d0\u00a6;\b+\r\u00a89\u0016\u00d4\u0099\u00b6\u0014\u00f3\u00ae\u00f3@\u00bc]P\u00e8\u0012\u00f6.89^\u00edo\u0099&\u0089{\u0005\u00ca\u00f2\u0094\u00b7\u00b3\u001e?\u009d?>[\u009b9\u001d<\u00fc\u0004:\u001cb\u0002\u00e3>\u009cx\u0007mN\u00cd3)\u0091\u00c7\u0012]\u000f\u0010\u0088>-\u008fN\u009fmd\u00cbawtt\u00fe\u00a0\u00ef\t\u0015l\u007f\u0013\u00faB\u0091\u008b^\u0010q\u00bd\u0012\u00ff\u00a9\u0091\u0091\u00a5TY\u0084s\n\u001eo\u00f3?\u00cf2)\u00cb\u0094,E\u0087\u00c2~\u009e\u0091\u00f0\u00e1\u00a2\u00aa\u00ef\u00d0?K\u000b\u0095z.\u00cf\u00da\u0016\u00cfP\u00e2N\u00c2\u0014z\u00b9\u00c4W\u00b0QJ\u00d8\u0091:\u0085\u00e5[\u000f\u00c10H\u00b3\u00e4\u00d4\u009cZ\u00b0z|\u00dc;j2\u00f9\b\u000ew\fv\u0082=\u000b\u008b\f\u00c3\u00ad\u00a56\u00aaW\u00e0\u00c1S\u009d6\u00efF\u00bd\u00cdj:S\u00d6\u00df\u00f1\u00b4\u0097\u00c0j\u00ad\u0096\u0016b\u0085\u00aer+\u00b0\u00cb\u000e\u00d7w\u00ce\u00f2Fs\u00fa\u0010\u00fd\u00e3+\u0085\u00cf\n\u009cQ\u000bK\u00ac\u00c3\u00d9\u0004Ug}\u00da'\u0088\u00a3\\\u00e2]d\u0005\u0092\u00a5Zvw&\u00ef\u001e\u009a\u0092\u00ad\u0005\u00e7\u001f\u00db^\u00a3F\u00c8\u0094K\u00fcr\u00c0\u00cd\u00bd%\u008f.\u00ef\u00c0\u00f5\u00da\u00e0\u00f22\u00e9\u0017\u00cc\u00c5lT56\u00da\u000b\u00c6w\u0005m\u00be<b\u00ac\u0003<6\u0015\u00dd\u00c5f8\u00d5\u00fe\u00e3\u0089\rx?a\u00c5\u00b8/_\u001bw|\u00c9\u0010)p\u009f\u00d6~f\u0093\u009e\u001c\u00c8\u00dc\u009a>\u00cb\u00f5m\u00a5\u00f74\u00e7\u007f\u00a5\u00b9\u00c5~&\u00a1\u00e6\u00a0K\\\u0097\u0017\u00ed\u00d3\"]\u00e0\u00d3\u0087K2\u0007\u00a8\u00ea\u00c7\u00ca`X\u00c5\u0007y\u008f\u0099\nL\u00afV(\f\u0006\u0015l\u00ae\u00bbq>EO\u0001z\u009b\u00fc%\u0007\u00f9\u00cd\u0088\u0003)\b;\u0083i\u00a2\u00b9\u00bb\u0097_\u00d7n\u001e\u0097\u00c2xF\n\u00c0\u0083\u000f\u00b1z\u00ec\u00cay\u0003.\u00ea\u00dbXs\u00c9u\u00def\"\u00cf\b!\u008c\u0098\u00cdA\u00d73\u00a5\u00e5\u0011'\u001c\u0094V#c\u00f7\u00d7M\u00acx\u008c\u0002\u00ab\u00af?F\u009d\u0094(\u00a3\u00c7\u000e\u0011\u0019\u00f8\u00a6\u00fb\u008e~[\u00d1n2\u000fQ\f\u001b\u00f7\u00fe#_{\u0004\u00fbV6HC\u00ca/\u0082\u00b3\u0093oq\u00c3\t\u00f0C\u00bc\u00d7\u00d1\u00ad\u0080\n\u00c5\u00ec\u00a1\u001a?H\u00a0\u00f5\u00f6^\u0018\u0014\u0085_=\u00f5\u00f4\u000b\u00166\u0089\u0081m\u00ce%sF\u0000\u00ca\u00f9\u0007\u00cf\u00c9\u0000\u00d5)\u0093#\u00aa\u00e9\u00e9aoB\u00f6\u0017]G7\u00d3m\u001a\u0089\u00b6\u00f7\u00ea\u009d\u001b\u008b&\u009a8\u00ec\u007fY\u00fbnr\u00f7\u00a1\u00b4\u0087\u00ec\u00ac\u0006\u00a4\u0002\t\u0084\u0000M\u0080\u00b6\u00ffNg\u0018".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 20;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "w\u00b8G\u00eb%P\u0087\u0015\u009a\u008c\u00a1E\u00d9\u00e2\u00c1Mm!J\u00ed\u000e\u00b5{\\^\u001a\u0094\u000f\u00b7\u0014\u00b4\u00e7\u0012\u0083\u009c\\\u0010.\u0005\u0082\u0016s\u0005\u00e5\u00a0\u0084S\u00f9X\u00b3";
                    var4_3 = "w\u00b8G\u00eb%P\u0087\u0015\u009a\u008c\u00a1E\u00d9\u00e2\u00c1Mm!J\u00ed\u000e\u00b5{\\^\u001a\u0094\u000f\u00b7\u0014\u00b4\u00e7\u0012\u0083\u009c\\\u0010.\u0005\u0082\u0016s\u0005\u00e5\u00a0\u0084S\u00f9X\u00b3".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 7;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 89;
                            break;
                        }
                        case 1: {
                            v15 = 64;
                            break;
                        }
                        case 2: {
                            v15 = 126;
                            break;
                        }
                        case 3: {
                            v15 = 86;
                            break;
                        }
                        case 4: {
                            v15 = 38;
                            break;
                        }
                        case 5: {
                            v15 = 33;
                            break;
                        }
                        default: {
                            v15 = 33;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFCA61) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 76;
                case 1 -> 54;
                case 2 -> 74;
                case 3 -> 92;
                case 4 -> 158;
                case 5 -> 165;
                case 6 -> 82;
                case 7 -> 221;
                case 8 -> 173;
                case 9 -> 245;
                case 10 -> 121;
                case 11 -> 105;
                case 12 -> 128;
                case 13 -> 222;
                case 14 -> 116;
                case 15 -> 77;
                case 16 -> 127;
                case 17 -> 17;
                case 18 -> 233;
                case 19 -> 23;
                case 20 -> 24;
                case 21 -> 84;
                case 22 -> 109;
                case 23 -> 193;
                case 24 -> 232;
                case 25 -> 86;
                case 26 -> 200;
                case 27 -> 169;
                case 28 -> 59;
                case 29 -> 213;
                case 30 -> 88;
                case 31 -> 207;
                case 32 -> 145;
                case 33 -> 251;
                case 34 -> 15;
                case 35 -> 94;
                case 36 -> 61;
                case 37 -> 41;
                case 38 -> 110;
                case 39 -> 140;
                case 40 -> 93;
                case 41 -> 71;
                case 42 -> 217;
                case 43 -> 176;
                case 44 -> 246;
                case 45 -> 255;
                case 46 -> 85;
                case 47 -> 97;
                case 48 -> 34;
                case 49 -> 171;
                case 50 -> 0;
                case 51 -> 95;
                case 52 -> 67;
                case 53 -> 139;
                case 54 -> 223;
                case 55 -> 119;
                case 56 -> 56;
                case 57 -> 52;
                case 58 -> 227;
                case 59 -> 225;
                case 60 -> 164;
                case 61 -> 18;
                case 62 -> 60;
                case 63 -> 186;
                case 64 -> 62;
                case 65 -> 73;
                case 66 -> 147;
                case 67 -> 218;
                case 68 -> 149;
                case 69 -> 29;
                case 70 -> 241;
                case 71 -> 214;
                case 72 -> 10;
                case 73 -> 79;
                case 74 -> 8;
                case 75 -> 136;
                case 76 -> 14;
                case 77 -> 51;
                case 78 -> 243;
                case 79 -> 106;
                case 80 -> 150;
                case 81 -> 20;
                case 82 -> 198;
                case 83 -> 219;
                case 84 -> 231;
                case 85 -> 138;
                case 86 -> 9;
                case 87 -> 32;
                case 88 -> 111;
                case 89 -> 163;
                case 90 -> 58;
                case 91 -> 133;
                case 92 -> 38;
                case 93 -> 236;
                case 94 -> 132;
                case 95 -> 13;
                case 96 -> 22;
                case 97 -> 16;
                case 98 -> 26;
                case 99 -> 100;
                case 100 -> 90;
                case 101 -> 238;
                case 102 -> 107;
                case 103 -> 33;
                case 104 -> 75;
                case 105 -> 118;
                case 106 -> 248;
                case 107 -> 120;
                case 108 -> 131;
                case 109 -> 194;
                case 110 -> 44;
                case 111 -> 53;
                case 112 -> 146;
                case 113 -> 203;
                case 114 -> 27;
                case 115 -> 30;
                case 116 -> 192;
                case 117 -> 72;
                case 118 -> 234;
                case 119 -> 201;
                case 120 -> 229;
                case 121 -> 156;
                case 122 -> 142;
                case 123 -> 43;
                case 124 -> 170;
                case 125 -> 70;
                case 126 -> 69;
                case 127 -> 179;
                case 128 -> 102;
                case 129 -> 211;
                case 130 -> 215;
                case 131 -> 48;
                case 132 -> 40;
                case 133 -> 108;
                case 134 -> 123;
                case 135 -> 175;
                case 136 -> 204;
                case 137 -> 185;
                case 138 -> 91;
                case 139 -> 49;
                case 140 -> 45;
                case 141 -> 63;
                case 142 -> 228;
                case 143 -> 161;
                case 144 -> 247;
                case 145 -> 244;
                case 146 -> 35;
                case 147 -> 160;
                case 148 -> 154;
                case 149 -> 166;
                case 150 -> 81;
                case 151 -> 174;
                case 152 -> 126;
                case 153 -> 144;
                case 154 -> 5;
                case 155 -> 239;
                case 156 -> 254;
                case 157 -> 57;
                case 158 -> 66;
                case 159 -> 89;
                case 160 -> 177;
                case 161 -> 7;
                case 162 -> 130;
                case 163 -> 252;
                case 164 -> 178;
                case 165 -> 141;
                case 166 -> 230;
                case 167 -> 101;
                case 168 -> 42;
                case 169 -> 152;
                case 170 -> 240;
                case 171 -> 98;
                case 172 -> 210;
                case 173 -> 168;
                case 174 -> 39;
                case 175 -> 148;
                case 176 -> 96;
                case 177 -> 2;
                case 178 -> 55;
                case 179 -> 188;
                case 180 -> 209;
                case 181 -> 31;
                case 182 -> 226;
                case 183 -> 99;
                case 184 -> 235;
                case 185 -> 143;
                case 186 -> 112;
                case 187 -> 83;
                case 188 -> 172;
                case 189 -> 180;
                case 190 -> 212;
                case 191 -> 78;
                case 192 -> 197;
                case 193 -> 134;
                case 194 -> 151;
                case 195 -> 122;
                case 196 -> 28;
                case 197 -> 1;
                case 198 -> 250;
                case 199 -> 124;
                case 200 -> 184;
                case 201 -> 4;
                case 202 -> 162;
                case 203 -> 181;
                case 204 -> 129;
                case 205 -> 37;
                case 206 -> 153;
                case 207 -> 104;
                case 208 -> 11;
                case 209 -> 103;
                case 210 -> 3;
                case 211 -> 187;
                case 212 -> 249;
                case 213 -> 115;
                case 214 -> 237;
                case 215 -> 68;
                case 216 -> 125;
                case 217 -> 50;
                case 218 -> 190;
                case 219 -> 25;
                case 220 -> 224;
                case 221 -> 117;
                case 222 -> 206;
                case 223 -> 199;
                case 224 -> 202;
                case 225 -> 64;
                case 226 -> 196;
                case 227 -> 191;
                case 228 -> 159;
                case 229 -> 12;
                case 230 -> 36;
                case 231 -> 183;
                case 232 -> 253;
                case 233 -> 87;
                case 234 -> 135;
                case 235 -> 80;
                case 236 -> 167;
                case 237 -> 182;
                case 238 -> 205;
                case 239 -> 46;
                case 240 -> 6;
                case 241 -> 242;
                case 242 -> 65;
                case 243 -> 137;
                case 244 -> 114;
                case 245 -> 220;
                case 246 -> 195;
                case 247 -> 47;
                case 248 -> 189;
                case 249 -> 21;
                case 250 -> 157;
                case 251 -> 19;
                case 252 -> 216;
                case 253 -> 113;
                case 254 -> 155;
                default -> 208;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 38531642417588L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1490790180 + 20681, 1490790180 + 11732, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 113287088128399L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1264170150 + -((char)-3197), -1264301220 - -((char)-243), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1264170150 + -((char)-3194), 1264301220 - (char)-16721, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1264170150 + -((char)-3195), 1264301220 - (char)-8136, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "q9\u00f3\u00c2\u00d8q\t[\u0010\u0090\u00c3><\u00db\u0015\u0090\u008e\u0083,r*(z\u0090\u0088";
                    var4_3 = "q9\u00f3\u00c2\u00d8q\t[\u0010\u0090\u00c3><\u00db\u0015\u0090\u008e\u0083,r*(z\u0090\u0088".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 55;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b3\u009e&\u00bb\u009f53\u0001!$\u00ad\u00a2\u00cb^\u0012\u0000_\u00e2\u00f7\u0004\u00e3@D\u00c5\u00a7\t\u00c6n\u0015\u0098\u00c2\u00d9\u00d9G\u000f\u00b9\u00e9of\u00021\u00bc\u00f9\bAL\u001b\u00bc\u00e3\u00b2\u0016\u00d7\u00f9\u00b3\u0098\u00c6\u00cf\u008d\u009f";
                        var4_3 = "\u00b3\u009e&\u00bb\u009f53\u0001!$\u00ad\u00a2\u00cb^\u0012\u0000_\u00e2\u00f7\u0004\u00e3@D\u00c5\u00a7\t\u00c6n\u0015\u0098\u00c2\u00d9\u00d9G\u000f\u00b9\u00e9of\u00021\u00bc\u00f9\bAL\u001b\u00bc\u00e3\u00b2\u0016\u00d7\u00f9\u00b3\u0098\u00c6\u00cf\u008d\u009f".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 59;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 67;
                                break;
                            }
                            case 1: {
                                v15 = 57;
                                break;
                            }
                            case 2: {
                                v15 = 106;
                                break;
                            }
                            case 3: {
                                v15 = 50;
                                break;
                            }
                            case 4: {
                                v15 = 20;
                                break;
                            }
                            case 5: {
                                v15 = 22;
                                break;
                            }
                            default: {
                                v15 = 111;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1659) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 254;
                    case 1 -> 255;
                    case 2 -> 216;
                    case 3 -> 231;
                    case 4 -> 104;
                    case 5 -> 215;
                    case 6 -> 238;
                    case 7 -> 68;
                    case 8 -> 220;
                    case 9 -> 128;
                    case 10 -> 248;
                    case 11 -> 28;
                    case 12 -> 239;
                    case 13 -> 55;
                    case 14 -> 204;
                    case 15 -> 46;
                    case 16 -> 49;
                    case 17 -> 222;
                    case 18 -> 213;
                    case 19 -> 172;
                    case 20 -> 123;
                    case 21 -> 156;
                    case 22 -> 35;
                    case 23 -> 185;
                    case 24 -> 217;
                    case 25 -> 9;
                    case 26 -> 251;
                    case 27 -> 50;
                    case 28 -> 143;
                    case 29 -> 245;
                    case 30 -> 194;
                    case 31 -> 144;
                    case 32 -> 147;
                    case 33 -> 237;
                    case 34 -> 66;
                    case 35 -> 136;
                    case 36 -> 111;
                    case 37 -> 192;
                    case 38 -> 135;
                    case 39 -> 26;
                    case 40 -> 117;
                    case 41 -> 78;
                    case 42 -> 162;
                    case 43 -> 24;
                    case 44 -> 133;
                    case 45 -> 198;
                    case 46 -> 132;
                    case 47 -> 7;
                    case 48 -> 85;
                    case 49 -> 58;
                    case 50 -> 252;
                    case 51 -> 246;
                    case 52 -> 230;
                    case 53 -> 71;
                    case 54 -> 51;
                    case 55 -> 93;
                    case 56 -> 34;
                    case 57 -> 243;
                    case 58 -> 74;
                    case 59 -> 106;
                    case 60 -> 146;
                    case 61 -> 97;
                    case 62 -> 154;
                    case 63 -> 36;
                    case 64 -> 199;
                    case 65 -> 21;
                    case 66 -> 13;
                    case 67 -> 17;
                    case 68 -> 52;
                    case 69 -> 206;
                    case 70 -> 234;
                    case 71 -> 142;
                    case 72 -> 43;
                    case 73 -> 62;
                    case 74 -> 59;
                    case 75 -> 114;
                    case 76 -> 84;
                    case 77 -> 124;
                    case 78 -> 184;
                    case 79 -> 115;
                    case 80 -> 253;
                    case 81 -> 112;
                    case 82 -> 193;
                    case 83 -> 190;
                    case 84 -> 228;
                    case 85 -> 15;
                    case 86 -> 120;
                    case 87 -> 137;
                    case 88 -> 48;
                    case 89 -> 101;
                    case 90 -> 10;
                    case 91 -> 118;
                    case 92 -> 82;
                    case 93 -> 149;
                    case 94 -> 61;
                    case 95 -> 159;
                    case 96 -> 157;
                    case 97 -> 29;
                    case 98 -> 64;
                    case 99 -> 163;
                    case 100 -> 72;
                    case 101 -> 130;
                    case 102 -> 170;
                    case 103 -> 33;
                    case 104 -> 102;
                    case 105 -> 92;
                    case 106 -> 6;
                    case 107 -> 87;
                    case 108 -> 63;
                    case 109 -> 129;
                    case 110 -> 1;
                    case 111 -> 100;
                    case 112 -> 70;
                    case 113 -> 176;
                    case 114 -> 240;
                    case 115 -> 182;
                    case 116 -> 11;
                    case 117 -> 200;
                    case 118 -> 113;
                    case 119 -> 233;
                    case 120 -> 179;
                    case 121 -> 131;
                    case 122 -> 171;
                    case 123 -> 169;
                    case 124 -> 73;
                    case 125 -> 44;
                    case 126 -> 126;
                    case 127 -> 31;
                    case 128 -> 226;
                    case 129 -> 152;
                    case 130 -> 150;
                    case 131 -> 80;
                    case 132 -> 69;
                    case 133 -> 177;
                    case 134 -> 23;
                    case 135 -> 183;
                    case 136 -> 218;
                    case 137 -> 174;
                    case 138 -> 90;
                    case 139 -> 166;
                    case 140 -> 8;
                    case 141 -> 65;
                    case 142 -> 0;
                    case 143 -> 161;
                    case 144 -> 3;
                    case 145 -> 219;
                    case 146 -> 32;
                    case 147 -> 14;
                    case 148 -> 2;
                    case 149 -> 39;
                    case 150 -> 189;
                    case 151 -> 164;
                    case 152 -> 211;
                    case 153 -> 173;
                    case 154 -> 168;
                    case 155 -> 37;
                    case 156 -> 247;
                    case 157 -> 223;
                    case 158 -> 153;
                    case 159 -> 158;
                    case 160 -> 25;
                    case 161 -> 208;
                    case 162 -> 95;
                    case 163 -> 214;
                    case 164 -> 221;
                    case 165 -> 109;
                    case 166 -> 5;
                    case 167 -> 127;
                    case 168 -> 188;
                    case 169 -> 229;
                    case 170 -> 83;
                    case 171 -> 98;
                    case 172 -> 236;
                    case 173 -> 224;
                    case 174 -> 116;
                    case 175 -> 241;
                    case 176 -> 103;
                    case 177 -> 67;
                    case 178 -> 141;
                    case 179 -> 139;
                    case 180 -> 121;
                    case 181 -> 140;
                    case 182 -> 16;
                    case 183 -> 18;
                    case 184 -> 79;
                    case 185 -> 125;
                    case 186 -> 27;
                    case 187 -> 45;
                    case 188 -> 122;
                    case 189 -> 207;
                    case 190 -> 203;
                    case 191 -> 20;
                    case 192 -> 60;
                    case 193 -> 89;
                    case 194 -> 86;
                    case 195 -> 165;
                    case 196 -> 94;
                    case 197 -> 242;
                    case 198 -> 186;
                    case 199 -> 225;
                    case 200 -> 249;
                    case 201 -> 209;
                    case 202 -> 81;
                    case 203 -> 191;
                    case 204 -> 250;
                    case 205 -> 244;
                    case 206 -> 227;
                    case 207 -> 167;
                    case 208 -> 196;
                    case 209 -> 195;
                    case 210 -> 75;
                    case 211 -> 178;
                    case 212 -> 148;
                    case 213 -> 145;
                    case 214 -> 42;
                    case 215 -> 181;
                    case 216 -> 40;
                    case 217 -> 119;
                    case 218 -> 197;
                    case 219 -> 22;
                    case 220 -> 187;
                    case 221 -> 212;
                    case 222 -> 47;
                    case 223 -> 53;
                    case 224 -> 210;
                    case 225 -> 108;
                    case 226 -> 201;
                    case 227 -> 19;
                    case 228 -> 99;
                    case 229 -> 91;
                    case 230 -> 235;
                    case 231 -> 76;
                    case 232 -> 56;
                    case 233 -> 57;
                    case 234 -> 30;
                    case 235 -> 175;
                    case 236 -> 54;
                    case 237 -> 155;
                    case 238 -> 4;
                    case 239 -> 110;
                    case 240 -> 88;
                    case 241 -> 205;
                    case 242 -> 105;
                    case 243 -> 96;
                    case 244 -> 107;
                    case 245 -> 38;
                    case 246 -> 180;
                    case 247 -> 202;
                    case 248 -> 151;
                    case 249 -> 12;
                    case 250 -> 77;
                    case 251 -> 160;
                    case 252 -> 134;
                    case 253 -> 138;
                    case 254 -> 41;
                    default -> 232;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 96319655311184L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "jL\\\u0010s\u0019\u001c3\tmFO\u001a>[\u0001/\u0000";
                    var5_4 = "jL\\\u0010s\u0019\u001c3\tmFO\u001a>[\u0001/\u0000".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 42;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 43;
                                    break;
                                }
                                case 1: {
                                    v11 = 3;
                                    break;
                                }
                                case 2: {
                                    v11 = 4;
                                    break;
                                }
                                case 3: {
                                    v11 = 84;
                                    break;
                                }
                                case 4: {
                                    v11 = 60;
                                    break;
                                }
                                case 5: {
                                    v11 = 95;
                                    break;
                                }
                                default: {
                                    v11 = 5;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 101503684627152L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "8\u001d\u0012\u007f2\r9\u0004>\u0003\u001ee\n2\u001c\u0015e>\u000f!\u0018\u001d\u001c\t2\u001c\u0015e>\u000f!\u0014\u0017\r5\u001a\bh4\u0002;\u0014\u0010\u000fb5\u000b";
                    var5_4 = "8\u001d\u0012\u007f2\r9\u0004>\u0003\u001ee\n2\u001c\u0015e>\u000f!\u0018\u001d\u001c\t2\u001c\u0015e>\u000f!\u0014\u0017\r5\u001a\bh4\u0002;\u0014\u0010\u000fb5\u000b".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "+\u0006\ra+\u001b+\u0006+\u0006\ra'\u0011";
                        var5_4 = "+\u0006\ra+\u001b+\u0006+\u0006\ra'\u0011".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 120;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 16;
                                break;
                            }
                            case 1: {
                                v15 = 18;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 106;
                                break;
                            }
                            case 4: {
                                v15 = 58;
                                break;
                            }
                            case 5: {
                                v15 = 13;
                                break;
                            }
                            default: {
                                v15 = 52;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 124323225040389L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1101643350 + -((char)-23759), 1101643350 + 27699, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 27565912123691L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00f12tGr\u0003(\u00ac\u00fb\u0005\u00132\u000e\u0083\u00de\rlZ\u00d7\u00c4\u0010I\u00f7\n\u0092\u0089\u0093\u001a$\u0010\u00fd\u00bb\"\u0013\u0091&\u00ec\u00da8\u0017%\u0084\u0014\u009a%\u00a0\u0005\u00b8J{\u008cp3\u0096D\u00af:\u00f5GP\u00e2\u00d2\u00ed\u00f3\u00f2\b\u0005\u008aLe\u00f2\u00b0\u00b4;`u\u00ed\u00a8\u00ac&\u0007\u00f1\u00bc5?x\u00f5\u00aa\u0096\u00c93Ze\u00be{\u00f9\u00c1\u0018f\u0012\u00f4\u00d4\u00a1\u000f";
                    var4_3 = "\u00f12tGr\u0003(\u00ac\u00fb\u0005\u00132\u000e\u0083\u00de\rlZ\u00d7\u00c4\u0010I\u00f7\n\u0092\u0089\u0093\u001a$\u0010\u00fd\u00bb\"\u0013\u0091&\u00ec\u00da8\u0017%\u0084\u0014\u009a%\u00a0\u0005\u00b8J{\u008cp3\u0096D\u00af:\u00f5GP\u00e2\u00d2\u00ed\u00f3\u00f2\b\u0005\u008aLe\u00f2\u00b0\u00b4;`u\u00ed\u00a8\u00ac&\u0007\u00f1\u00bc5?x\u00f5\u00aa\u0096\u00c93Ze\u00be{\u00f9\u00c1\u0018f\u0012\u00f4\u00d4\u00a1\u000f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 17;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = ".w\u0089[5\u00fe\u00a9\u0010A\u009f\u00dbD\u001aS5HLZ\u0018\u00f0|0\u00d2g\u00fb\u0011q} \u00c0Q\u00fdq_U\u00d9g\u00af\u00af\u001cgw\u00c7)};kR{UB\u00af\u00ad\u008a[\u00d9\u00df)\u0000\u0015\u0002A\u0011#\u00f3\u00d1\u00a4\u0096\u00b8\u00a2!\u0090^\u007fg\u00c3\u009cRE\u00fd\u0084\u0002\u0087\u0016\u0080\u00c7\u00beK\\f\u00cf\u00f3\u00a3";
                        var4_3 = ".w\u0089[5\u00fe\u00a9\u0010A\u009f\u00dbD\u001aS5HLZ\u0018\u00f0|0\u00d2g\u00fb\u0011q} \u00c0Q\u00fdq_U\u00d9g\u00af\u00af\u001cgw\u00c7)};kR{UB\u00af\u00ad\u008a[\u00d9\u00df)\u0000\u0015\u0002A\u0011#\u00f3\u00d1\u00a4\u0096\u00b8\u00a2!\u0090^\u007fg\u00c3\u009cRE\u00fd\u0084\u0002\u0087\u0016\u0080\u00c7\u00beK\\f\u00cf\u00f3\u00a3".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 38;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 16;
                                break;
                            }
                            case 1: {
                                v15 = 37;
                                break;
                            }
                            case 2: {
                                v15 = 83;
                                break;
                            }
                            case 3: {
                                v15 = 115;
                                break;
                            }
                            case 4: {
                                v15 = 24;
                                break;
                            }
                            case 5: {
                                v15 = 10;
                                break;
                            }
                            default: {
                                v15 = 57;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE87C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 232;
                    case 1 -> 105;
                    case 2 -> 136;
                    case 3 -> 243;
                    case 4 -> 204;
                    case 5 -> 203;
                    case 6 -> 28;
                    case 7 -> 49;
                    case 8 -> 183;
                    case 9 -> 16;
                    case 10 -> 93;
                    case 11 -> 252;
                    case 12 -> 139;
                    case 13 -> 2;
                    case 14 -> 132;
                    case 15 -> 225;
                    case 16 -> 70;
                    case 17 -> 213;
                    case 18 -> 182;
                    case 19 -> 230;
                    case 20 -> 217;
                    case 21 -> 79;
                    case 22 -> 146;
                    case 23 -> 247;
                    case 24 -> 127;
                    case 25 -> 176;
                    case 26 -> 161;
                    case 27 -> 187;
                    case 28 -> 184;
                    case 29 -> 145;
                    case 30 -> 122;
                    case 31 -> 231;
                    case 32 -> 21;
                    case 33 -> 111;
                    case 34 -> 66;
                    case 35 -> 9;
                    case 36 -> 4;
                    case 37 -> 142;
                    case 38 -> 114;
                    case 39 -> 59;
                    case 40 -> 214;
                    case 41 -> 129;
                    case 42 -> 168;
                    case 43 -> 144;
                    case 44 -> 234;
                    case 45 -> 17;
                    case 46 -> 154;
                    case 47 -> 130;
                    case 48 -> 60;
                    case 49 -> 239;
                    case 50 -> 175;
                    case 51 -> 74;
                    case 52 -> 62;
                    case 53 -> 107;
                    case 54 -> 18;
                    case 55 -> 48;
                    case 56 -> 221;
                    case 57 -> 103;
                    case 58 -> 31;
                    case 59 -> 42;
                    case 60 -> 52;
                    case 61 -> 181;
                    case 62 -> 170;
                    case 63 -> 43;
                    case 64 -> 29;
                    case 65 -> 119;
                    case 66 -> 69;
                    case 67 -> 0;
                    case 68 -> 240;
                    case 69 -> 81;
                    case 70 -> 97;
                    case 71 -> 106;
                    case 72 -> 133;
                    case 73 -> 163;
                    case 74 -> 61;
                    case 75 -> 191;
                    case 76 -> 131;
                    case 77 -> 95;
                    case 78 -> 30;
                    case 79 -> 253;
                    case 80 -> 6;
                    case 81 -> 157;
                    case 82 -> 210;
                    case 83 -> 78;
                    case 84 -> 27;
                    case 85 -> 179;
                    case 86 -> 86;
                    case 87 -> 216;
                    case 88 -> 73;
                    case 89 -> 54;
                    case 90 -> 198;
                    case 91 -> 152;
                    case 92 -> 192;
                    case 93 -> 58;
                    case 94 -> 200;
                    case 95 -> 215;
                    case 96 -> 220;
                    case 97 -> 194;
                    case 98 -> 149;
                    case 99 -> 19;
                    case 100 -> 137;
                    case 101 -> 196;
                    case 102 -> 229;
                    case 103 -> 102;
                    case 104 -> 172;
                    case 105 -> 211;
                    case 106 -> 167;
                    case 107 -> 201;
                    case 108 -> 118;
                    case 109 -> 208;
                    case 110 -> 174;
                    case 111 -> 207;
                    case 112 -> 206;
                    case 113 -> 96;
                    case 114 -> 84;
                    case 115 -> 68;
                    case 116 -> 53;
                    case 117 -> 46;
                    case 118 -> 104;
                    case 119 -> 219;
                    case 120 -> 15;
                    case 121 -> 10;
                    case 122 -> 75;
                    case 123 -> 169;
                    case 124 -> 165;
                    case 125 -> 100;
                    case 126 -> 116;
                    case 127 -> 88;
                    case 128 -> 44;
                    case 129 -> 24;
                    case 130 -> 13;
                    case 131 -> 83;
                    case 132 -> 8;
                    case 133 -> 138;
                    case 134 -> 64;
                    case 135 -> 235;
                    case 136 -> 11;
                    case 137 -> 22;
                    case 138 -> 128;
                    case 139 -> 134;
                    case 140 -> 205;
                    case 141 -> 36;
                    case 142 -> 193;
                    case 143 -> 56;
                    case 144 -> 1;
                    case 145 -> 186;
                    case 146 -> 218;
                    case 147 -> 101;
                    case 148 -> 25;
                    case 149 -> 224;
                    case 150 -> 159;
                    case 151 -> 71;
                    case 152 -> 228;
                    case 153 -> 197;
                    case 154 -> 51;
                    case 155 -> 238;
                    case 156 -> 90;
                    case 157 -> 202;
                    case 158 -> 87;
                    case 159 -> 150;
                    case 160 -> 57;
                    case 161 -> 39;
                    case 162 -> 171;
                    case 163 -> 250;
                    case 164 -> 108;
                    case 165 -> 248;
                    case 166 -> 38;
                    case 167 -> 109;
                    case 168 -> 14;
                    case 169 -> 245;
                    case 170 -> 222;
                    case 171 -> 7;
                    case 172 -> 190;
                    case 173 -> 120;
                    case 174 -> 77;
                    case 175 -> 148;
                    case 176 -> 45;
                    case 177 -> 162;
                    case 178 -> 226;
                    case 179 -> 160;
                    case 180 -> 55;
                    case 181 -> 47;
                    case 182 -> 164;
                    case 183 -> 141;
                    case 184 -> 33;
                    case 185 -> 82;
                    case 186 -> 143;
                    case 187 -> 117;
                    case 188 -> 99;
                    case 189 -> 35;
                    case 190 -> 34;
                    case 191 -> 195;
                    case 192 -> 185;
                    case 193 -> 255;
                    case 194 -> 246;
                    case 195 -> 223;
                    case 196 -> 98;
                    case 197 -> 80;
                    case 198 -> 32;
                    case 199 -> 121;
                    case 200 -> 135;
                    case 201 -> 65;
                    case 202 -> 115;
                    case 203 -> 155;
                    case 204 -> 212;
                    case 205 -> 113;
                    case 206 -> 3;
                    case 207 -> 91;
                    case 208 -> 50;
                    case 209 -> 85;
                    case 210 -> 41;
                    case 211 -> 177;
                    case 212 -> 63;
                    case 213 -> 23;
                    case 214 -> 67;
                    case 215 -> 5;
                    case 216 -> 227;
                    case 217 -> 125;
                    case 218 -> 92;
                    case 219 -> 242;
                    case 220 -> 236;
                    case 221 -> 151;
                    case 222 -> 124;
                    case 223 -> 188;
                    case 224 -> 199;
                    case 225 -> 249;
                    case 226 -> 173;
                    case 227 -> 153;
                    case 228 -> 20;
                    case 229 -> 244;
                    case 230 -> 209;
                    case 231 -> 37;
                    case 232 -> 189;
                    case 233 -> 123;
                    case 234 -> 166;
                    case 235 -> 147;
                    case 236 -> 237;
                    case 237 -> 140;
                    case 238 -> 110;
                    case 239 -> 89;
                    case 240 -> 251;
                    case 241 -> 158;
                    case 242 -> 94;
                    case 243 -> 26;
                    case 244 -> 254;
                    case 245 -> 40;
                    case 246 -> 112;
                    case 247 -> 180;
                    case 248 -> 126;
                    case 249 -> 12;
                    case 250 -> 233;
                    case 251 -> 72;
                    case 252 -> 178;
                    case 253 -> 156;
                    case 254 -> 241;
                    default -> 76;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 13707361400558L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2120712600 + -((char)-9114), -2120712600 + -((char)-11908), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 86834799691385L;
                    boolean bl = SshAgentIpcService.Z();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(849071460 + (char)-31440, -849071460 + -((char)-27043), (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 23213981290734L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00cbU\u00ec\u0080x\u0003 \u00ed\u00c7";
                var4_3 = "\u00cbU\u00ec\u0080x\u0003 \u00ed\u00c7".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 5;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 59;
                                break;
                            }
                            case 1: {
                                v11 = 27;
                                break;
                            }
                            case 2: {
                                v11 = 127;
                                break;
                            }
                            case 3: {
                                v11 = 9;
                                break;
                            }
                            case 4: {
                                v11 = 18;
                                break;
                            }
                            case 5: {
                                v11 = 75;
                                break;
                            }
                            default: {
                                v11 = 77;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF94EC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 236;
                    case 1 -> 134;
                    case 2 -> 8;
                    case 3 -> 144;
                    case 4 -> 21;
                    case 5 -> 226;
                    case 6 -> 180;
                    case 7 -> 61;
                    case 8 -> 213;
                    case 9 -> 131;
                    case 10 -> 30;
                    case 11 -> 234;
                    case 12 -> 38;
                    case 13 -> 207;
                    case 14 -> 84;
                    case 15 -> 19;
                    case 16 -> 227;
                    case 17 -> 132;
                    case 18 -> 170;
                    case 19 -> 104;
                    case 20 -> 59;
                    case 21 -> 192;
                    case 22 -> 27;
                    case 23 -> 212;
                    case 24 -> 140;
                    case 25 -> 60;
                    case 26 -> 208;
                    case 27 -> 253;
                    case 28 -> 14;
                    case 29 -> 73;
                    case 30 -> 217;
                    case 31 -> 191;
                    case 32 -> 76;
                    case 33 -> 111;
                    case 34 -> 78;
                    case 35 -> 238;
                    case 36 -> 96;
                    case 37 -> 3;
                    case 38 -> 98;
                    case 39 -> 178;
                    case 40 -> 200;
                    case 41 -> 251;
                    case 42 -> 93;
                    case 43 -> 138;
                    case 44 -> 189;
                    case 45 -> 58;
                    case 46 -> 124;
                    case 47 -> 6;
                    case 48 -> 109;
                    case 49 -> 165;
                    case 50 -> 184;
                    case 51 -> 68;
                    case 52 -> 5;
                    case 53 -> 201;
                    case 54 -> 171;
                    case 55 -> 33;
                    case 56 -> 249;
                    case 57 -> 1;
                    case 58 -> 204;
                    case 59 -> 162;
                    case 60 -> 232;
                    case 61 -> 122;
                    case 62 -> 175;
                    case 63 -> 128;
                    case 64 -> 22;
                    case 65 -> 167;
                    case 66 -> 20;
                    case 67 -> 88;
                    case 68 -> 99;
                    case 69 -> 62;
                    case 70 -> 108;
                    case 71 -> 43;
                    case 72 -> 244;
                    case 73 -> 135;
                    case 74 -> 82;
                    case 75 -> 10;
                    case 76 -> 7;
                    case 77 -> 9;
                    case 78 -> 146;
                    case 79 -> 197;
                    case 80 -> 143;
                    case 81 -> 160;
                    case 82 -> 64;
                    case 83 -> 233;
                    case 84 -> 148;
                    case 85 -> 85;
                    case 86 -> 95;
                    case 87 -> 153;
                    case 88 -> 46;
                    case 89 -> 243;
                    case 90 -> 129;
                    case 91 -> 216;
                    case 92 -> 18;
                    case 93 -> 44;
                    case 94 -> 83;
                    case 95 -> 254;
                    case 96 -> 101;
                    case 97 -> 74;
                    case 98 -> 161;
                    case 99 -> 190;
                    case 100 -> 214;
                    case 101 -> 187;
                    case 102 -> 172;
                    case 103 -> 245;
                    case 104 -> 176;
                    case 105 -> 79;
                    case 106 -> 255;
                    case 107 -> 247;
                    case 108 -> 155;
                    case 109 -> 120;
                    case 110 -> 142;
                    case 111 -> 133;
                    case 112 -> 224;
                    case 113 -> 119;
                    case 114 -> 49;
                    case 115 -> 181;
                    case 116 -> 150;
                    case 117 -> 92;
                    case 118 -> 159;
                    case 119 -> 229;
                    case 120 -> 37;
                    case 121 -> 48;
                    case 122 -> 125;
                    case 123 -> 105;
                    case 124 -> 39;
                    case 125 -> 23;
                    case 126 -> 41;
                    case 127 -> 218;
                    case 128 -> 52;
                    case 129 -> 198;
                    case 130 -> 116;
                    case 131 -> 69;
                    case 132 -> 154;
                    case 133 -> 185;
                    case 134 -> 145;
                    case 135 -> 102;
                    case 136 -> 34;
                    case 137 -> 81;
                    case 138 -> 115;
                    case 139 -> 86;
                    case 140 -> 123;
                    case 141 -> 70;
                    case 142 -> 45;
                    case 143 -> 173;
                    case 144 -> 55;
                    case 145 -> 97;
                    case 146 -> 118;
                    case 147 -> 121;
                    case 148 -> 246;
                    case 149 -> 223;
                    case 150 -> 57;
                    case 151 -> 127;
                    case 152 -> 16;
                    case 153 -> 240;
                    case 154 -> 193;
                    case 155 -> 222;
                    case 156 -> 250;
                    case 157 -> 100;
                    case 158 -> 87;
                    case 159 -> 174;
                    case 160 -> 72;
                    case 161 -> 42;
                    case 162 -> 177;
                    case 163 -> 194;
                    case 164 -> 32;
                    case 165 -> 63;
                    case 166 -> 139;
                    case 167 -> 241;
                    case 168 -> 195;
                    case 169 -> 205;
                    case 170 -> 126;
                    case 171 -> 67;
                    case 172 -> 166;
                    case 173 -> 215;
                    case 174 -> 4;
                    case 175 -> 242;
                    case 176 -> 65;
                    case 177 -> 0;
                    case 178 -> 113;
                    case 179 -> 89;
                    case 180 -> 103;
                    case 181 -> 47;
                    case 182 -> 202;
                    case 183 -> 117;
                    case 184 -> 182;
                    case 185 -> 252;
                    case 186 -> 91;
                    case 187 -> 130;
                    case 188 -> 75;
                    case 189 -> 168;
                    case 190 -> 221;
                    case 191 -> 219;
                    case 192 -> 211;
                    case 193 -> 94;
                    case 194 -> 36;
                    case 195 -> 188;
                    case 196 -> 199;
                    case 197 -> 11;
                    case 198 -> 2;
                    case 199 -> 56;
                    case 200 -> 186;
                    case 201 -> 136;
                    case 202 -> 149;
                    case 203 -> 203;
                    case 204 -> 54;
                    case 205 -> 206;
                    case 206 -> 209;
                    case 207 -> 158;
                    case 208 -> 107;
                    case 209 -> 106;
                    case 210 -> 152;
                    case 211 -> 183;
                    case 212 -> 90;
                    case 213 -> 77;
                    case 214 -> 237;
                    case 215 -> 225;
                    case 216 -> 141;
                    case 217 -> 164;
                    case 218 -> 235;
                    case 219 -> 231;
                    case 220 -> 248;
                    case 221 -> 13;
                    case 222 -> 25;
                    case 223 -> 24;
                    case 224 -> 169;
                    case 225 -> 230;
                    case 226 -> 50;
                    case 227 -> 51;
                    case 228 -> 40;
                    case 229 -> 12;
                    case 230 -> 151;
                    case 231 -> 112;
                    case 232 -> 66;
                    case 233 -> 15;
                    case 234 -> 17;
                    case 235 -> 114;
                    case 236 -> 28;
                    case 237 -> 71;
                    case 238 -> 157;
                    case 239 -> 80;
                    case 240 -> 29;
                    case 241 -> 163;
                    case 242 -> 210;
                    case 243 -> 179;
                    case 244 -> 239;
                    case 245 -> 110;
                    case 246 -> 228;
                    case 247 -> 156;
                    case 248 -> 137;
                    case 249 -> 196;
                    case 250 -> 53;
                    case 251 -> 35;
                    case 252 -> 26;
                    case 253 -> 147;
                    case 254 -> 220;
                    default -> 31;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

