/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.DynamicBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantBoxManager;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantItemListPanel;
import com.jetbrains.plugins.vagrant.VagrantItemsModel;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantPlugin;
import com.jetbrains.plugins.vagrant.VagrantPluginManager;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.VagrantProviders;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.vagrant";
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myVagrantPathField;
    private TextFieldWithBrowseButton myInstanceFolderField;
    private JPanel myBoxesPanel;
    private JPanel myPluginsPanel;
    private JBLabel myErrorLabel;
    private JPanel myProviderPanel;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvsEditor;
    private JButton myTestExecutableButton;
    private final VagrantBoxManager myBoxManager;
    private final VagrantPluginManager myPluginManager;
    private ComboBox<String> myProviderField;

    public VagrantConfigurable(@NotNull Project project) {
        if (project == null) {
            VagrantConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myBoxManager = new VagrantBoxManager(project);
        this.myPluginManager = new VagrantPluginManager(project);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            VagrantConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.VagrantConfigurable.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        FileChooserDescriptor fileDescriptor = new FileChooserDescriptor(true, false, false, false, false, false).withTitle(VagrantBundle.message("vagrant.select.executable", new Object[0]));
        this.myVagrantPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener((ComponentWithBrowseButton)this.myVagrantPathField, null, fileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        FileChooserDescriptor folderDescriptor = new FileChooserDescriptor(false, true, false, false, false, false).withTitle(VagrantBundle.message("vagrant.select.env.folder", new Object[0]));
        this.myInstanceFolderField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener((ComponentWithBrowseButton)this.myInstanceFolderField, null, folderDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myBoxesPanel.setLayout(new BorderLayout());
        this.myBoxesPanel.add((Component)((Object)new VagrantBoxPanel(this.myProject, this.myBoxManager)), "Center");
        this.myPluginsPanel.setLayout(new BorderLayout());
        this.myPluginsPanel.add((Component)((Object)new VagrantPluginsPanel(this.myProject, this.myPluginManager)), "Center");
        this.myVagrantPathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }
        });
        UIUtil.setEnabled((Component)this.myBoxesPanel, (boolean)false, (boolean)true);
        UIUtil.setEnabled((Component)this.myPluginsPanel, (boolean)false, (boolean)true);
        this.myTestExecutableButton.addActionListener(e -> this.testVagrantExecutable());
        this.myProviderPanel.setLayout(new BorderLayout());
        this.myProviderField = this.createProviderCombo();
        this.myProviderField.setToolTipText(VagrantBundle.message("vagrant.provider.tooltip", new Object[0]));
        this.myProviderPanel.add((Component)this.myProviderField, "Center");
        return this.myMainPanel;
    }

    @NotNull
    private List<String> providersList() {
        List plugins = this.myPluginManager.listItems();
        ArrayList<String> result = new ArrayList<String>(List.of(""));
        if (plugins != null) {
            Function f = input -> VagrantProviders.providerForPlugin(input.getName());
            result.addAll(ContainerUtil.mapNotNull(plugins, (Function)f));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            VagrantConfigurable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private ComboBox<String> createProviderCombo() {
        final ArrayList providers = new ArrayList();
        ComboBox combo = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel(providers));
        combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                providers.clear();
                providers.addAll(VagrantConfigurable.this.providersList());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        combo.setEditable(true);
        combo.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JBTextField editor = new JBTextField();
                editor.getEmptyText().setText(VagrantBundle.message("vagrant.provider.combobox.default", new Object[0]));
                editor.setBorder(null);
                return editor;
            }
        });
        ComboBox comboBox = combo;
        if (comboBox == null) {
            VagrantConfigurable.$$$reportNull$$$0(3);
        }
        return comboBox;
    }

    private void vagrantPathUpdated() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.clearError();
            this.myBoxManager.reset();
            this.myPluginManager.reset();
            UIUtil.setEnabled((Component)this.myBoxesPanel, (boolean)false, (boolean)true);
            UIUtil.setEnabled((Component)this.myPluginsPanel, (boolean)false, (boolean)true);
        });
    }

    private void testVagrantExecutable() {
        this.myBoxManager.setVagrantPath(this.myVagrantPathField.getText());
        this.myPluginManager.setVagrantPath(this.myVagrantPathField.getText());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List boxes = this.myBoxManager.listItems();
            List plugins = this.myPluginManager.listItems();
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (boxes == null) {
                    this.showError(VagrantBundle.message("vagrant.error.cannot.run.vagrant.executable", new Object[0]));
                } else {
                    this.clearError();
                }
                UIUtil.setEnabled((Component)this.myBoxesPanel, (boxes != null ? 1 : 0) != 0, (boolean)true);
                UIUtil.setEnabled((Component)this.myPluginsPanel, (plugins != null ? 1 : 0) != 0, (boolean)true);
            });
        });
    }

    private void showError(@NlsContexts.Label String s) {
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText(s);
    }

    private void clearError() {
        this.myErrorLabel.setVisible(false);
    }

    public boolean isModified() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        return !this.getVagrantPath().equals(vagrantSettings.getVagrantExecutable()) || !VagrantConfigurable.equalsNullize(this.getInstanceFolder(), vagrantProjectSettings.getInstanceFolder()) || !VagrantConfigurable.equalsNullize(this.getProvider(), vagrantProjectSettings.getProvider()) || !this.myEnvsEditor.getEnvs().equals(vagrantProjectSettings.getEnvs());
    }

    @NotNull
    private String getVagrantPath() {
        String string = this.myVagrantPathField.getText();
        if (string == null) {
            VagrantConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void apply() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        vagrantSettings.setVagrantExecutable(this.getVagrantPath());
        vagrantProjectSettings.setInstanceFolder(this.getInstanceFolder());
        vagrantProjectSettings.setProvider(this.getProvider());
        vagrantProjectSettings.setEnvs(new HashMap<String, String>(this.myEnvsEditor.getEnvs()));
    }

    @NotNull
    private String getInstanceFolder() {
        String string = this.myInstanceFolderField.getText();
        if (string == null) {
            VagrantConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void reset() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        String vagrantPath = vagrantSettings.getVagrantExecutable();
        this.setVagrantPath(vagrantPath);
        String instanceFolder = vagrantProjectSettings.getInstanceFolder();
        this.setInstanceFolder(instanceFolder);
        String provider = vagrantProjectSettings.getProvider();
        this.setProvider(provider);
        this.myEnvsEditor.setEnvs(new HashMap<String, String>(vagrantProjectSettings.getEnvs()));
        if (StringUtil.isEmpty((String)vagrantPath)) {
            vagrantPath = VagrantService.getInstance().detectVagrantExecutable();
            this.setVagrantPath(vagrantPath);
        }
        if (StringUtil.isEmpty((String)instanceFolder) && (instanceFolder = VagrantManager.getInstance(this.myProject).detectInstanceInCurrentProject()) != null) {
            this.setInstanceFolder(instanceFolder);
        }
    }

    private void setVagrantPath(String valueToUse) {
        this.myVagrantPathField.setText(valueToUse);
    }

    @NotNull
    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void setInstanceFolder(String instanceFolder) {
        this.myInstanceFolderField.setText(instanceFolder);
    }

    public void setProvider(@NlsSafe String provider) {
        this.myProviderField.getEditor().setItem(provider);
    }

    @Nullable
    public String getProvider() {
        return (String)this.myProviderField.getEditor().getItem();
    }

    private static boolean equalsNullize(@Nullable String s1, @Nullable String s2) {
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)s1), (CharSequence)StringUtil.nullize((String)s2));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JButton jButton;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 6, 3, new Dimension(400, -1), null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.executable"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.instance.folder"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVagrantPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setToolTipText(DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.executable.tooltip"));
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myInstanceFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.instance.folder.tooltip"));
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.provider"));
        jPanel5.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProviderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setToolTipText("");
        jPanel5.add((Component)jPanel3, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.env.vars"));
        jPanel5.add((Component)jBLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvsEditor = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        environmentVariablesTextFieldWithBrowseButton.setPassParentEnvs(false);
        jPanel5.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(3, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myTestExecutableButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.test.executable"));
        jPanel5.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setForeground(Color.red);
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel4.add((Component)jTabbedPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myBoxesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.tab.boxes"), null, jPanel2, null);
        this.myPluginsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/VagrantBundle", VagrantConfigurable.class).getString("vagrant.settings.tab.plugins"), null, jPanel, null);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "providersList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProviderCombo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class VagrantBoxPanel
    extends VagrantItemListPanel<VagrantBox> {
        VagrantBoxPanel(@NotNull Project project, @NotNull VagrantItemsModel<VagrantBox> model) {
            if (project == null) {
                VagrantBoxPanel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                VagrantBoxPanel.$$$reportNull$$$0(1);
            }
            super(project, model);
            this.initPanel();
        }

        @Override
        protected String deleteConfirmationTitle() {
            return VagrantBundle.message("vagrant.box.delete.title", new Object[0]);
        }

        @Override
        protected String deleteConfirmation(VagrantBox item) {
            return VagrantBundle.message("vagrant.box.delete.text", item.getName());
        }

        @Override
        protected String secondColumn() {
            return VagrantBundle.message("vagrant.box.type", new Object[0]);
        }

        @Override
        protected String firstColumn() {
            return VagrantBundle.message("vagrant.box.name", new Object[0]);
        }

        @Override
        @NotNull
        @Nls
        protected String uninitializedListText() {
            String string = VagrantBundle.message("vagrant.box.uninitialized.list", new Object[0]);
            if (string == null) {
                VagrantBoxPanel.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected String emptyListText() {
            return VagrantBundle.message("vagrant.box.empty.list", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantBoxPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantBoxPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uninitializedListText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class VagrantPluginsPanel
    extends VagrantItemListPanel<VagrantPlugin> {
        private final VagrantPluginManager myPluginManager;

        VagrantPluginsPanel(@NotNull Project project, @NotNull VagrantPluginManager model) {
            if (project == null) {
                VagrantPluginsPanel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                VagrantPluginsPanel.$$$reportNull$$$0(1);
            }
            super(project, model);
            this.myPluginManager = model;
            this.initPanel();
        }

        @Override
        protected String deleteConfirmationTitle() {
            return VagrantBundle.message("vagrant.plugins.delete.title", new Object[0]);
        }

        @Override
        protected String deleteConfirmation(VagrantPlugin plugin) {
            return VagrantBundle.message("vagrant.plugins.delete.text", plugin.getName());
        }

        @Override
        protected String firstColumn() {
            return VagrantBundle.message("vagrant.plugins.name", new Object[0]);
        }

        @Override
        protected String secondColumn() {
            return VagrantBundle.message("vagrant.plugins.version", new Object[0]);
        }

        @Override
        @NotNull
        @Nls
        protected String uninitializedListText() {
            String string = VagrantBundle.message("vagrant.plugins.uninitialized.list", new Object[0]);
            if (string == null) {
                VagrantPluginsPanel.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected String emptyListText() {
            return VagrantBundle.message("vagrant.plugins.empty", new Object[0]);
        }

        @Override
        protected ToolbarDecorator createToolbarDecorator() {
            return super.createToolbarDecorator().addExtraAction((AnAction)new UpdateAction()).addExtraAction((AnAction)new AddLicenseAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uninitializedListText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private final class UpdateAction
        extends DumbAwareAction {
            UpdateAction() {
                super(VagrantBundle.message("vagrant.action.update", new Object[0]), null, AllIcons.Javaee.UpdateRunningApplication);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    UpdateAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(VagrantPluginsPanel.this.getSelectedItem() != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VagrantPlugin plugin;
                if (e == null) {
                    UpdateAction.$$$reportNull$$$0(1);
                }
                if ((plugin = (VagrantPlugin)VagrantPluginsPanel.this.getSelectedItem()) != null) {
                    VagrantPluginsPanel.this.myPluginManager.update(plugin);
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    UpdateAction.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$UpdateAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$UpdateAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private final class AddLicenseAction
        extends DumbAwareAction {
            AddLicenseAction() {
                super(VagrantBundle.message("vagrant.attach.license", new Object[0]), null, AllIcons.Actions.Annotate);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    AddLicenseAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(VagrantPluginsPanel.this.getSelectedItem() != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VagrantPlugin plugin;
                if (e == null) {
                    AddLicenseAction.$$$reportNull$$$0(1);
                }
                if ((plugin = (VagrantPlugin)VagrantPluginsPanel.this.getSelectedItem()) != null) {
                    VagrantPluginsPanel.this.myPluginManager.attachLicense(plugin);
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    AddLicenseAction.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$AddLicenseAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$AddLicenseAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

