/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.php.frontend.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.php.frontend.lang.psi.elements.impl.FrontendPhpExpression;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/php/frontend/lang/psi/elements/impl/FrontendStringLiteralExpression;", "Lcom/intellij/php/frontend/lang/psi/elements/impl/FrontendPhpExpression;", "Lcom/jetbrains/php/lang/psi/elements/StringLiteralExpression;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "accept", "", "phpElementVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "getContents", "", "isHeredoc", "", "isSingleQuote", "isValidHost", "updateText", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "text", "getValueRange", "Lcom/intellij/openapi/util/TextRange;", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Companion", "intellij.php.frontend"})
public final class FrontendStringLiteralExpression
extends FrontendPhpExpression
implements StringLiteralExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public FrontendStringLiteralExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        Intrinsics.checkNotNullParameter((Object)phpElementVisitor, (String)"phpElementVisitor");
        phpElementVisitor.visitPhpStringLiteralExpression((StringLiteralExpression)this);
    }

    @NotNull
    public String getContents() {
        return "";
    }

    public boolean isHeredoc() {
        return this.getNode().getElementType() == PhpElementTypes.HEREDOC;
    }

    public boolean isSingleQuote() {
        IElementType iElementType = this.getFirstChild().getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType firstType = iElementType;
        return firstType == PhpTokenTypes.chLSINGLE_QUOTE || firstType == PhpTokenTypes.HEREDOC_START && this.getFirstChild().textToCharArray()[3] == '\'';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidHost() {
        int length = this.getTextLength();
        if (this.isHeredoc()) {
            if (length <= 7) return false;
            return true;
        }
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        ASTNode node = aSTNode;
        if (node.getElementType() == PhpDocElementTypes.phpDocString) {
            CharSequence charSequence = node.getChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
            CharSequence text = charSequence;
            if (length < 2) return false;
            if (!StringUtil.startsWithChar((CharSequence)text, (char)'\"')) return false;
            if (!StringUtil.endsWithChar((CharSequence)text, (char)'\"')) return false;
            return true;
        }
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode[] children = aSTNodeArray;
        if (children.length < 2) return false;
        ASTNode aSTNode2 = children[0];
        Intrinsics.checkNotNull((Object)aSTNode2);
        if (!PhpTokenTypes.tsSTRING_EDGE.contains(aSTNode2.getElementType())) return false;
        ASTNode aSTNode3 = children[children.length - 1];
        Intrinsics.checkNotNull((Object)aSTNode3);
        if (!PhpTokenTypes.tsSTRING_EDGE.contains(aSTNode3.getElementType())) return false;
        return true;
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object text2 = text;
        if (this.isHeredoc()) {
            if (!StringsKt.startsWith$default((String)text2, (String)"<<<", (boolean)false, (int)2, null)) {
                text2 = "echo <<<" + this.getName() + "\n" + (String)text2 + "\n" + this.getName() + ";\n";
            } else if (!StringsKt.endsWith$default((String)text2, (String)"\n", (boolean)false, (int)2, null)) {
                text2 = (String)text2 + "\n";
            }
        } else {
            String string = StringUtil.unquoteString((String)text2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
            text2 = string;
            char q = this.getNode().getChars().charAt(0);
            CharSequence charSequence = (CharSequence)text2;
            Regex regex = new Regex(String.valueOf(q));
            String string2 = "\\\\" + q;
            text2 = regex.replace(charSequence, string2);
            text2 = q + (String)text2 + q;
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        StringLiteralExpression newExpr = Companion.createFirstFromText(project, StringLiteralExpression.class, (String)text2);
        this.replace((PsiElement)newExpr);
        return (PsiLanguageInjectionHost)newExpr;
    }

    @NotNull
    public TextRange getValueRange() {
        if (!this.isHeredoc()) {
            return new TextRange(1, Math.max(1, this.getTextLength() - 1));
        }
        int s = this.getFirstChild().getTextLength();
        PsiElement end = this.findChildByType(PhpTokenTypes.HEREDOC_END);
        int e = end != null ? this.getTextLength() - end.getTextLength() : this.getTextLength();
        return new TextRange(s, e);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        throw new UnsupportedOperationException("Unsupported for StringLiteralExpressionImplBasic");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J5\u0010\n\u001a\u0002H\u000b\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/php/frontend/lang/psi/elements/impl/FrontendStringLiteralExpression$Companion;", "", "<init>", "()V", "createDummyFile", "Lcom/intellij/psi/PsiFile;", "p", "Lcom/intellij/openapi/project/Project;", "fileText", "", "createFirstFromText", "T", "Lcom/intellij/psi/PsiElement;", "aClass", "Ljava/lang/Class;", "text", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Class;Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "intellij.php.frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiFile createDummyFile(Project p, String fileText) {
            PsiFile psiFile = PsiFileFactory.getInstance((Project)p).createFileFromText("DUMMY__." + PhpFileType.INSTANCE.getDefaultExtension(), (FileType)PhpFileType.INSTANCE, (CharSequence)("<?php\n" + fileText), System.currentTimeMillis(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
            return psiFile;
        }

        public final <T extends PsiElement> T createFirstFromText(@NotNull Project p, @NotNull Class<T> aClass, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List ret = new ArrayList();
            this.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(aClass, ret){
                final /* synthetic */ Class<T> $aClass;
                final /* synthetic */ List<PsiElement> $ret;
                {
                    this.$aClass = $aClass;
                    this.$ret = $ret;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (this.$aClass.isInstance(element)) {
                        this.$ret.set(0, element);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return (T)((PsiElement)ret.get(0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

