/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.runAnything;

import com.intellij.ide.actions.runAnything.items.RunAnythingItemBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.parsing.UserInputPart;
import com.jetbrains.php.framework.runAnything.FrameworkRunAnythingProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkRunAnythingItem
extends RunAnythingItemBase {
    private final Project myProject;
    private static final int COMMAND_LENGTH = 60;
    private static final int DESCRIPTION_LENGTH = 60;

    public FrameworkRunAnythingItem(@NotNull Project project, @NotNull String command, @Nullable Icon icon) {
        if (project == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(0);
        }
        if (command == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(1);
        }
        super(command, icon);
        this.myProject = project;
    }

    @NotNull
    public Component createComponent(@Nullable String pattern, boolean isSelected, boolean hasFocus) {
        JPanel panel = (JPanel)super.createComponent(pattern, isSelected, hasFocus);
        String commandPattern = this.getCommand();
        FrameworkCommand command = FrameworkCurrentInputData.countInputData(commandPattern, FrameworkDataService.getInstance(this.myProject).getCommands()).findCommand(true, true);
        StringBuilder description = new StringBuilder();
        if (command != null && commandPattern.startsWith(command.getAliasedBasicText())) {
            List<UserInputPart> userInputParts = FrameworkUtils.parseCurrentInput(commandPattern, command);
            UserInputPart lastPart = userInputParts.get(userInputParts.size() - 1);
            FrameworkRunAnythingItem.appendOptionDescription(command, lastPart, description);
            if (description.isEmpty()) {
                FrameworkRunAnythingItem.appendParamDescription(command, lastPart, description, commandPattern);
            }
        }
        SimpleColoredComponent commandComponent = FrameworkRunAnythingItem.replaceCommandComponent(this.myProject, panel, commandPattern, pattern, isSelected);
        if (!description.isEmpty()) {
            @NlsSafe String parametersDescription = StringUtil.shortenTextWithEllipsis((String)description.toString(), (int)60, (int)0);
            commandComponent.append(parametersDescription, SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private static SimpleColoredComponent replaceCommandComponent(@NotNull Project project, @NotNull JPanel panel, @NlsContexts.Label @NotNull String commandPattern, @Nullable String pattern, boolean isSelected) {
        if (project == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(3);
        }
        if (panel == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(4);
        }
        if (commandPattern == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(5);
        }
        SimpleColoredComponent commandComponent = new SimpleColoredComponent();
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)StringUtil.trimMiddle((String)commandPattern, (int)60), (SimpleColoredComponent)commandComponent, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)FrameworkRunAnythingProvider.getMatcher(project, pattern), (Color)UIUtil.getListBackground((boolean)isSelected, (boolean)true), (boolean)isSelected);
        Component oldCommandComponent = ((BorderLayout)panel.getLayout()).getLayoutComponent("West");
        if (oldCommandComponent != null) {
            panel.remove(oldCommandComponent);
        }
        panel.add((Component)commandComponent, "West");
        SimpleColoredComponent simpleColoredComponent = commandComponent;
        if (simpleColoredComponent == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(6);
        }
        return simpleColoredComponent;
    }

    private static void appendOptionDescription(@NotNull FrameworkCommand command, @NotNull UserInputPart lastPart, @NotNull StringBuilder description) {
        if (command == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(7);
        }
        if (lastPart == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(8);
        }
        if (description == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(9);
        }
        String lastPartText = lastPart.getText();
        if (!lastPart.getText().isEmpty() && FrameworkRunAnythingProvider.isValidToCompleteOptionPart(command, lastPart)) {
            StreamEx.of(command.getOptionsBeforeParams()).findFirst(option -> lastPartText.equals(option.getName()) || lastPartText.equals(option.getShortcut())).map(FrameworkRunAnythingItem::getHelpWithOffset).ifPresent(description::append);
        }
    }

    @Nullable
    private static String getHelpWithOffset(@NotNull FrameworkOption option) {
        if (option == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(10);
        }
        String help = option.getHelp();
        return option.getValuePattern() != null || StringUtil.isEmpty((String)help) ? help : " " + help;
    }

    private static void appendParamDescription(@NotNull FrameworkCommand command, @NotNull UserInputPart lastPart, @NotNull StringBuilder description, @NotNull String commandPattern) {
        int currentParameterNumber;
        if (command == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(11);
        }
        if (lastPart == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(12);
        }
        if (description == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(13);
        }
        if (commandPattern == null) {
            FrameworkRunAnythingItem.$$$reportNull$$$0(14);
        }
        if ((currentParameterNumber = FrameworkRunAnythingProvider.getParamNumber(lastPart)) < command.getParameters().size()) {
            String paramsDescription = FrameworkUtils.getParamsDescription(command, false, currentParameterNumber);
            description.append(StringUtil.endsWithChar((CharSequence)commandPattern, (char)' ') ? StringUtil.trimStart((String)paramsDescription, (String)" ") : paramsDescription);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandPattern";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPart";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCommandComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceCommandComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHelpWithOffset";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendParamDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

