/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameworkCommandExecutionUsageCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("php.command.line.tools.events", 2);
    static final EnumEventField<ToolType> TOOL_TYPE = EventFields.Enum((String)"toolType", ToolType.class);
    static final EventId1<ToolType> COMMAND_EXECUTED = GROUP.registerEvent("command.executed", TOOL_TYPE);

    public static void logInvocation(@NotNull Project project, @Nullable FrameworkCommand command) {
        if (project == null) {
            FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(0);
        }
        COMMAND_EXECUTED.log(project, (Object)FrameworkCommandExecutionUsageCollector.getToolType(command));
    }

    @NotNull
    private static ToolType getToolType(@Nullable FrameworkCommand command) {
        if (command == null) {
            ToolType toolType = ToolType.unconfigured;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(1);
            }
            return toolType;
        }
        FrameworkDescription description = command.getFrameworkDescription();
        String frameworkId = description.getFrameworkId();
        if (frameworkId == null) {
            ToolType toolType = ToolType.custom;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(2);
            }
            return toolType;
        }
        if ("com.zend.framework".equals(frameworkId)) {
            ToolType toolType = ToolType.zend1;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(3);
            }
            return toolType;
        }
        if ("com.zend.framework2".equals(frameworkId)) {
            ToolType toolType = ToolType.zend2;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(4);
            }
            return toolType;
        }
        if ("com.symfony".equals(frameworkId)) {
            ToolType toolType = ToolType.symfony;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(5);
            }
            return toolType;
        }
        if ("org.getcomposer".equals(frameworkId)) {
            ToolType toolType = ToolType.composer;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(6);
            }
            return toolType;
        }
        if ("com.symfony.component".equals(frameworkId)) {
            ToolType toolType = ToolType.symfonyBasedTool;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(7);
            }
            return toolType;
        }
        if ("ws.drush".equals(frameworkId)) {
            ToolType toolType = ToolType.drush;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(8);
            }
            return toolType;
        }
        if ("org.wp-cli".equals(frameworkId)) {
            ToolType toolType = ToolType.wordPress;
            if (toolType == null) {
                FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(9);
            }
            return toolType;
        }
        ToolType toolType = ToolType.unknown;
        if (toolType == null) {
            FrameworkCommandExecutionUsageCollector.$$$reportNull$$$0(10);
        }
        return toolType;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkCommandExecutionUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkCommandExecutionUsageCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logInvocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static enum ToolType {
        unconfigured,
        custom,
        zend1,
        zend2,
        symfony,
        composer,
        symfonyBasedTool,
        drush,
        wordPress,
        unknown;

    }
}

