/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.wordpress.WPUtil;
import com.jetbrains.php.wordpress.hooks.WPHookCallbacksIndex;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import com.jetbrains.php.wordpress.init.WPContentConfigurationManager;
import com.jetbrains.php.wordpress.init.WPFormattingManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WordPressConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class WPDataService
implements PersistentStateComponent<State>,
Disposable {
    private static final String WP_PATH_PROPERTY = "wordPress.support.wordPressPath";
    @NotNull
    private final Project myProject;
    private boolean isEnabled;
    private String myWPPath;
    private boolean myDoNotAskAgain;
    private boolean myDoNotAskContentConfigurationAgain;

    public static WPDataService getInstance(Project project) {
        return (WPDataService)project.getService(WPDataService.class);
    }

    public WPDataService(@NotNull Project project) {
        if (project == null) {
            WPDataService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void setState(State state) {
        State oldState = this.getState();
        this.loadState(state);
        this.notifyListeners(state, oldState);
    }

    @NlsSafe
    public String getWPPath() {
        return this.myWPPath;
    }

    @Nullable
    public static String getLastWPPath() {
        return PropertiesComponent.getInstance().getValue(WP_PATH_PROPERTY);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    public void setDoNotAskAgain(boolean doNotAsk) {
        this.myDoNotAskAgain = doNotAsk;
    }

    private void notifyListeners(State newState, State oldState) {
        if (newState.equals(oldState)) {
            return;
        }
        WPContentConfigurationManager.getInstance().refreshIncludePaths(newState, this.myProject);
        WPUtil.reindexIfNeeded(WPHooksIndex.KEY, newState, oldState);
        WPUtil.reindexIfNeeded(WPHookCallbacksIndex.KEY, newState, oldState);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            WPFormattingManager.offerWPFormatting(newState, oldState, this.myProject);
        }
    }

    @NotNull
    public State getState() {
        return new State(this.isEnabled, this.myWPPath, this.myDoNotAskAgain, this.myDoNotAskContentConfigurationAgain);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            WPDataService.$$$reportNull$$$0(1);
        }
        this.isEnabled = state.isEnabled();
        this.myWPPath = state.getWPPath();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
        this.myDoNotAskContentConfigurationAgain = state.isDoNotAskContentConfigAgain();
    }

    public boolean isDoNotAskContentConfigurationAgain() {
        return this.myDoNotAskContentConfigurationAgain;
    }

    public void setDoNotAskContentConfigurationAgain(boolean doNotAskContentConfigurationAgain) {
        this.myDoNotAskContentConfigurationAgain = doNotAskContentConfigurationAgain;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/settings/WPDataService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag
    public static class State {
        private boolean isEnabled;
        private String myWPPath;
        private boolean myDoNotAskAgain;
        private boolean myDoNotAskContentConfigAgain;

        public State() {
        }

        public State(boolean enabled, String WPPath, boolean doNotAskAgain, boolean doNotAskContentConfigAgain) {
            this.isEnabled = enabled;
            this.myWPPath = WPPath;
            this.myDoNotAskAgain = doNotAskAgain;
            this.myDoNotAskContentConfigAgain = doNotAskContentConfigAgain;
        }

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        @Tag(value="wordpressPath")
        public String getWPPath() {
            return this.myWPPath;
        }

        public void setWPPath(String wpPath) {
            this.myWPPath = wpPath;
        }

        public void setWPPathAndUpdateLastUsed(String drupalPath) {
            this.setWPPath(drupalPath);
            if (!StringUtil.isEmptyOrSpaces((String)drupalPath)) {
                PropertiesComponent.getInstance().setValue(WPDataService.WP_PATH_PROPERTY, drupalPath);
            }
        }

        @Attribute(value="doNotAskAgain")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="doNotAskConfigAgain")
        public boolean isDoNotAskContentConfigAgain() {
            return this.myDoNotAskContentConfigAgain;
        }

        public void setDoNotAskContentConfigAgain(boolean doNotAskContentConfigAgain) {
            this.myDoNotAskContentConfigAgain = doNotAskContentConfigAgain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.isEnabled != state.isEnabled) {
                return false;
            }
            if (this.myDoNotAskAgain != state.myDoNotAskAgain) {
                return false;
            }
            if (this.myDoNotAskContentConfigAgain != state.myDoNotAskContentConfigAgain) {
                return false;
            }
            return Objects.equals(this.myWPPath, state.myWPPath);
        }

        public int hashCode() {
            int result = this.isEnabled ? 1 : 0;
            result = 31 * result + (this.myWPPath != null ? this.myWPPath.hashCode() : 0);
            result = 31 * result + (this.myDoNotAskAgain ? 1 : 0);
            result = 31 * result + (this.myDoNotAskContentConfigAgain ? 1 : 0);
            return result;
        }
    }
}

