/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import com.jetbrains.php.wordpress.settings.WPDataService;
import icons.WordPressIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPHookRegistrationLineMarkerProvider
implements LineMarkerProvider {
    private static final Logger LOG = Logger.getInstance(WPHookRegistrationLineMarkerProvider.class);

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            WPHookRegistrationLineMarkerProvider.handlePotentialHook(psiElement, result);
        }
    }

    public static List<@NotNull FunctionReference> collectHookInteractions(@Nullable PsiElement functionReference, @Nullable MyHookInteractionsCollector.Mode mode, @NotNull SearchScope scope) {
        if (scope == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(3);
        }
        Ref result = Ref.create(Collections.emptyList());
        WPHookRegistrationLineMarkerProvider.handlePotentialHook(functionReference, mode, scope, (hook, isInvocation, interactions) -> result.set((Object)interactions));
        return (List)result.get();
    }

    private static void handlePotentialHook(PsiElement element, HookInteractionConsumer hookInteractionConsumer) {
        WPHookRegistrationLineMarkerProvider.handlePotentialHook(element, null, (SearchScope)GlobalSearchScope.allScope((Project)element.getProject()), hookInteractionConsumer);
    }

    private static void handlePotentialHook(PsiElement element, @Nullable MyHookInteractionsCollector.Mode mode, @NotNull SearchScope scope, HookInteractionConsumer hookInteractionConsumer) {
        if (scope == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (scope instanceof LocalSearchScope) {
            scope = GlobalSearchScope.filesScope((Project)element.getProject(), Arrays.asList(((LocalSearchScope)scope).getVirtualFiles()));
        } else if (!(scope instanceof GlobalSearchScope)) {
            LOG.warn(String.format("Search scope '%s' is not supported", scope.getClass().getName()));
            return;
        }
        WPHook hook = WPHookUtils.getPotentialHookFromRegistration(element, true);
        MyHookInteractionsCollector.Mode lookFor = mode != null ? mode : MyHookInteractionsCollector.Mode.INVOCATIONS;
        boolean isInvocation = true;
        if (hook == null) {
            hook = WPHookUtils.getPotentialHookFromInvocation(element, true);
            isInvocation = false;
            MyHookInteractionsCollector.Mode mode2 = lookFor = mode != null ? mode : MyHookInteractionsCollector.Mode.REGISTRATIONS;
        }
        if (hook == null) {
            return;
        }
        WPDataService dataService = WPDataService.getInstance(element.getProject());
        if (!dataService.isEnabled()) {
            return;
        }
        Collection filesWithKeys = FileBasedIndex.getInstance().getContainingFiles(WPHooksIndex.KEY, (Object)hook, (GlobalSearchScope)scope);
        if (filesWithKeys.isEmpty()) {
            return;
        }
        MyHookInteractionsCollector visitor = new MyHookInteractionsCollector(hook, lookFor);
        for (VirtualFile vFile : filesWithKeys) {
            PsiFile file = element.getManager().findFile(vFile);
            if (file == null) continue;
            file.accept((PsiElementVisitor)visitor);
        }
        if (visitor.getHookInteractions().isEmpty()) {
            return;
        }
        hookInteractionConsumer.accept(hook, isInvocation, visitor.getHookInteractions());
    }

    private static void handlePotentialHook(PsiElement element, Collection<? super LineMarkerInfo<?>> result) {
        WPHookRegistrationLineMarkerProvider.handlePotentialHook(element, (WPHook hook, boolean isInvocation, List<FunctionReference> interactions) -> {
            PsiElement nameElement;
            String title = isInvocation ? WPBundle.message("wp.choose.invocation.of.hook.0", hook) : WPBundle.message("wp.choose.registration.of.hook.0", hook);
            FunctionReference reference = (FunctionReference)element;
            ASTNode nameNode = reference.getNameNode();
            PsiElement psiElement = nameElement = nameNode == null ? null : nameNode.getPsi();
            if (nameElement != null) {
                result.add((LineMarkerInfo<?>)new LineMarkerInfo(nameElement, new TextRange(element.getTextOffset(), element.getTextOffset()), isInvocation ? WordPressIcons.ImplementedHook : WordPressIcons.ImplementingHook, (Function)new OverriddenHookTooltipGenerator(interactions, !isInvocation), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler((Collection)interactions, title), GutterIconRenderer.Alignment.LEFT));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookRegistrationLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHookInteractions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePotentialHook";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface HookInteractionConsumer {
        public void accept(WPHook var1, boolean var2, List<FunctionReference> var3);
    }

    public static final class MyHookInteractionsCollector
    extends PhpRecursiveElementVisitor {
        private final List<FunctionReference> myHookInteractions = new ArrayList<FunctionReference>();
        private final WPHook myHook;
        private final Mode myMode;

        MyHookInteractionsCollector(WPHook hookName, Mode mode) {
            this.myHook = hookName;
            this.myMode = mode;
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            super.visitPhpFunctionCall(reference);
            WPHookName currentParameter = WPHookUtils.getHookNameFromInvocation(reference, false);
            switch (this.myMode) {
                case ALL: {
                    if (!this.myHook.getName().equals(currentParameter)) break;
                    this.myHookInteractions.add(reference);
                    break;
                }
                case INVOCATIONS: {
                    if (!this.myHook.getName().equals(currentParameter) || WPHookType.findByInvocationMethod(reference.getName()) == null) break;
                    this.myHookInteractions.add(reference);
                    break;
                }
                case REGISTRATIONS: {
                    if (!this.myHook.getName().equals(currentParameter) || WPHookType.findByRegistrationMethod(reference.getName()) == null) break;
                    this.myHookInteractions.add(reference);
                }
            }
        }

        List<FunctionReference> getHookInteractions() {
            return this.myHookInteractions;
        }

        public static enum Mode {
            ALL,
            INVOCATIONS,
            REGISTRATIONS;

        }
    }

    private static final class OverriddenHookTooltipGenerator
    implements Function<PsiElement, String> {
        private final List<? extends FunctionReference> myInvocations;
        private final boolean myIsInvocations;

        private OverriddenHookTooltipGenerator(List<? extends FunctionReference> invocations, boolean isInvocations) {
            this.myInvocations = invocations;
            this.myIsInvocations = isInvocations;
        }

        public String fun(PsiElement __) {
            if (this.myInvocations.size() > 6) {
                if (this.myIsInvocations) {
                    return WPBundle.message("wp.has.invocations", new Object[0]);
                }
                return WPBundle.message("wp.has.registrations", new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.myIsInvocations ? WPBundle.message("wp.is.invoked.in", new Object[0]) : WPBundle.message("wp.is.registered.in", new Object[0])).append("<br/>");
            HashSet<String> fileNames = new HashSet<String>();
            boolean hasRealInvocations = false;
            for (FunctionReference functionReference : this.myInvocations) {
                PsiFile file = functionReference.getContainingFile();
                if (file == null) continue;
                String fileName = file.getName();
                if (!fileNames.contains(fileName)) {
                    sb.append(" '").append(fileName).append("'").append("<br/>");
                    fileNames.add(fileName);
                }
                hasRealInvocations = true;
            }
            return hasRealInvocations ? sb.toString() : WPBundle.message("wp.has.invocations", new Object[0]);
        }
    }
}

