/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.composer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerExecutionException;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerExecutorStatProvider;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerRemoteInterpreterExecution
implements ComposerExecution,
ComposerExecutorStatProvider {
    private static final String ROOT_TAG_NAME = "interpreter";
    private static final String INTERPRETER_NAME_ATTRIBUTE = "name";
    private static final String COMPOSER_PATH_ATTRIBUTE = "composer";
    private final String myInterpreterName;
    @NlsSafe
    private final String myComposerPath;

    public ComposerRemoteInterpreterExecution(String interpreterName, @NlsSafe String composerPath) {
        this.myInterpreterName = interpreterName;
        this.myComposerPath = composerPath;
    }

    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterName;
    }

    @Nullable
    @NlsSafe
    public String getComposerPath() {
        return this.myComposerPath;
    }

    @NotNull
    public ProcessHandler createProcessHandler(@NotNull Project project, String workingDir, @NotNull List<String> command, @NotNull String commandText) throws ExecutionException {
        ProcessHandler processHandler;
        if (project == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(1);
        }
        if (commandText == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(2);
        }
        Pair<PhpRemoteSdkAdditionalData, @Nls String> dataOrErrorMessage = ComposerRemoteInterpreterExecution.getRemoteDataOrErrorMessage(project, this.myInterpreterName);
        if (dataOrErrorMessage.second != null) {
            throw new ExecutionException((String)dataOrErrorMessage.second);
        }
        Pair<PhpRemoteProcessRunner, @Nls String> runnerOrErrorMessage = ComposerRemoteInterpreterExecution.getRunnerOrErrorMessage((PhpRemoteSdkAdditionalData)((Object)dataOrErrorMessage.first));
        if (runnerOrErrorMessage.second != null) {
            throw new ExecutionException((String)runnerOrErrorMessage.second);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.myComposerPath);
        for (String s : command) {
            commandLine.addParameter(s);
        }
        PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)((Object)dataOrErrorMessage.getFirst());
        PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
        if (instance == null) {
            throw new ExecutionException(PhpBundle.message((String)"php.remote.interpreter.plugin.is.not.installed", (Object[])new Object[0]));
        }
        PhpRemoteProcessRunner runner = (PhpRemoteProcessRunner)runnerOrErrorMessage.getFirst();
        if (!StringUtil.isEmpty((String)workingDir)) {
            PhpCommandLinePathProcessor mapper = instance.createPathMapper(project, (PhpSdkAdditionalData)data);
            if (!mapper.canProcess(workingDir)) {
                throw new ComposerExecutionException((List)ComposerUtils.createUnmappedMessage((String)workingDir, (String)"Working directory"));
            }
            String process = mapper.process(workingDir);
            commandLine.setWorkDirectory(process);
            if ("PhpDockerComposeRemoteProcessRunner".equals(runner.getClass().getSimpleName())) {
                commandLine.addParameters(new String[]{"-d", process});
            }
        }
        try {
            if (!SystemInfo.isWindows) {
                commandLine = new PtyCommandLine(commandLine).withInitialColumns(2500).withConsoleMode(false);
            } else {
                commandLine.getEnvironment().putIfAbsent("TERM", "xterm");
            }
            Process process = runner.startRemoteProcessWithoutHelpers(project, data, commandLine, true);
            processHandler = runner.createRemoteProcessHandler(process, commandText, EncodingProjectManager.getInstance((Project)project).getDefaultCharset(), data, true);
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (processHandler == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    private static @NotNull Pair<PhpRemoteSdkAdditionalData, @Nls String> getRemoteDataOrErrorMessage(@NotNull Project project, @Nullable String interpreterName) {
        if (project == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)interpreterName)) {
            Pair pair = Pair.create(null, (Object)PhpRemoteSdkBundle.message("interpreter.is.not.configured", new Object[0]));
            if (pair == null) {
                ComposerRemoteInterpreterExecution.$$$reportNull$$$0(5);
            }
            return pair;
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreter(interpreterName);
        if (interpreter == null) {
            Pair pair = Pair.create(null, (Object)PhpRemoteSdkBundle.message("there.is.no.0.interpreter", interpreterName));
            if (pair == null) {
                ComposerRemoteInterpreterExecution.$$$reportNull$$$0(6);
            }
            return pair;
        }
        PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
        if (!(data instanceof PhpRemoteSdkAdditionalData)) {
            Pair pair = Pair.create(null, (Object)PhpRemoteSdkBundle.message("there.is.no.0.remote.interpreter", interpreterName));
            if (pair == null) {
                ComposerRemoteInterpreterExecution.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)((Object)((PhpRemoteSdkAdditionalData)data)), null);
        if (pair == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(8);
        }
        return pair;
    }

    private static @NotNull Pair<PhpRemoteProcessRunner, @NlsContexts.DialogMessage String> getRunnerOrErrorMessage(@NotNull PhpRemoteSdkAdditionalData remoteData) {
        Pair pair;
        if (remoteData == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(9);
        }
        try {
            PhpRemoteProcessManager remoteProcessManager = PhpRemoteProcessManager.getInstance(remoteData);
            PhpRemoteProcessRunner runner = remoteProcessManager.getRemoteProcessRunner(remoteData);
            pair = Pair.create((Object)runner, null);
        }
        catch (ExecutionException executionException) {
            Pair pair2 = Pair.create(null, (Object)PhpRemoteSdkBundle.message("dialog.message.interpreters.type.are.not.supported", remoteData.getRemoteConnectionType().getName()));
            if (pair2 == null) {
                ComposerRemoteInterpreterExecution.$$$reportNull$$$0(11);
            }
            return pair2;
        }
        if (pair == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NlsContexts.DialogMessage
    @Nullable
    static String getValidationMessage(@NotNull Project project, @Nullable String interpreterName) {
        if (project == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(12);
        }
        Pair<PhpRemoteSdkAdditionalData, @NlsContexts.DialogMessage String> dataOrErrorMessage = ComposerRemoteInterpreterExecution.getRemoteDataOrErrorMessage(project, interpreterName);
        if (dataOrErrorMessage.second != null) {
            return (String)dataOrErrorMessage.second;
        }
        Pair<PhpRemoteProcessRunner, @NlsContexts.DialogMessage String> runnerOrErrorMessage = ComposerRemoteInterpreterExecution.getRunnerOrErrorMessage((PhpRemoteSdkAdditionalData)((Object)dataOrErrorMessage.first));
        return (String)runnerOrErrorMessage.second;
    }

    public void cancelProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(13);
        }
        handler.destroyProcess();
    }

    public boolean isWellConfigured(@NotNull Project project, boolean quick) {
        if (project == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myInterpreterName)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myComposerPath)) {
            return false;
        }
        return ComposerRemoteInterpreterExecution.getValidationMessage(project, this.myInterpreterName) == null;
    }

    public boolean isConfigured() {
        return !StringUtil.isEmptyOrSpaces((String)this.myInterpreterName) && !StringUtil.isEmptyOrSpaces((String)this.myComposerPath);
    }

    public boolean isDefault() {
        return false;
    }

    @Nullable
    public String getRemoteInterpreterType(@NotNull Project project) {
        boolean byJB;
        if (project == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myInterpreterName)) {
            return "unconfigured";
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreter(this.myInterpreterName);
        if (interpreter == null) {
            return "lost";
        }
        PhpSdkAdditionalData additionalData = interpreter.getPhpSdkAdditionalData();
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return "corrupted";
        }
        CredentialsType type = ((RemoteSdkAdditionalData)additionalData).getRemoteConnectionType();
        boolean bl = byJB = type == null || PluginInfoDetectorKt.getPluginInfo(type.getClass()).isDevelopedByJetBrains();
        return type != null ? (byJB ? StringUtil.replace((String)StringUtil.toLowerCase((String)type.getName()), (String)" ", (String)"-") : "third.party") : "local";
    }

    @NotNull
    public Element save() {
        Element element = new Element(ROOT_TAG_NAME);
        ComposerUtils.writeAttribute((Element)element, (String)INTERPRETER_NAME_ATTRIBUTE, (String)this.myInterpreterName);
        ComposerUtils.writeAttribute((Element)element, (String)COMPOSER_PATH_ATTRIBUTE, (String)this.myComposerPath);
        Element element2 = element;
        if (element2 == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(16);
        }
        return element2;
    }

    @Nullable
    public static ComposerRemoteInterpreterExecution load(@NotNull Element element) {
        if (element == null) {
            ComposerRemoteInterpreterExecution.$$$reportNull$$$0(17);
        }
        if (!ROOT_TAG_NAME.equals(element.getName())) {
            return null;
        }
        String name = element.getAttributeValue(INTERPRETER_NAME_ATTRIBUTE);
        String composerPath = element.getAttributeValue(COMPOSER_PATH_ATTRIBUTE);
        return new ComposerRemoteInterpreterExecution(name, composerPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 10, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandText";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/composer/ComposerRemoteInterpreterExecution";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/composer/ComposerRemoteInterpreterExecution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteDataOrErrorMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerOrErrorMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDataOrErrorMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerOrErrorMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValidationMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cancelProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWellConfigured";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteInterpreterType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 8, 10, 11, 16 -> new IllegalStateException(string);
        };
    }
}

