/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocCodeStylePanel
extends CodeStyleAbstractPanel {
    public static final String UNEXPECTED = "unexpected ";
    private final CodeStyleSettings mySettings;
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JCheckBox myAlignPhpDocParamsBox;
    private JCheckBox myAlignCommentsBox;
    private JCheckBox myKeepBlankLines;
    private JCheckBox myBlankLinesAroundParamTags;
    private JCheckBox myBlankLineBeforeTags;
    private JCheckBox myWrapLongLinesBox;
    private JCheckBox myUseFQCNCheckBox;
    private JPanel myGeneratedPhpDocPanel;
    private JCheckBox myForceNullPositionCheckBox;
    private JRadioButton myNullInTheFrontRadioButton;
    private JRadioButton myNullAtTheEndRadioButton;
    private JPanel myPhpDocElementsOrderPanel;
    private JBCheckBox mySortPHPDocBlocksJBCheckBox;
    private JPanel myPhpDocOrderPanel;
    private PhpDocMemberOrderList myPhpDocMemberOrderList;
    private static final int PHPDOC_PARAM_MIN_SPACES = 1;
    private static final int PHPDOC_PARAM_MAX_SPACES = 8;
    private JPanel myPhpDocParamSpacesPanel;
    private IntegerField myPhpDocParamSpacesBetweenTagAndTypeField;
    private IntegerField myPhpDocParamSpacesBetweenTypeAndNameField;
    private IntegerField myPhpDocParamSpacesBetweenNameAndDescriptionField;

    protected PhpDocCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        ItemListener listener = e -> this.somethingChanged();
        this.myAlignPhpDocParamsBox.addItemListener(listener);
        this.myAlignCommentsBox.addItemListener(listener);
        this.myBlankLineBeforeTags.addItemListener(listener);
        this.myKeepBlankLines.addItemListener(listener);
        this.myBlankLinesAroundParamTags.addItemListener(listener);
        this.myWrapLongLinesBox.addItemListener(listener);
        this.myGeneratedPhpDocPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("phpdoc.code.style.generated.doc.blocks", new Object[0])));
        this.myPhpDocOrderPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("phpdoc.code.style.sort.doc.blocks", new Object[0])));
        this.myPhpDocParamSpacesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("phpdoc.code.style.param.spaces.panel", new Object[0])));
        this.myForceNullPositionCheckBox.addActionListener(event -> {
            this.myNullInTheFrontRadioButton.setEnabled(this.myForceNullPositionCheckBox.isSelected());
            this.myNullAtTheEndRadioButton.setEnabled(this.myForceNullPositionCheckBox.isSelected());
        });
        ButtonGroup nullPositionGroup = new ButtonGroup();
        nullPositionGroup.add(this.myNullInTheFrontRadioButton);
        nullPositionGroup.add(this.myNullAtTheEndRadioButton);
        this.mySortPHPDocBlocksJBCheckBox.addItemListener(e -> this.myPhpDocMemberOrderList.setEnabled(this.mySortPHPDocBlocksJBCheckBox.isSelected()));
    }

    protected int getRightMargin() {
        return 60;
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(0);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(1);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "<?php\n\n/**\n * This is a sample function to illustrate additional PHP formatter\n * options.\n * @param $one The first parameter\n * @param int $two The second parameter\n * @param string $three The third parameter with a longer comment to illustrate wrapping.\n * @return void\n * @author J.S.\n *\n *\n * @license GPL\n */\nfunction foo($one, $two = 0, $three = \"String\")\n{\n}\n\n?>";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(2);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES = this.myAlignPhpDocParamsBox.isSelected();
        phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS = this.myAlignCommentsBox.isSelected();
        phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = this.myBlankLineBeforeTags.isSelected();
        phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES = this.myKeepBlankLines.isSelected();
        phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = this.myBlankLinesAroundParamTags.isSelected();
        phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES = this.myWrapLongLinesBox.isSelected();
        phpCodeStyleSettings.PHPDOC_USE_FQCN = this.myUseFQCNCheckBox.isSelected();
        phpCodeStyleSettings.NULL_TYPE_POSITION = this.myForceNullPositionCheckBox.isSelected() ? (this.myNullAtTheEndRadioButton.isSelected() ? PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_END : PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) : PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE;
        this.myPhpDocMemberOrderList.apply(phpCodeStyleSettings);
        phpCodeStyleSettings.SORT_PHPDOC_ELEMENTS = this.mySortPHPDocBlocksJBCheckBox.isSelected();
        phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TAG_AND_TYPE = this.myPhpDocParamSpacesBetweenTagAndTypeField.getValue();
        phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TYPE_AND_NAME = this.myPhpDocParamSpacesBetweenTypeAndNameField.getValue();
        phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_NAME_AND_DESCRIPTION = this.myPhpDocParamSpacesBetweenNameAndDescriptionField.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        if (phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES != this.myAlignPhpDocParamsBox.isSelected()) return true;
        if (this.myPhpDocMemberOrderList.isModified(phpCodeStyleSettings)) return true;
        if (phpCodeStyleSettings.SORT_PHPDOC_ELEMENTS != this.mySortPHPDocBlocksJBCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS != this.myAlignCommentsBox.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS != this.myBlankLineBeforeTags.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES != this.myKeepBlankLines.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS != this.myBlankLinesAroundParamTags.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES != this.myWrapLongLinesBox.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_USE_FQCN != this.myUseFQCNCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.NULL_TYPE_POSITION != (this.myForceNullPositionCheckBox.isSelected() ? (this.myNullAtTheEndRadioButton.isSelected() ? PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_END : PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) : PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE)) return true;
        if (phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TAG_AND_TYPE != this.myPhpDocParamSpacesBetweenTagAndTypeField.getValue()) return true;
        if (phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TYPE_AND_NAME != this.myPhpDocParamSpacesBetweenTypeAndNameField.getValue()) return true;
        if (phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_NAME_AND_DESCRIPTION == this.myPhpDocParamSpacesBetweenNameAndDescriptionField.getValue()) return false;
        return true;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(3);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myAlignPhpDocParamsBox.setSelected(phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES);
        this.myAlignCommentsBox.setSelected(phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS);
        this.myBlankLineBeforeTags.setSelected(phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS);
        this.myKeepBlankLines.setSelected(phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES);
        this.myBlankLinesAroundParamTags.setSelected(phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS);
        this.myWrapLongLinesBox.setSelected(phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES);
        this.myUseFQCNCheckBox.setSelected(phpCodeStyleSettings.PHPDOC_USE_FQCN);
        this.myForceNullPositionCheckBox.setSelected(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
        if (phpCodeStyleSettings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) {
            this.myNullInTheFrontRadioButton.setSelected(true);
        } else {
            this.myNullAtTheEndRadioButton.setSelected(true);
        }
        this.myNullInTheFrontRadioButton.setEnabled(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
        this.myNullAtTheEndRadioButton.setEnabled(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
        this.myPhpDocMemberOrderList.reset(phpCodeStyleSettings);
        this.mySortPHPDocBlocksJBCheckBox.setSelected(phpCodeStyleSettings.SORT_PHPDOC_ELEMENTS);
        this.myPhpDocMemberOrderList.setEnabled(phpCodeStyleSettings.SORT_PHPDOC_ELEMENTS);
        this.myPhpDocParamSpacesBetweenTagAndTypeField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TAG_AND_TYPE));
        this.myPhpDocParamSpacesBetweenTypeAndNameField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TYPE_AND_NAME));
        this.myPhpDocParamSpacesBetweenNameAndDescriptionField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_NAME_AND_DESCRIPTION));
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = PhpFrontBackBundle.message("phpdoc.code.style.title", new Object[0]);
        if (string == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void createUIComponents() {
        this.myPhpDocMemberOrderList = new PhpDocMemberOrderList();
        ListSpeedSearch.installOn((JList)((Object)this.myPhpDocMemberOrderList));
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)this.mySettings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myPhpDocElementsOrderPanel = ToolbarDecorator.createDecorator((JList)((Object)this.myPhpDocMemberOrderList)).setAddAction(button -> this.myPhpDocMemberOrderList.addDocTag((AnActionButton)button, phpCodeStyleSettings)).setRemoveAction(button -> ListUtil.removeSelectedItems((JList)((Object)this.myPhpDocMemberOrderList))).createPanel();
        this.myPhpDocParamSpacesBetweenTagAndTypeField = new IntegerField(null, 1, 8);
        this.myPhpDocParamSpacesBetweenTagAndTypeField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TAG_AND_TYPE));
        this.myPhpDocParamSpacesBetweenTypeAndNameField = new IntegerField(null, 1, 8);
        this.myPhpDocParamSpacesBetweenTypeAndNameField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_TYPE_AND_NAME));
        this.myPhpDocParamSpacesBetweenNameAndDescriptionField = new IntegerField(null, 1, 8);
        this.myPhpDocParamSpacesBetweenNameAndDescriptionField.setValue(Integer.valueOf(phpCodeStyleSettings.PHPDOC_PARAM_SPACES_BETWEEN_NAME_AND_DESCRIPTION));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPreviewPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 1, 3, 1, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 8, 2, 0, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel6);
        this.myKeepBlankLines = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.keep.blank.lines"));
        jPanel6.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlankLineBeforeTags = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.blank.line.before.the.first.tag"));
        jPanel6.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlankLinesAroundParamTags = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.blank.lines.around.parameters"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapLongLinesBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.wrap.long.lines"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignPhpDocParamsBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.align.parameter.property.names"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignCommentsBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.align.tag.comments"));
        jPanel6.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPhpDocParamSpacesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.param.spaces.between.tag.and.type"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField = this.myPhpDocParamSpacesBetweenTagAndTypeField;
        jPanel3.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.param.spaces.between.type.and.name"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.param.spaces.between.name.and.description"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField2 = this.myPhpDocParamSpacesBetweenNameAndDescriptionField;
        jPanel3.add((Component)integerField2, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        IntegerField integerField3 = this.myPhpDocParamSpacesBetweenTypeAndNameField;
        jPanel3.add((Component)integerField3, new GridConstraints(1, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        this.myGeneratedPhpDocPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(7, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.generated.doc.blocks"), (int)0, (int)0, null, null));
        this.myUseFQCNCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.use.fully.qualified.class.names"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForceNullPositionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.force.null.position"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 1, 1, null, null, null, 1));
        this.myNullAtTheEndRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.in.end.position"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNullInTheFrontRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("phpdoc.code.style.in.beginning.position"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPhpDocOrderPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(8, 0, 1, 1, 0, 3, 1, 7, null, null, null));
        JPanel jPanel8 = this.myPhpDocElementsOrderPanel;
        jPanel.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 7, null, null, null, 1));
        this.mySortPHPDocBlocksJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpDocCodeStylePanel.class).getString("checkbox.sort.phpdoc.tags"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/ui/PhpDocCodeStylePanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/ui/PhpDocCodeStylePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static class PhpDocMemberOrderList
    extends JBList<String> {
        public static final Map<@NlsSafe String, Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>> PROPERTIES = new HashMap<String, Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>>();
        private final DefaultListModel<@NlsSafe String> myModel = new DefaultListModel();

        public PhpDocMemberOrderList() {
            this.setModel(this.myModel);
            this.setVisibleRowCount(PROPERTIES.size());
        }

        public void reset(PhpCodeStyleSettings settings) {
            this.myModel.removeAllElements();
            for (String string : PhpDocMemberOrderList.getPropertyNames(settings)) {
                if (((ToIntFunction)PhpDocMemberOrderList.PROPERTIES.get((Object)string).first).applyAsInt(settings) == settings.UNKNOWN_TAG_WEIGHT) continue;
                this.myModel.addElement(string);
            }
            this.setSelectedIndex(0);
        }

        private static void init() {
            PROPERTIES.put("@return", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.RETURN_WEIGHT, (value, settings) -> {
                settings.RETURN_WEIGHT = value;
            }));
            PROPERTIES.put("@param", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.PARAM_WEIGHT, (value, settings) -> {
                settings.PARAM_WEIGHT = value;
            }));
            PROPERTIES.put("@throws", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.THROWS_WEIGHT, (value, settings) -> {
                settings.THROWS_WEIGHT = value;
            }));
            PROPERTIES.put("@link", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.LINK_WEIGHT, (value, settings) -> {
                settings.LINK_WEIGHT = value;
            }));
            PROPERTIES.put("@internal", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.INTERNAL_WEIGHT, (value, settings) -> {
                settings.INTERNAL_WEIGHT = value;
            }));
            PROPERTIES.put("@uses", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.USES_WEIGHT, (value, settings) -> {
                settings.USES_WEIGHT = value;
            }));
            PROPERTIES.put("@author", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.AUTHOR_WEIGHT, (value, settings) -> {
                settings.AUTHOR_WEIGHT = value;
            }));
            PROPERTIES.put("@version", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.VERSION_WEIGHT, (value, settings) -> {
                settings.VERSION_WEIGHT = value;
            }));
            PROPERTIES.put("@api", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.API_WEIGHT, (value, settings) -> {
                settings.API_WEIGHT = value;
            }));
            PROPERTIES.put("@category", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.CATEGORY_WEIGHT, (value, settings) -> {
                settings.CATEGORY_WEIGHT = value;
            }));
            PROPERTIES.put("@copyright", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.COPYRIGHT_WEIGHT, (value, settings) -> {
                settings.COPYRIGHT_WEIGHT = value;
            }));
            PROPERTIES.put("@deprecated", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.DEPRECATED_WEIGHT, (value, settings) -> {
                settings.DEPRECATED_WEIGHT = value;
            }));
            PROPERTIES.put("@example", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.EXAMPLE_WEIGHT, (value, settings) -> {
                settings.EXAMPLE_WEIGHT = value;
            }));
            PROPERTIES.put("@filesource", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.FILESOURCE_WEIGHT, (value, settings) -> {
                settings.FILESOURCE_WEIGHT = value;
            }));
            PROPERTIES.put("@global", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.GLOBAL_WEIGHT, (value, settings) -> {
                settings.GLOBAL_WEIGHT = value;
            }));
            PROPERTIES.put("@ignore", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.IGNORE_WEIGHT, (value, settings) -> {
                settings.IGNORE_WEIGHT = value;
            }));
            PROPERTIES.put("@license", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.LICENSE_WEIGHT, (value, settings) -> {
                settings.LICENSE_WEIGHT = value;
            }));
            PROPERTIES.put("@method", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.METHOD_WEIGHT, (value, settings) -> {
                settings.METHOD_WEIGHT = value;
            }));
            PROPERTIES.put("@package", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.PACKAGE_WEIGHT, (value, settings) -> {
                settings.PACKAGE_WEIGHT = value;
            }));
            PROPERTIES.put("@property", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.PROPERTY_WEIGHT, (value, settings) -> {
                settings.PROPERTY_WEIGHT = value;
            }));
            PROPERTIES.put("@property-read", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.PROPERTY_READ_WEIGHT, (value, settings) -> {
                settings.PROPERTY_READ_WEIGHT = value;
            }));
            PROPERTIES.put("@property-write", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.PROPERTY_WRITE_WEIGHT, (value, settings) -> {
                settings.PROPERTY_WRITE_WEIGHT = value;
            }));
            PROPERTIES.put("@see", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.SEE_WEIGHT, (value, settings) -> {
                settings.SEE_WEIGHT = value;
            }));
            PROPERTIES.put("@since", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.SINCE_WEIGHT, (value, settings) -> {
                settings.SINCE_WEIGHT = value;
            }));
            PROPERTIES.put("@subpackage", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.SUBPACKAGE_WEIGHT, (value, settings) -> {
                settings.SUBPACKAGE_WEIGHT = value;
            }));
            PROPERTIES.put("@todo", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.TODO_WEIGHT, (value, settings) -> {
                settings.TODO_WEIGHT = value;
            }));
            PROPERTIES.put("@var", (Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>>)Pair.create(settings -> settings.VAR_WEIGHT, (value, settings) -> {
                settings.VAR_WEIGHT = value;
            }));
        }

        private static Collection<@NlsSafe String> getPropertyNames(final PhpCodeStyleSettings settings) {
            ArrayList<String> result = new ArrayList<String>(PROPERTIES.keySet());
            result.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return this.getWeight(o1) - this.getWeight(o2);
                }

                private int getWeight(String o) {
                    Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>> propertyManager = PROPERTIES.get(o);
                    if (propertyManager == null) {
                        throw new IllegalArgumentException(PhpDocCodeStylePanel.UNEXPECTED + o);
                    }
                    return ((ToIntFunction)propertyManager.getFirst()).applyAsInt(settings);
                }
            });
            return result;
        }

        public void apply(PhpCodeStyleSettings settings) {
            PROPERTIES.keySet().forEach(s -> {
                if (!this.myModel.contains(s)) {
                    ((BiConsumer)PROPERTIES.get(s).getSecond()).accept(settings.UNKNOWN_TAG_WEIGHT, settings);
                } else {
                    Pair<ToIntFunction<PhpCodeStyleSettings>, BiConsumer<Integer, PhpCodeStyleSettings>> propertyManager = PROPERTIES.get(s);
                    if (propertyManager == null) {
                        throw new IllegalArgumentException(PhpDocCodeStylePanel.UNEXPECTED + s);
                    }
                    ((BiConsumer)propertyManager.getSecond()).accept(this.myModel.indexOf(s), settings);
                }
            });
        }

        public boolean isModified(PhpCodeStyleSettings settings) {
            List names = ContainerUtil.filter(PhpDocMemberOrderList.getPropertyNames(settings), i -> ((ToIntFunction)PhpDocMemberOrderList.PROPERTIES.get((Object)i).first).applyAsInt(settings) != settings.UNKNOWN_TAG_WEIGHT);
            if (this.myModel.size() != names.size()) {
                return true;
            }
            if (!this.myModel.isEmpty()) {
                int i2 = 0;
                for (String property : names) {
                    if (i2 >= this.myModel.size() || !property.equals(this.myModel.getElementAt(i2))) {
                        return true;
                    }
                    ++i2;
                }
            }
            return false;
        }

        void addDocTag(AnActionButton button, PhpCodeStyleSettings settings) {
            List unknownDocTags = ContainerUtil.sorted((Collection)ContainerUtil.filter(PhpDocMemberOrderList.getPropertyNames(settings), i -> ((ToIntFunction)PhpDocMemberOrderList.PROPERTIES.get((Object)i).first).applyAsInt(settings) == settings.UNKNOWN_TAG_WEIGHT));
            PopupChooserBuilder builder = (PopupChooserBuilder)JBPopupFactory.getInstance().createPopupChooserBuilder(unknownDocTags);
            @Nullable JComponent obj = builder.getChooserComponent();
            if (obj instanceof JBList) {
                JBList list = (JBList)obj;
                ListSpeedSearch.installOn((JList)list);
            }
            JBPopup popup = builder.setItemChosenCallback(this.myModel::addElement).createPopup();
            popup.show(button.getPreferredPopupPoint());
        }

        static {
            PhpDocMemberOrderList.init();
        }
    }
}

