/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class BasicPhpDocUtil {
    private static final String CARET_MARKER = "${CARET}";
    @NlsSafe
    public static final String API_TAG = "@api";
    @NlsSafe
    public static final String AUTHOR_TAG = "@author";
    @NlsSafe
    public static final String CATEGORY_TAG = "@category";
    @NlsSafe
    public static final String COPYRIGHT_TAG = "@copyright";
    @NlsSafe
    public static final String DEPRECATED_TAG = "@deprecated";
    @NlsSafe
    public static final String EXAMPLE_TAG = "@example";
    @NlsSafe
    public static final String FILESOURCE_TAG = "@filesource";
    @NlsSafe
    public static final String GLOBAL_TAG = "@global";
    @NlsSafe
    public static final String IGNORE_TAG = "@ignore";
    @NlsSafe
    public static final String INTERNAL_TAG = "@internal";
    @NlsSafe
    public static final String LICENSE_TAG = "@license";
    @NlsSafe
    public static final String LINK_TAG = "@link";
    @NlsSafe
    public static final String METHOD_TAG = "@method";
    @NlsSafe
    public static final String PACKAGE_TAG = "@package";
    @NlsSafe
    public static final String PARAM_TAG = "@param";
    @NlsSafe
    public static final String PROPERTY_TAG = "@property";
    @NlsSafe
    public static final String PROPERTY_READ_TAG = "@property-read";
    @NlsSafe
    public static final String PROPERTY_WRITE_TAG = "@property-write";
    @NlsSafe
    public static final String RETURN_TAG = "@return";
    @NlsSafe
    public static final String SEE_TAG = "@see";
    @NlsSafe
    public static final String SINCE_TAG = "@since";
    @NlsSafe
    public static final String REMOVED_TAG = "@removed";
    @NlsSafe
    public static final String SUBPACKAGE_TAG = "@subpackage";
    @NlsSafe
    public static final String THROWS_TAG = "@throws";
    @NlsSafe
    public static final String TODO_TAG = "@todo";
    @NlsSafe
    public static final String USES_TAG = "@uses";
    @NlsSafe
    public static final String USED_BY_TAG = "used-by";
    @NlsSafe
    public static final String VAR_TAG = "@var";
    @NlsSafe
    public static final String VERSION_TAG = "@version";
    @NlsSafe
    public static final String INHERITDOC_TAG = "@inheritDoc";
    @NlsSafe
    public static final String MIXIN_TAG = "@mixin";
    @NlsSafe
    public static final String NOINSPECTION = "@noinspection";
    @NlsSafe
    public static final String TYPE_TAG = "@type";
    @NlsSafe
    public static final String FINAL_TAG = "@final";
    @NlsSafe
    public static final String CODE_TAG = "@code";
    public static final Set<String> ALL_TAGS = Set.of("@api", "@author", "@category", "@copyright", "@deprecated", "@example", "@filesource", "@global", "@ignore", "@internal", "@license", "@link", "@method", "@package", "@param", "@property", "@property-read", "@property-write", "@return", "@see", "@since", "@subpackage", "@throws", "@todo", "@uses", "used-by", "@var", "@version", "@inheritDoc", "@mixin", "@final", "@noinspection", "@type", "@code", "@removed");

    public static boolean isSimpleTag(PsiElement element) {
        IElementType prevType;
        if (!(element instanceof PhpDocTag)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if ((prevType = PsiUtilCore.getElementType((PsiElement)prev)) == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prevType == PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            Object child = element.getFirstChild();
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if (ALL_TAGS.contains(child.getText())) {
                    return true;
                }
                if ((child = BasicPhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) == null) {
                    return true;
                }
                IElementType childType = child.getNode().getElementType();
                if (childType == PhpDocElementTypes.phpDocType || childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocElementTypes.phpDocRef) {
                    return true;
                }
                if (childType == PhpDocElementTypes.phpDocTagValue && ((child = child.getFirstChild()) == null || BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) || BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TEXT))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean tryMoveCaretOnMarker(@NotNull Editor editor, @NotNull TextRange docRange) {
        if (editor == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(0);
        }
        if (docRange == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(1);
        }
        return BasicPhpDocUtil.tryMoveCaretOnMarker(editor, docRange, CARET_MARKER, Collections.emptyList());
    }

    public static boolean tryMoveCaretOnMarker(@NotNull Editor editor, @NotNull TextRange docRange, @NotNull Collection<? extends RangeMarker> ignored) {
        if (editor == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(2);
        }
        if (docRange == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(3);
        }
        if (ignored == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(4);
        }
        return BasicPhpDocUtil.tryMoveCaretOnMarker(editor, docRange, CARET_MARKER, ignored);
    }

    public static boolean tryMoveCaretOnMarker(@NotNull Editor editor, @NotNull TextRange docRange, String caretMarker, @NotNull Collection<? extends RangeMarker> ignored) {
        if (editor == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(5);
        }
        if (docRange == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(6);
        }
        if (ignored == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        Set ignoredOffsets = StreamEx.of(ignored).map(marker -> marker.getStartOffset()).toSet();
        List caretMarkers = ContainerUtil.filter(BasicPhpDocUtil.collectCaretMarkers(document, caretMarker, docRange), marker -> !ignoredOffsets.contains(marker.getStartOffset()));
        if (caretMarkers.isEmpty()) {
            return false;
        }
        editor.getCaretModel().moveToOffset(((RangeMarker)caretMarkers.get(0)).getStartOffset());
        caretMarkers.forEach(marker -> document.deleteString(marker.getStartOffset(), marker.getEndOffset()));
        Project project = editor.getProject();
        if (project != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        return true;
    }

    @NotNull
    public static List<RangeMarker> collectCaretMarkers(@NotNull Document document, String caretMarker, @NotNull TextRange docRange) {
        if (document == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(8);
        }
        if (docRange == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(9);
        }
        SmartList result = new SmartList();
        if (docRange.getStartOffset() < 0 || docRange.getEndOffset() > document.getTextLength() || docRange.getStartOffset() > docRange.getEndOffset()) {
            SmartList smartList = result;
            if (smartList == null) {
                BasicPhpDocUtil.$$$reportNull$$$0(10);
            }
            return smartList;
        }
        String content = document.getText(docRange);
        for (int i = 0; i <= content.length() - caretMarker.length(); ++i) {
            if (!StringUtil.startsWith((CharSequence)content, (int)i, (CharSequence)caretMarker)) continue;
            result.add(document.createRangeMarker(new TextRange(i, i + caretMarker.length()).shiftRight(docRange.getStartOffset())));
        }
        SmartList smartList = result;
        if (smartList == null) {
            BasicPhpDocUtil.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRange";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/BasicPhpDocUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/BasicPhpDocUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCaretMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryMoveCaretOnMarker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectCaretMarkers";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

