/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.php.performanceTesting;

import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.utils.EditorUtils;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.php.performanceTesting.AbstractRefactoringTestCommand;
import org.jetbrains.php.performanceTesting.util.PhpInlineUtil;

public final class PhpInlineMethodTestCommand
extends AbstractRefactoringTestCommand {
    private static final Logger LOG = Logger.getInstance(PhpInlineMethodTestCommand.class);
    static final String PREFIX = "%phpInlineMethodTest";

    PhpInlineMethodTestCommand(@NotNull String text, int line) {
        if (text == null) {
            PhpInlineMethodTestCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            PhpInlineMethodTestCommand.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        AbstractRefactoringTestCommand.InputArgs inputArgs = new AbstractRefactoringTestCommand.InputArgs(this.getText().substring(PREFIX.length()).trim());
        List<VirtualFile> phpFiles = this.getPhpFiles(context);
        int numberOfFiles = Math.min(inputArgs.getNumFilesToWalk(), phpFiles.size());
        this.random = new Random(inputArgs.getRandomSeed());
        Collections.shuffle(phpFiles, this.random);
        for (int fileCounter = 0; fileCounter < numberOfFiles && fileCounter < phpFiles.size(); ++fileCounter) {
            VirtualFile virtualFile = phpFiles.get(fileCounter);
            try {
                Editor editor = this.getEditor(project, virtualFile);
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()));
                boolean isInlinePerformed = this.doTestAction(project, editor, psiFile, inputArgs.getNumEntriesToWalk());
                if (isInlinePerformed) continue;
                ++numberOfFiles;
                continue;
            }
            catch (RuntimeException e) {
                if (fileCounter < numberOfFiles - 1) {
                    LOG.error("Were proceeded " + fileCounter + " files instead of " + numberOfFiles + ", was given " + inputArgs.getNumFilesToWalk() + ", in file " + virtualFile.getPath());
                }
                throw new RuntimeException("PhpInlineMethodTestCommand exception occurred", e);
            }
        }
        this.profilerStopper.setDone();
        Promise promise = Promises.toPromise((ActionCallback)this.profilerStopper);
        if (promise == null) {
            PhpInlineMethodTestCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private boolean doTestAction(Project project, Editor editor, PsiFile psiFile, int times) {
        List<TextRange> ranges = this.getFunctionRanges(psiFile, functionReference -> {
            PsiElement functionDeclaration = (PsiElement)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> functionReference.resolve());
            if (functionDeclaration != null) {
                return (Boolean)ReadAction.compute(() -> {
                    try {
                        PhpInlineFunctionHandler.validate(project, (Function)functionDeclaration);
                        return true;
                    }
                    catch (PhpRefactoringErrorException e) {
                        LOG.info("Function " + functionReference.getText() + "isn't inlinable due to " + e.getMessage());
                        return false;
                    }
                });
            }
            return false;
        }, functionReference -> (Boolean)ReadAction.compute(() -> {
            editor.getCaretModel().moveToOffset(functionReference.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(EditorUtils.createEditorContext((Editor)editor));
            for (InlineActionHandler handler : InlineActionHandler.EP_NAME.getExtensionList()) {
                if (!handler.canInlineElementInEditor(element, editor)) continue;
                if (handler instanceof PhpInlineFunctionHandler) {
                    return true;
                }
                return false;
            }
            return false;
        }));
        if (ranges.isEmpty()) {
            LOG.info("No functions to inline in " + psiFile.getVirtualFile().getPath());
            return false;
        }
        Collections.shuffle(ranges, this.random);
        for (int i = 0; i < times && i < ranges.size(); ++i) {
            this.waitTillAnalysisIsDone(psiFile, project);
            int errorsBefore = this.countProjectErrors(editor, project);
            TextRange range = ranges.get(i);
            FunctionReference reparsedFunction = (FunctionReference)ReadAction.compute(() -> (FunctionReference)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)range.getStartOffset(), FunctionReference.class, (boolean)true));
            LOG.debug("File before inline\n" + psiFile.getText());
            PhpInlineUtil.doInline(reparsedFunction, project);
            LOG.debug("File after inline\n" + psiFile.getText());
            this.waitTillAnalysisIsDone(psiFile, project);
            int errorsAfter = this.countProjectErrors(editor, project);
            PhpInlineMethodTestCommand.rollBackChanges(project, psiFile);
            this.doAssert(errorsBefore, errorsAfter, () -> (String)ReadAction.compute(() -> "Error on function " + reparsedFunction.getElement().getText() + "\nFile " + String.valueOf(psiFile.getVirtualFile())));
        }
        return true;
    }

    private void doAssert(int beforeErrors, int afterErrors, Supplier<String> stringOnError) {
        if (afterErrors > beforeErrors) {
            this.profilerStopper.reject("New errors are found after inline refactoring: " + beforeErrors + " => " + afterErrors + "\n" + stringOnError.get());
        }
    }

    private List<TextRange> getFunctionRanges(@NotNull PsiFile psiFile, final Predicate<FunctionReference> ... filters) {
        if (psiFile == null) {
            PhpInlineMethodTestCommand.$$$reportNull$$$0(3);
        }
        final ArrayList<TextRange> referenceList = new ArrayList<TextRange>();
        ApplicationManager.getApplication().invokeAndWait(() -> psiFile.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference function) {
                boolean canBeInlined = ContainerUtil.and((Object[])filters, predicate -> predicate.test(function));
                if (canBeInlined) {
                    referenceList.add(function.getTextRange());
                }
                super.visitPhpElement((PhpPsiElement)function);
            }
        }));
        return referenceList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/php/performanceTesting/PhpInlineMethodTestCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/php/performanceTesting/PhpInlineMethodTestCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

