/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.edit;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyFile;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.lexer.SmartyLexer;
import org.jetbrains.annotations.NotNull;

public final class SmartyEnterBetweenTags
implements EnterHandlerDelegate {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            SmartyEnterBetweenTags.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SmartyEnterBetweenTags.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            SmartyEnterBetweenTags.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            SmartyEnterBetweenTags.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            SmartyEnterBetweenTags.$$$reportNull$$$0(4);
        }
        if (file instanceof SmartyFile && SmartyEnterBetweenTags.isBetweenSmartyTags(editor, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenSmartyTags(Editor editor, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        String rightDelimiter = SmartyLexer.getRightDelimiter(editor.getProject());
        char rightDelimiterLastSymbol = rightDelimiter.charAt(rightDelimiter.length() - 1);
        if (chars.charAt(offset - 1) != rightDelimiterLastSymbol) {
            return false;
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        if (iterator.getTokenType() != SmartyTokenTypes.TAG_END) {
            return false;
        }
        iterator.retreat();
        int retrieveCount = 1;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == SmartyTokenTypes.END_TAG_START) {
                return false;
            }
            if (tokenType == SmartyTokenTypes.START_TAG_START) break;
            ++retrieveCount;
            iterator.retreat();
        }
        for (int i = 0; i < retrieveCount; ++i) {
            iterator.advance();
        }
        iterator.advance();
        return !iterator.atEnd() && iterator.getTokenType() == SmartyTokenTypes.END_TAG_START;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/smarty/edit/SmartyEnterBetweenTags";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

