/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml.providers.member;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.uml.utils.DiagramBundle;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.uml.providers.member.CreateNewMethodDialog;
import com.jetbrains.php.uml.providers.member.CreateNewPhpMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewPhpMethod
extends CreateNewPhpMember {
    public CreateNewPhpMethod() {
        super(DiagramBundle.message((String)"create.new.method.dialog.title", (Object[])new Object[0]), IconManager.getInstance().getPlatformIcon(PlatformIcons.Method));
    }

    public boolean isEnabledOn(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null && file.isWritable() && element instanceof PhpClass;
    }

    @Nullable
    public Runnable prepare(PsiElement element, DiagramBuilder builder2) {
        if (element instanceof PhpClass) {
            Method method = PhpPsiElementFactory.createMethod(element.getProject(), ((PhpClass)element).isInterface() ? "public function f ();" : "public function f(){}");
            CreateNewMethodDialog dlg = new CreateNewMethodDialog(builder2.getProject(), new PhpMethodDescriptor((Function)method), null);
            if (dlg.showAndGet()) {
                return () -> {
                    if (FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                        PhpCodeEditUtil.insertClassMember((PhpClass)element, (PsiElement)method);
                    }
                };
            }
        }
        return null;
    }

    public void execute(DiagramBuilder builder2, Runnable runnable, AnActionEvent e) {
        runnable.run();
    }

    @NotNull
    public String getActionName() {
        String string = this.getTemplatePresentation().getText();
        if (string == null) {
            CreateNewPhpMethod.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/uml/providers/member/CreateNewPhpMethod", "getActionName"));
    }
}

