/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpTextFieldWithSdkBasedBrowse;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSProjectConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSQualityToolType;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSOptionsPanel
extends QualityToolsOptionsPanel {
    private static final Logger LOG = Logger.getInstance(PhpCSOptionsPanel.class);
    private JPanel myOptionsPanel;
    private JCheckBox myShowWarningsBox;
    private JComboBox<String> myStandardCombo;
    private JCheckBox myShowSniffNamesBox;
    private JCheckBox myUseInstalledPaths;
    private PhpTextFieldWithSdkBasedBrowse myInstalledPathsTextField;
    private JBTextField myExtensionsTextField;
    private TextFieldWithBrowseButton myCustomRulesetTextField;
    private JComboBox<HighlightSeverity> myHighlightSeverityCombobox;
    private final QualityToolConfigurationComboBox myComboBox;

    public PhpCSOptionsPanel(Project project, QualityToolConfigurationComboBox comboBox, final Runnable validate) {
        super(project, validate, PhpCSQualityToolType.INSTANCE);
        this.myComboBox = comboBox;
        this.$$$setupUI$$$();
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(project);
        this.myShowWarningsBox.setSelected(!configuration.isIgnoreWarnings());
        this.myInstalledPathsTextField.init(project, this.getSdkAdditionalData(project, comboBox), PhpBundle.message("quality.tool.phpcs.installed.paths", new Object[0]), false, true);
        this.myInstalledPathsTextField.setEnabled(this.myUseInstalledPaths.isEnabled());
        this.myUseInstalledPaths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpCSOptionsPanel.this.myInstalledPathsTextField.setEnabled(PhpCSOptionsPanel.this.myUseInstalledPaths.isEnabled());
            }
        });
        this.myStandardCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PhpCSOptionsPanel.this.myCustomRulesetTextField.setVisible(e.getItem().equals("Custom"));
                }
            }
        });
        Arrays.stream(HighlightSeverity.DEFAULT_SEVERITIES).forEach(severity -> this.myHighlightSeverityCombobox.addItem((HighlightSeverity)severity));
        this.myHighlightSeverityCombobox.setSelectedItem(ContainerUtil.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, i -> i.myName.equals(configuration.getHighlightLevel())));
        this.myHighlightSeverityCombobox.setRenderer((ListCellRenderer<HighlightSeverity>)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value != null ? HighlightDisplayLevel.find((HighlightSeverity)value).getIcon() : null);
            label.setText(value != null ? SingleInspectionProfilePanel.renderSeverity((HighlightSeverity)value) : "");
        }));
        this.myCustomRulesetTextField.setVisible(Objects.equals(this.myStandardCombo.getSelectedItem(), "Custom"));
        this.myCustomRulesetTextField.addActionListener(e -> {
            try {
                ActionListener action = this.createBrowserAction(project, this.myCustomRulesetTextField.getParent(), this.myCustomRulesetTextField, comboBox, configuration.getCustomRuleset());
                action.actionPerformed(e);
            }
            catch (PhpInvalidSdkTypeException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.myUseInstalledPaths.setSelected(configuration.isUseInstalledPaths());
        this.myUseInstalledPaths.addActionListener(e -> this.myInstalledPathsTextField.setEnabled(this.myUseInstalledPaths.isSelected()));
        this.myInstalledPathsTextField.setText(configuration.getInstalledPaths());
        this.myInstalledPathsTextField.setEnabled(configuration.isUseInstalledPaths());
        this.myInstalledPathsTextField.init(project, this.getSdkAdditionalData(project, comboBox), PhpBundle.message("quality.tool.phpcs.installed.paths", new Object[0]), false, true);
        this.myShowSniffNamesBox.setSelected(configuration.isShowSniffs());
        this.myExtensionsTextField.setText(configuration.getExtensions());
        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{PhpCSOptionsConfiguration.getInstance(this.myProject).getCodingStandard()}));
        this.myStandardCombo.addItemListener(i -> validate.run());
        this.myCustomRulesetTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                validate.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel$3", "textChanged"));
            }
        });
    }

    public void init() {
        PhpCSProjectConfiguration projectConfiguration = PhpCSProjectConfiguration.getInstance(this.myProject);
        PhpCSOptionsConfiguration optionsConfiguration = PhpCSOptionsConfiguration.getInstance(this.myProject);
        try {
            PhpCSConfiguration configuration = (PhpCSConfiguration)projectConfiguration.findSelectedConfiguration(this.myProject, false);
            if (configuration != null) {
                Object[] installedStandards;
                if (PhpCSOptionsPanel.standardsMatch(optionsConfiguration.getCodingStandard(), configuration.getStandards())) {
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(configuration.getStandards()));
                    if (!StringUtil.isEmpty((String)optionsConfiguration.getCodingStandard())) {
                        this.myStandardCombo.setSelectedItem(optionsConfiguration.getCodingStandard());
                    }
                }
                if ((installedStandards = PhpCSOptionsPanel.getInstalledStandards(this.myProject, configuration, this.getOptionsPanel(), optionsConfiguration.isUseInstalledPaths() ? optionsConfiguration.getInstalledPaths() : null)).length == 0) {
                    PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.phpcs.can.not.retrieve.standards", new Object[0]), MessageType.ERROR, this.myStandardCombo);
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{optionsConfiguration.getCodingStandard()}));
                    }
                    return;
                }
                installedStandards = (String[])ArrayUtil.append((Object[])installedStandards, (Object)"Custom");
                configuration.setStandards((String[])installedStandards);
                String currentStandard = (String)this.myStandardCombo.getSelectedItem();
                this.myStandardCombo.setModel(new DefaultComboBoxModel<Object>(installedStandards));
                this.myStandardCombo.setSelectedItem(PhpCSOptionsPanel.standardsMatch(currentStandard, (String[])installedStandards) ? currentStandard : installedStandards[0]);
                this.updated = true;
                PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.coding.stardards.has.been.updated", new Object[0]), MessageType.INFO, this.myStandardCombo);
            } else {
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{optionsConfiguration.getCodingStandard()}));
            }
        }
        catch (QualityToolValidationException e) {
            PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
            this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{optionsConfiguration.getCodingStandard()}));
        }
    }

    private void createUIComponents() {
    }

    private static boolean standardsMatch(String current, String[] collected) {
        return Arrays.asList(collected).contains(current);
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    @Override
    public void reset() {
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(this.myProject);
        this.myExtensionsTextField.setText(configuration.getExtensions());
        this.myShowSniffNamesBox.setSelected(configuration.isShowSniffs());
        this.myShowWarningsBox.setSelected(!configuration.isIgnoreWarnings());
        this.myUseInstalledPaths.setSelected(configuration.isUseInstalledPaths());
        this.myInstalledPathsTextField.setText(configuration.getInstalledPaths());
        this.myHighlightSeverityCombobox.setSelectedItem(ContainerUtil.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, i -> i.myName.equals(configuration.getHighlightLevel())));
        this.myStandardCombo.setSelectedItem(configuration.getCodingStandard());
        this.myCustomRulesetTextField.setText(configuration.getCustomRuleset());
    }

    @Override
    public boolean isModified() {
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(this.myProject);
        if (!StringUtil.equals((CharSequence)configuration.getExtensions(), (CharSequence)this.myExtensionsTextField.getText())) {
            return true;
        }
        if (this.myShowSniffNamesBox.isSelected() != configuration.isShowSniffs()) {
            return true;
        }
        if (this.myShowWarningsBox.isSelected() == configuration.isIgnoreWarnings()) {
            return true;
        }
        if (this.myUseInstalledPaths.isSelected() != configuration.isUseInstalledPaths()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myInstalledPathsTextField.getText(), (CharSequence)configuration.getInstalledPaths())) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)((String)this.myStandardCombo.getSelectedItem()), (CharSequence)configuration.getCodingStandard())) {
            return true;
        }
        if (this.myHighlightSeverityCombobox.getSelectedItem() != null && !((HighlightSeverity)this.myHighlightSeverityCombobox.getSelectedItem()).myName.equals(configuration.getHighlightLevel())) {
            return true;
        }
        return !StringUtil.equals((CharSequence)this.myCustomRulesetTextField.getText(), (CharSequence)configuration.getCustomRuleset());
    }

    @Override
    public void apply() {
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(this.myProject);
        configuration.setExtensions(this.myExtensionsTextField.getText());
        configuration.setShowSniffs(this.myShowSniffNamesBox.isSelected());
        configuration.setIgnoreWarnings(!this.myShowWarningsBox.isSelected());
        configuration.setUseInstalledPaths(this.myUseInstalledPaths.isSelected());
        configuration.setInstalledPaths(this.myInstalledPathsTextField.getText());
        configuration.setHighlightLevel(((HighlightSeverity)Objects.requireNonNull(this.myHighlightSeverityCombobox.getSelectedItem())).myName);
        configuration.setCodingStandard((String)this.myStandardCombo.getSelectedItem());
        configuration.setCustomRuleset(this.myCustomRulesetTextField.getText());
    }

    static String @NotNull [] getInstalledStandards(@Nullable Project project, @NotNull PhpCSConfiguration config, @Nullable JComponent component, @Nullable String installedPaths) {
        block9: {
            String[] stringArray;
            if (config == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(0);
            }
            String standardsPrefix = "The installed coding standards are";
            String title = PhpBundle.message("getting.installed.standards", new Object[0]);
            try {
                String[] stringArray2;
                if (installedPaths == null) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "-i";
                } else {
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = "--runtime-set";
                    stringArray4[1] = "installed_paths";
                    stringArray4[2] = installedPaths;
                    stringArray2 = stringArray4;
                    stringArray4[3] = "-i";
                }
                String[] params = stringArray2;
                ProcessOutput output = QualityToolProcessCreator.getToolOutput(project != null ? project : ProjectManager.getInstance().getDefaultProject(), config.getInterpreterId(), config.getToolPath(), config.getTimeout(), title, component, params);
                TreeSet<String> standards = new TreeSet<String>();
                Iterator iterator = output.getStdoutLines().iterator();
                if (!iterator.hasNext()) break block9;
                String line = (String)iterator.next();
                if (line.contains("The installed coding standards are")) {
                    String[] resultChunks;
                    line = line.replace("The installed coding standards are", "");
                    for (String resultChunk : resultChunks = line.split(",?\\s+")) {
                        String standardStr = resultChunk.trim();
                        if (standardStr.isEmpty() || "and".equals(standardStr)) continue;
                        standards.add(resultChunk.trim());
                    }
                }
                stringArray = ArrayUtilRt.toStringArray(standards);
            }
            catch (ExecutionException e) {
                LOG.warn("Failed getting installed standards for " + config.getToolPath(), (Throwable)e);
            }
            if (stringArray == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PhpCSOptionsPanel.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    @Nullable
    protected String validatePath() {
        if (Objects.equals(this.myStandardCombo.getSelectedItem(), "Custom")) {
            URL url;
            PhpInterpreter interpreter = this.getSelectedInterpreter(this.myProject, this.myComboBox);
            if (interpreter != null && interpreter.isRemote()) {
                return null;
            }
            if (this.myStandardCombo.getSelectedItem().equals("Custom") && ((url = VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)this.myCustomRulesetTextField.getText()))) == null || VfsUtil.findFileByURL((URL)url) == null)) {
                return PhpBundle.message("config.file.doesnt.exist", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void updateStandards() {
        ApplicationManager.getApplication().invokeLater(() -> this.init());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.label.coding.standard"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myStandardCombo = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel3.add(jComboBox, "Center");
        this.myCustomRulesetTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowWarningsBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.show.warning.as"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowSniffNamesBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.show.sniff.name"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseInstalledPaths = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.installed.standard.paths"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstalledPathsTextField = phpTextFieldWithSdkBasedBrowse = new PhpTextFieldWithSdkBasedBrowse();
        ((Component)((Object)phpTextFieldWithSdkBasedBrowse)).setEnabled(false);
        jPanel4.add((Component)((Object)phpTextFieldWithSdkBasedBrowse), new GridConstraints(3, 1, 1, 4, 0, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setAlignmentY(0.5f);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.label.check.files.with.extensions"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionsTextField = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myHighlightSeverityCombobox = jComboBox2;
        jPanel4.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledStandards";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledStandards";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

