/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurableProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolProjectConfiguration;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolsIgnoreFilesConfigurable;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class QualityToolProjectConfigurableForm
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private QualityToolConfigurationComboBox myConfigurationBox;
    private JLabel myWarningLabel;
    private ActionLink myShowIgnoredFilesActionLink;
    private JPanel myLinkPanel;
    private JBLabel myStatusLabel;
    private JPanel myOptionsPanel;
    private OnOffButton myInspectionOnOffButton;
    private QualityToolsOptionsPanel myQualityToolsOptionsPanel;
    private ActionListener myValidateConfigurationListener;
    final AncestorListener myAncestorListener;
    protected final Project myProject;

    public QualityToolProjectConfigurableForm(@NotNull Project project) {
        if (project == null) {
            QualityToolProjectConfigurableForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myProject.getMessageBus().connect().subscribe(PhpProjectWorkspaceConfiguration.TOPIC, () -> this.updateWarningLabel());
        this.myValidateConfigurationListener = e -> this.updateWarningLabel();
        this.myConfigurationBox.getComboBox().addActionListener(this.myValidateConfigurationListener);
        this.myWarningLabel.setVisible(false);
        this.myAncestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                QualityToolProjectConfigurableForm.this.updateWarningLabel();
                if (!QualityToolProjectConfigurableForm.this.myQualityToolsOptionsPanel.updated) {
                    QualityToolProjectConfigurableForm.this.myQualityToolsOptionsPanel.updateStandards();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        };
        this.myInspectionOnOffButton.setToolTipText(PhpBundle.message("the.button.shows.whether.inspection.is.on.or.off", new Object[0]));
        this.getComponent().addAncestorListener(this.myAncestorListener);
    }

    protected void updateSelectedConfiguration(@Nullable String newConfigurationId) {
        QualityToolProjectConfiguration projectConfiguration = this.getQualityToolType().getProjectConfiguration(this.myProject);
        if (newConfigurationId != null && !StringUtil.equals((CharSequence)newConfigurationId, (CharSequence)projectConfiguration.getSelectedConfigurationId())) {
            projectConfiguration.setSelectedConfigurationId(newConfigurationId);
        }
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.getQualityToolType().getDisplayName();
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName() + String.valueOf(this.getClass());
        if (string == null) {
            QualityToolProjectConfigurableForm.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected String getSavedSelectedConfigurationId() {
        return this.getQualityToolType().getProjectConfiguration(this.myProject).getSelectedConfigurationId();
    }

    @Nullable
    public String getHelpTopic() {
        return this.getQualityToolType().getHelpTopic();
    }

    @Nullable
    @NlsSafe
    private String validate(@Nullable String configuration) {
        try {
            this.getQualityToolType().getProjectConfiguration(this.myProject).findConfiguration(this.myProject, configuration);
            return this.myQualityToolsOptionsPanel.validatePath();
        }
        catch (QualityToolValidationException e) {
            return e.getMessage();
        }
    }

    protected void updateWarningLabel() {
        String warning = this.validate(this.myConfigurationBox.getSelectedItemId());
        if (warning != null) {
            this.myWarningLabel.setVisible(true);
            this.myWarningLabel.setText(warning);
            this.myStatusLabel.setVisible(true);
            this.myStatusLabel.setIcon(UIUtil.getBalloonErrorIcon());
        } else {
            this.myStatusLabel.setVisible(false);
            this.myWarningLabel.setVisible(false);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            QualityToolProjectConfigurableForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void apply() throws ConfigurationException {
        this.updateSelectedConfiguration(this.myConfigurationBox.getSelectedItemId());
        this.myQualityToolsOptionsPanel.apply();
        InspectionProfileImpl inspectionProfile = InspectionProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        inspectionProfile.setToolEnabled(this.getQualityToolType().getInspectionShortName(this.myProject), this.myInspectionOnOffButton.isSelected());
    }

    public boolean isModified() {
        if (!StringUtil.notNullize((String)this.myConfigurationBox.getSelectedItemId()).equals(this.getSavedSelectedConfigurationId())) {
            return true;
        }
        if (this.myQualityToolsOptionsPanel.isModified()) {
            return true;
        }
        InspectionProfileImpl inspectionProfile = InspectionProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        return this.myInspectionOnOffButton.isSelected() != inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)this.getQualityToolType().getInspectionShortName(this.myProject)));
    }

    public void reset() {
        this.myConfigurationBox.reset(this.myProject, this.getSavedSelectedConfigurationId());
        this.myQualityToolsOptionsPanel.reset();
        InspectionProfileImpl inspectionProfile = InspectionProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        this.myInspectionOnOffButton.setSelected(inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)this.getQualityToolType().getInspectionShortName(this.myProject))));
    }

    public void disposeUIResources() {
        if (this.myValidateConfigurationListener != null) {
            this.myConfigurationBox.getComboBox().removeActionListener(this.myValidateConfigurationListener);
            this.myValidateConfigurationListener = null;
        }
        Disposer.dispose((Disposable)this.myConfigurationBox);
        this.getComponent().removeAncestorListener(this.myAncestorListener);
    }

    private void createUIComponents() {
        this.myConfigurationBox = this.createConfigurationComboBox();
        this.myQualityToolsOptionsPanel = this.getQualityToolOptionPanel(this.myConfigurationBox, () -> this.updateWarningLabel());
        this.myOptionsPanel = this.myQualityToolsOptionsPanel.getOptionsPanel();
        this.myOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("border.title.options", new Object[0])));
        this.myShowIgnoredFilesActionLink = new ActionLink(PhpBundle.message("action.detect.composer.json.open", new Object[0]), e -> {
            if (this.myShowIgnoredFilesActionLink.isEnabled()) {
                ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new QualityToolsIgnoreFilesConfigurable(this.getQualityToolType(), this.myProject));
            }
        });
        this.myShowIgnoredFilesActionLink.setRolloverEnabled(false);
        this.myLinkPanel = PhpInspectionsUtil.createPanelWithSettingsLink(PhpBundle.message("quality.tool.settings.link.inspection", this.getDisplayName()), ErrorsConfigurable.class, project -> (ErrorsConfigurable)ConfigurableExtensionPointUtil.createProjectConfigurableForProvider((Project)project, ErrorsConfigurableProvider.class), configurable -> configurable.selectInspectionTool(this.getQualityToolType().getInspection().getShortName()));
    }

    protected QualityToolsOptionsPanel getQualityToolOptionPanel(QualityToolConfigurationComboBox configurationBox, Runnable validate) {
        return new QualityToolsOptionsPanel(this.myProject, validate, this.getQualityToolType());
    }

    @NotNull
    protected QualityToolConfigurationComboBox createConfigurationComboBox() {
        return new QualityToolConfigurationComboBox(this.myProject, this.getQualityToolType());
    }

    @NotNull
    protected abstract QualityToolType getQualityToolType();

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JLabel jLabel;
        OnOffButton onOffButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolProjectConfigurableForm.class).getString("quality.tool.label.configuration"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        QualityToolConfigurationComboBox qualityToolConfigurationComboBox = this.myConfigurationBox;
        jPanel3.add((Component)((Object)qualityToolConfigurationComboBox), new GridConstraints(0, 3, 1, 1, 0, 1, 3, 3, null, null, null));
        ActionLink actionLink = this.myShowIgnoredFilesActionLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolProjectConfigurableForm.class).getString("guality.tool.configuration.show.ignored.files"));
        jPanel3.add((Component)actionLink, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInspectionOnOffButton = onOffButton = new OnOffButton();
        onOffButton.setToolTipText(DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolProjectConfigurableForm.class).getString("quality.inspection.button.tooltip"));
        jPanel3.add((Component)onOffButton, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 3, null, null, null));
        JPanel jPanel4 = this.myLinkPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 4, 2, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolProjectConfigurableForm.class).getString("quality.tool.label.label"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStatusLabel = jBLabel = new JBLabel();
        jPanel8.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel9 = this.myOptionsPanel;
        jPanel2.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProjectConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProjectConfigurableForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

