/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolCustomSettings;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.ui.PhpConfigurableWithDescription;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurableForm<C extends QualityToolConfiguration>
implements PhpConfigurableWithDescription,
SearchableConfigurable {
    public static final int MIN_TIMEOUT = 1;
    public static final int MAX_TIMEOUT = 60;
    protected TextFieldWithBrowseButton myToolPathField;
    private JBLabel myErrorLabel;
    private JButton myValidateButton;
    private JPanel myTopPanel;
    private JBLabel myToolPathLabel;
    private final C myConfiguration;
    protected final Project myProject;
    protected final @NlsContexts.ConfigurableName String myToolName;
    protected final @NlsContexts.Label String myToolLauncher;
    @Nullable
    private final QualityToolCustomSettings myCustomConfigurable;
    private JPanel myCustomOptions;
    private JBIntSpinner myTimeoutSpinner;

    public QualityToolConfigurableForm(@NotNull Project project, C configuration) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(0);
        }
        this(project, configuration, ((QualityToolConfiguration)configuration).getPresentableName(project), "");
    }

    public QualityToolConfigurableForm(@NotNull Project project, C configuration, @NotNull @NlsSafe String toolName, @NlsSafe @NotNull String launcherName) {
        JComponent configurableComponent;
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(1);
        }
        if (toolName == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(2);
        }
        if (launcherName == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myToolName = toolName;
        this.myToolLauncher = launcherName;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.myToolPathField.setText(((QualityToolConfiguration)this.myConfiguration).getToolPath());
        this.myValidateButton.addActionListener(e -> this.validateConfiguration());
        this.myToolPathLabel.setText(PhpBundle.message("0.path", this.getToolName()));
        this.myCustomConfigurable = this.getCustomConfigurable(project, configuration);
        if (this.myCustomConfigurable != null && (configurableComponent = this.myCustomConfigurable.createComponent()) != null) {
            this.myCustomOptions.add((Component)configurableComponent, "North");
        }
        this.addBrowseFolderListener(this.myProject, this.myToolPathField);
        this.myErrorLabel.setAllowAutoWrapping(true);
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    @Override
    @Nls
    @Nullable
    public String getDescription() {
        return "";
    }

    public static void updateValidationLabel(@NotNull Pair<Boolean, String> info, JLabel errorLabel, JPanel panel) {
        if (info == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(4);
        }
        FontMetrics fontMetrics = errorLabel.getFontMetrics(errorLabel.getFont());
        @NlsSafe String[] s = UIUtil.splitText((String)(info.second == null ? "" : (String)info.second), (FontMetrics)fontMetrics, (int)(panel.getWidth() > 100 ? panel.getWidth() - 100 : 700), (char)' ');
        @NlsSafe String presentable = Arrays.stream(s).map(item -> item.trim()).filter(item -> !item.isEmpty()).collect(Collectors.joining("<br>"));
        errorLabel.setText(PhpUiUtil.surroundWithHtml(presentable));
        errorLabel.setIcon((Boolean)info.first != false ? UIUtil.getBalloonInformationIcon() : UIUtil.getBalloonErrorIcon());
        errorLabel.setVisible(true);
    }

    @Nullable
    public QualityToolCustomSettings getCustomConfigurable(@NotNull Project project, @NotNull C configuration) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(6);
        }
        return null;
    }

    public JComponent createComponent() {
        return this.myTopPanel;
    }

    protected void addBrowseFolderListener(@NotNull Project project, @NotNull TextFieldWithBrowseButton textField) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(7);
        }
        if (textField == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(8);
        }
        textField.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> this.isValidToolFile((VirtualFile)file)).withTitle(PhpBundle.message("0.location", this.getToolLauncherName())).withDescription(PhpBundle.message("choose.a.valid.0.launcher", this.getToolLauncherName())));
    }

    public boolean isModified() {
        return !((QualityToolConfiguration)this.myConfiguration).getToolPath().equals(this.myToolPathField.getText()) || ((QualityToolConfiguration)this.myConfiguration).getTimeout() != this.myTimeoutSpinner.getNumber() || this.myCustomConfigurable != null && this.myCustomConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        ((QualityToolConfiguration)this.myConfiguration).setToolPath(this.myToolPathField.getText());
        ((QualityToolConfiguration)this.myConfiguration).setTimeout(this.myTimeoutSpinner.getNumber() * 1000);
        if (this.myCustomConfigurable != null) {
            this.myCustomConfigurable.apply();
        }
    }

    public void reset() {
        this.myToolPathField.setText(((QualityToolConfiguration)this.myConfiguration).getToolPath());
        this.myTimeoutSpinner.setValue((Object)(((QualityToolConfiguration)this.myConfiguration).getTimeout() / 1000));
        if (this.myCustomConfigurable != null) {
            this.myCustomConfigurable.reset();
        }
    }

    @NotNull
    public C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(9);
        }
        return c;
    }

    private void createUIComponents() {
        this.myToolPathField = new TextFieldWithBrowseButton();
        this.myTimeoutSpinner = new JBIntSpinner(5, 1, 60);
    }

    public abstract QualityToolType<QualityToolConfiguration> getQualityToolType();

    private void validateConfiguration() {
        Pair<Boolean, String> mainValidate = this.validateConfiguration(this.myToolPathField.getText());
        if (!((Boolean)mainValidate.first).booleanValue()) {
            QualityToolConfigurableForm.updateValidationLabel(mainValidate, (JLabel)this.myErrorLabel, this.myTopPanel);
        }
        Pair<Boolean, String> customValidate = this.myCustomConfigurable != null ? this.myCustomConfigurable.validate() : null;
        QualityToolConfigurableForm.updateValidationLabel(customValidate == null || (Boolean)customValidate.first != false || StringUtil.isEmpty((String)((String)customValidate.second)) ? mainValidate : customValidate, (JLabel)this.myErrorLabel, this.myTopPanel);
    }

    @NotNull
    public Pair<Boolean, String> validateConfiguration(String toolPath, JPanel component) {
        Pair<Boolean, String> pair;
        String path = this.myToolPathField.getText();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            Pair pair2 = Pair.create((Object)false, (Object)PhpBundle.message("quality.tool.empty.path.phpcs", this.getToolLauncherName()));
            if (pair2 == null) {
                QualityToolConfigurableForm.$$$reportNull$$$0(10);
            }
            return pair2;
        }
        C configuration = this.getConfiguration();
        String id = ((QualityToolConfiguration)configuration).getInterpreterId();
        int timeout = ((QualityToolConfiguration)configuration).getTimeout();
        try {
            ProcessOutput output = QualityToolProcessCreator.getToolOutput(this.myProject, id, toolPath, timeout, PhpBundle.message("validating1", new Object[0]), component, this.validateWithNoAnsi() ? (String[])ArrayUtil.append((Object[])this.getVersionOptions(), (Object)"--no-ansi") : this.getVersionOptions());
            pair = this.validateToolResult(output.getStdout());
        }
        catch (ExecutionException e) {
            Pair pair3 = Pair.create((Object)false, (Object)e.getMessage());
            if (pair3 == null) {
                QualityToolConfigurableForm.$$$reportNull$$$0(12);
            }
            return pair3;
        }
        if (pair == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @NotNull
    public Pair<Boolean, String> validateConfiguration(String toolPath) {
        Pair<Boolean, String> pair = this.validateConfiguration(toolPath, this.myTopPanel);
        if (pair == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(13);
        }
        return pair;
    }

    protected String[] getVersionOptions() {
        return new String[]{"--version"};
    }

    @NotNull
    @NlsSafe
    public String getToolName() {
        String string = this.myToolName;
        if (string == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.myToolName;
    }

    @NotNull
    public String getId() {
        String string = this.myToolName + String.valueOf(QualityToolConfigurableForm.class);
        if (string == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    @NlsSafe
    public String getToolLauncherName() {
        String string = this.myToolLauncher;
        if (string == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public Pair<Boolean, String> validateToolResult(@Nullable String message) {
        Pair pair = StringUtil.isEmpty((String)message) ? new Pair((Object)false, (Object)("Can not run " + this.getToolName())) : this.validateMessage(message);
        if (pair == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(17);
        }
        return pair;
    }

    protected boolean validateWithNoAnsi() {
        return true;
    }

    @NotNull
    public abstract Pair<Boolean, String> validateMessage(String var1);

    public boolean isValidToolFile(VirtualFile file) {
        return file.getName().startsWith(this.myToolLauncher);
    }

    @Nullable
    protected static Version extractVersion(String versionString) {
        String[] chunks = versionString.split("\\.");
        int major = 0;
        int minor = 0;
        int nano = 0;
        try {
            if (chunks.length > 0) {
                major = Integer.parseInt(chunks[0]);
                if (chunks.length > 1) {
                    minor = Integer.parseInt(chunks[1]);
                    if (chunks.length > 2) {
                        nano = Integer.parseInt(chunks[2]);
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Version(major, minor, nano);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JButton jButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(5, 5, 5, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBIntSpinner jBIntSpinner = this.myTimeoutSpinner;
        jPanel4.add((Component)jBIntSpinner, new GridConstraints(0, 0, 1, 1, 8, 2, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolConfigurableForm.class).getString("quality.tool.label.tool.process.timeout"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myToolPathField;
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myValidateButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolConfigurableForm.class).getString("quality.tool.button.validate"));
        jPanel6.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myToolPathLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolConfigurableForm.class).getString("quality.tool.label.tool.path"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomOptions = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(6, 0, 1, 1, 2, 1, 1, 7, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", QualityToolConfigurableForm.class).getString("quality.tool.label.validation.label"));
        jBLabel.setVerticalAlignment(0);
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 7, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableForm";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "validateConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolLauncherName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "validateToolResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateValidationLabel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomConfigurable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

