/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkCollectorHelper {
    private static final EventLogGroup GROUP = new EventLogGroup("php.test.framework", 4);
    private static final StringEventField FRAMEWORK = EventFields.String((String)"framework", List.of("phpunit", "behat", "codeception", "phpspec", "pest"));
    private static final StringEventField LEVEL = EventFields.String((String)"level", List.of("ide", "project"));
    private static final EnumEventField<PhpUnitSettings.LoadMethod> CONFIG_TYPE = EventFields.Enum((String)"config_type", PhpUnitSettings.LoadMethod.class);
    private static final VarargEventId CONFIGURED_TEST_FRAMEWORK = GROUP.registerVarargEvent("configured.test.framework", new EventField[]{FRAMEWORK, EventFields.Version, LEVEL, CONFIG_TYPE});
    private static final PhpTestFrameworkCollectorHelper ourCollector = new PhpTestFrameworkCollectorHelper();

    @NotNull
    public Set<MetricEvent> collectUsages(@Nullable Project project) {
        PhpTestFrameworkSettingsManager manager = PhpTestFrameworkSettingsManager.getInstance(project);
        if (manager != null) {
            boolean isProjectLevel = project != null;
            Set<MetricEvent> frameworks = manager.getAllConfigurations().stream().filter(config -> config.isProjectLevel() == isProjectLevel).map(config -> this.toReportedData(project, (PhpTestFrameworkConfiguration)config)).filter(data -> data != null).collect(Collectors.toSet());
            if (!frameworks.isEmpty()) {
                Set<MetricEvent> set = frameworks;
                if (set == null) {
                    PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(0);
                }
                return set;
            }
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    protected MetricEvent toReportedData(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration config) {
        if (config == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(2);
        }
        String name = StringUtil.toLowerCase((String)config.getFrameworkType().getDisplayName());
        Version version = PhpTestFrameworkVersionCache.getCachedVersion(project, config);
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        data.add(FRAMEWORK.with((Object)name));
        data.add(EventFields.Version.with(version != null ? version.major + "." + version.minor : "unknown"));
        data.add(LEVEL.with((Object)(project == null ? "ide" : "project")));
        if (config instanceof PhpUnitSettings) {
            data.add(CONFIG_TYPE.with((Object)((PhpUnitSettings)config).getLoadMethod()));
        }
        return CONFIGURED_TEST_FRAMEWORK.metric(data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toReportedData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    public static final class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = ourCollector.collectUsages(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ApplicationUsageCollector", "getMetrics"));
        }
    }

    public static final class ProjectUsageCollector
    extends ProjectUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = ourCollector.collectUsages(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

