/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structureView;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.stubs.stub_factories.PhpVariableStubFactory;
import com.jetbrains.php.structureView.PhpAnonymousClassesNodeProvider;
import com.jetbrains.php.structureView.PhpConstantsFilter;
import com.jetbrains.php.structureView.PhpFieldsFilter;
import com.jetbrains.php.structureView.PhpIncludesFilter;
import com.jetbrains.php.structureView.PhpInheritedMembersNodeProvider;
import com.jetbrains.php.structureView.PhpLambdasNodeProvider;
import com.jetbrains.php.structureView.PhpMemberKindSorter;
import com.jetbrains.php.structureView.PhpMethodTypeGrouper;
import com.jetbrains.php.structureView.PhpNaturalOrderSorter;
import com.jetbrains.php.structureView.PhpPrivateMembersFilter;
import com.jetbrains.php.structureView.PhpProtectedMembersFilter;
import com.jetbrains.php.structureView.PhpStructureViewTreeElement;
import com.jetbrains.php.structureView.PhpVisibilitySorter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    private static final Collection<NodeProvider<?>> NODE_PROVIDERS = List.of(new PhpInheritedMembersNodeProvider(), new PhpAnonymousClassesNodeProvider(), new PhpLambdasNodeProvider());
    private final PhpFile mainFile;
    private final Class[] myClasses;
    private Filter[] myFilters = new Filter[]{new PhpIncludesFilter(), new PhpFieldsFilter(), new PhpConstantsFilter(), new PhpProtectedMembersFilter(), new PhpPrivateMembersFilter()};
    private Sorter[] mySorters = new Sorter[]{PhpMemberKindSorter.INSTANCE, PhpVisibilitySorter.INSTANCE, Sorter.ALPHA_SORTER, PhpNaturalOrderSorter.INSTANCE};
    private Grouper[] myGroupers = new Grouper[]{new PhpMethodTypeGrouper()};

    public PhpStructureViewModel(PhpFile mainFile, Editor editor, Class[] classes) {
        super(editor, (PsiFile)mainFile);
        this.mainFile = mainFile;
        this.myClasses = classes;
    }

    protected PsiFile getPsiFile() {
        return this.mainFile;
    }

    protected boolean isSuitable(PsiElement element) {
        return super.isSuitable(element) && (!(element instanceof VariableImpl) || ((VariableImpl)element).getGreenStub() != null || PhpVariableStubFactory.isApplicableForStub(element.getNode()));
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new PhpStructureViewTreeElement((PsiElement)this.mainFile);
    }

    @NotNull
    public Collection<NodeProvider<?>> getNodeProviders() {
        Collection<NodeProvider<?>> collection = NODE_PROVIDERS;
        if (collection == null) {
            PhpStructureViewModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public Sorter @NotNull [] getSorters() {
        if (this.mySorters == null) {
            PhpStructureViewModel.$$$reportNull$$$0(1);
        }
        return this.mySorters;
    }

    public void setSorters(Sorter[] sorters) {
        this.mySorters = sorters;
    }

    public Filter @NotNull [] getFilters() {
        if (this.myFilters == null) {
            PhpStructureViewModel.$$$reportNull$$$0(2);
        }
        return this.myFilters;
    }

    public void setFilters(Filter[] filters) {
        this.myFilters = filters;
    }

    public Grouper @NotNull [] getGroupers() {
        if (this.myGroupers == null) {
            PhpStructureViewModel.$$$reportNull$$$0(3);
        }
        return this.myGroupers;
    }

    public void setGroupers(Grouper[] groupers) {
        this.myGroupers = groupers;
    }

    protected Class @NotNull [] getSuitableClasses() {
        if (this.myClasses == null) {
            PhpStructureViewModel.$$$reportNull$$$0(4);
        }
        return this.myClasses;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof PhpClass || value instanceof PhpFile;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof Field;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        Object value;
        if (element == null) {
            PhpStructureViewModel.$$$reportNull$$$0(5);
        }
        return (value = element.getValue()) instanceof PhpFile || value instanceof PhpClass;
    }

    public boolean isSmartExpand() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/structureView/PhpStructureViewModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/structureView/PhpStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

