/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcore.resourceRoots.WebIdeProjectStructureWithSourceConfigurable;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.library.PhpEmbeddedStubsNotificationProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceInheritanceIndex;
import com.jetbrains.php.roots.PhpPsrNamespaceNotifier;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class PhpPsrNamespaceRootDetector {
    public static final int MIN_NAMESPACE_PREFIX = 1;

    private static void processNamespaces(@NotNull Project project, @NotNull PhpIndex index, @NotNull Collection<String> namespaceNames, @NotNull Set<? super String> processedDirectories, @NotNull String parentNamespaceName, @NotNull Set<? super PhpSourceRootTemplate> roots) {
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(0);
        }
        if (index == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(1);
        }
        if (namespaceNames == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(2);
        }
        if (processedDirectories == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(3);
        }
        if (parentNamespaceName == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(5);
        }
        for (String namespaceName : namespaceNames) {
            if (PhpLangUtil.equalsClassNames("___PHPSTORM_HELPERS", namespaceName)) continue;
            String namespaceFqn = parentNamespaceName + namespaceName;
            Collection namespaces = index.getNamespacesByName(namespaceFqn);
            if (!namespaces.isEmpty()) {
                for (PhpNamespace phpNamespace : namespaces) {
                    PsiDirectory directory;
                    String url;
                    VirtualFile root;
                    VirtualFile virtualFile;
                    PsiFile file = phpNamespace.getContainingFile();
                    if (!file.isValid() || !(file instanceof PhpFile) || PhpPsrNamespaceRootDetector.isFromVendorOrStubs(virtualFile = file.getVirtualFile()) || (root = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile)) != null || !processedDirectories.add(url = (directory = file.getContainingDirectory()).getVirtualFile().getUrl())) continue;
                    PhpPsrNamespaceRootDetector.tryToRegisterSourceRoot(project, (PhpFile)file, roots);
                }
            }
            if (!namespaceFqn.endsWith("\\")) {
                namespaceFqn = namespaceFqn + "\\";
            }
            Collection<String> childNamespaces = PhpPsrNamespaceRootDetector.getChildNamespacesByParentName(project, namespaceFqn);
            PhpPsrNamespaceRootDetector.processNamespaces(project, index, childNamespaces, processedDirectories, namespaceFqn, roots);
        }
    }

    private static void tryToRegisterSourceRoot(@NotNull Project project, @NotNull PhpFile file, @NotNull Set<? super PhpSourceRootTemplate> roots) {
        PhpSourceRootTemplate root;
        String fqn;
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(7);
        }
        if (roots == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(8);
        }
        Collection topLevelDefs = file.getTopLevelDefs().values();
        List namespaces = ContainerUtil.filterIsInstance((Collection)topLevelDefs, PhpNamespace.class);
        PhpClass clazz = (PhpClass)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filterIsInstance((Collection)topLevelDefs, PhpClass.class));
        String fileName = FileUtilRt.getNameWithoutExtension((String)file.getName());
        if (namespaces.size() == 1 && clazz != null && PhpLangUtil.equalsClassNames(fileName, clazz.getNameCS()) && StringUtil.isNotEmpty((String)(fqn = ((PhpNamespace)namespaces.get(0)).getFQN())) && (root = PhpPsrNamespaceRootDetector.detectPsrRoot(project, file, fqn)) != null) {
            roots.add(root);
        }
    }

    @Nullable
    public static PhpSourceRootTemplate detectPsrRoot(@NotNull Project project, @NotNull PhpFile file, @NotNull String namespace) {
        boolean isShortPrefix;
        PsiDirectory currentDir;
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(10);
        }
        if (namespace == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(11);
        }
        List namespaceNames = StringUtil.split((String)namespace, (String)"\\");
        int index = namespaceNames.size() - 1;
        PsiDirectory prevDir = null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (currentDir = file.getContainingDirectory(); currentDir != null && index >= 0 && fileIndex.isInContent(currentDir.getVirtualFile()) && PhpLangUtil.equalsClassNames(currentDir.getName(), (CharSequence)namespaceNames.get(index)); --index, currentDir = currentDir.getParentDirectory()) {
            prevDir = currentDir;
        }
        PsiDirectory root = currentDir == null ? prevDir : currentDir;
        boolean bl = isShortPrefix = index < Math.min(1, namespaceNames.size() - 1) || index == 0;
        if (root != null && isShortPrefix && fileIndex.isInContent(root.getVirtualFile())) {
            String prefix = index < 0 ? "" : StringUtil.join(namespaceNames.subList(0, index + 1), (String)"\\");
            String path = root.getVirtualFile().getPath();
            String name = PathUtil.getFileName((String)path);
            boolean isTest = StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"test") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"tests");
            return PhpSourceRootTemplate.psr4(path, prefix, isTest);
        }
        return null;
    }

    private static void addSourceRoot(@NotNull Project project, @NotNull PhpSourceRootTemplate root, @NotNull String prefix) {
        Module module;
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(12);
        }
        if (root == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(13);
        }
        if (prefix == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(14);
        }
        if ((module = ModuleAttachProcessor.getPrimaryModule((Project)project)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ContentEntry[] contentEntries;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
                    VirtualFile file = contentEntry.getFile();
                    if (file == null || !FileUtil.isAncestor((String)file.getPath(), (String)root.getSourcePath(), (boolean)false)) continue;
                    JavaSourceRootType rootType = root.isTest() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
                    JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(prefix);
                    contentEntry.addSourceFolder(root.getSourceUrl(), (JpsModuleSourceRootType)rootType, (JpsElement)properties, false);
                    break;
                }
                model.commit();
            });
        }
    }

    public static void addSourceRoots(@NotNull ModifiableRootModel model, @NotNull Collection<? extends PhpSourceRootTemplate> rootInfos) {
        ContentEntry[] contentEntries;
        if (model == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(15);
        }
        if (rootInfos == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(16);
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            ArrayList<PhpSourceRootTemplate> addedRoots = new ArrayList<PhpSourceRootTemplate>();
            for (PhpSourceRootTemplate phpSourceRootTemplate : rootInfos) {
                if (!FileUtil.isAncestor((String)file.getPath(), (String)phpSourceRootTemplate.getSourcePath(), (boolean)false)) continue;
                JavaSourceRootType rootType = phpSourceRootTemplate.isTest() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
                JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(phpSourceRootTemplate.getPrefix());
                contentEntry.addSourceFolder(phpSourceRootTemplate.getSourceUrl(), (JpsModuleSourceRootType)rootType, (JpsElement)properties, true);
                addedRoots.add(phpSourceRootTemplate);
            }
            rootInfos.removeAll(addedRoots);
        }
    }

    public static void detectNewRootDirectory(final @NotNull Project project, @NotNull PhpFile file, @Nullable String namespace) {
        PhpSourceRootTemplate newRoot;
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(17);
        }
        if (file == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty((String)namespace)) {
            return;
        }
        VirtualFile root = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file.getVirtualFile());
        if (root == null && (newRoot = PhpPsrNamespaceRootDetector.detectPsrRoot(project, file, namespace)) != null) {
            String pathToRoot = newRoot.getSourcePath();
            final String prefix = newRoot.getPrefix();
            if (StringUtil.equalsIgnoreCase((CharSequence)prefix, (CharSequence)namespace)) {
                return;
            }
            String psrRoot = StringUtil.isEmpty((String)prefix) ? "PSR-0" : "PSR-4";
            String title = PhpBundle.message("actions.mark.directory.as.psr.0.root.title", psrRoot);
            String message = StringUtil.isEmpty((String)prefix) ? PhpBundle.message("actions.mark.directory.as.psr.0.root", pathToRoot) : PhpBundle.message("actions.mark.directory.as.psr.0.root.with.prefix", pathToRoot, prefix);
            String actionText = PhpBundle.message("actions.mark.directory.as.psr.0.root.mark.psr", psrRoot);
            NotificationAction action = new NotificationAction(actionText){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PhpPsrNamespaceRootDetector.addSourceRoot(project, newRoot, prefix);
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/roots/PhpPsrNamespaceRootDetector$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PhpPsrNamespaceNotifier.showNotification(project, title, message, action);
        }
    }

    public static boolean detectNamespaceRoots(Project project) {
        Module[] modules;
        HashSet<PhpSourceRootTemplate> roots = new HashSet<PhpSourceRootTemplate>();
        Runnable runnable = () -> ApplicationManager.getApplication().runReadAction(() -> roots.addAll(PhpPsrNamespaceRootDetector.findSourceRoots(project)));
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, PhpBundle.message("actions.detect.namespace.roots.progress.title", new Object[0]), true, project);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        roots.removeIf(info -> StringUtil.equals((CharSequence)info.getSourcePath(), (CharSequence)project.getBasePath()));
        if (roots.isEmpty()) {
            return false;
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ContentEntry[] contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries();
            if (contentEntries.length <= 0) continue;
            roots.stream().filter(info -> PhpPsrNamespaceRootDetector.isInContent(contentEntries, info)).findAny().ifPresent(info -> {
                WebIdeProjectStructureWithSourceConfigurable configurable = new WebIdeProjectStructureWithSourceConfigurable(module);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
                    PhpPsrNamespaceRootDetector.addSourceRoots(configurable.getModifiableModel(), (Collection<? extends PhpSourceRootTemplate>)roots);
                    configurable.repaint();
                });
            });
            if (!roots.isEmpty()) continue;
            return true;
        }
        return true;
    }

    @NotNull
    public static Set<PhpSourceRootTemplate> findSourceRoots(@NotNull Project project) {
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(19);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        Collection<String> namespaces = PhpPsrNamespaceRootDetector.getChildNamespacesByParentName(project, "\\");
        HashSet<PhpSourceRootTemplate> roots = new HashSet<PhpSourceRootTemplate>();
        PhpPsrNamespaceRootDetector.processNamespaces(project, index, namespaces, new HashSet(), "\\", roots);
        HashSet<PhpSourceRootTemplate> hashSet = roots;
        if (hashSet == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    private static Collection<String> getChildNamespacesByParentName(@NotNull Project project, @NotNull String parentName) {
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(21);
        }
        if (parentName == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(22);
        }
        if (parentName.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> childNamespaces = new HashSet<String>();
        FileBasedIndex.getInstance().processValues(PhpNamespaceInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)parentName), null, (vFile, values) -> {
            if (!PhpPsrNamespaceRootDetector.isFromVendorOrStubs(vFile)) {
                childNamespaces.addAll((Collection<String>)values);
            }
            return true;
        }, GlobalSearchScope.projectScope((Project)project));
        return childNamespaces;
    }

    private static boolean isFromVendorOrStubs(VirtualFile vFile) {
        return vFile.getPath().contains("vendor") || PhpEmbeddedStubsNotificationProvider.isStubsFile(vFile);
    }

    public static void addSourceRoots(@NotNull Project project, @NotNull Collection<? extends PhpSourceRootTemplate> roots) {
        if (project == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(23);
        }
        if (roots == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(24);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            PhpPsrNamespaceRootDetector.addSourceRoots(module, roots);
        }
    }

    public static void addSourceRoots(@NotNull Module module, @NotNull Collection<? extends PhpSourceRootTemplate> roots) {
        ContentEntry[] contentEntries;
        if (module == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(25);
        }
        if (roots == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(26);
        }
        if ((contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()).length == 0) {
            return;
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        roots.stream().filter(info -> PhpPsrNamespaceRootDetector.isInContent(contentEntries, info)).findAny().ifPresent(info -> PhpPsrNamespaceRootDetector.addSourceRoots(modifiableModel, roots));
        ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
    }

    static boolean isInContent(ContentEntry @NotNull [] contentEntries, @NotNull PhpSourceRootTemplate info) {
        if (info == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(27);
        }
        if (contentEntries == null) {
            PhpPsrNamespaceRootDetector.$$$reportNull$$$0(28);
        }
        for (ContentEntry entry : contentEntries) {
            VirtualFile file = entry.getFile();
            if (file == null || !FileUtil.isAncestor((String)file.getPath(), (String)info.getSourcePath(), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedDirectories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNamespaceName";
                break;
            }
            case 5: 
            case 8: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootInfos";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpPsrNamespaceRootDetector";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpPsrNamespaceRootDetector";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaces";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryToRegisterSourceRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectPsrRoot";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "detectNewRootDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSourceRoots";
                break;
            }
            case 20: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildNamespacesByParentName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20 -> new IllegalStateException(string);
        };
    }
}

