/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodConflictDetector
implements PhpNameConflictDetector {
    private final PhpClass myClass;
    private final Method myOldMethod;

    public PhpMethodConflictDetector(@NotNull Method oldMethod) {
        if (oldMethod == null) {
            PhpMethodConflictDetector.$$$reportNull$$$0(0);
        }
        this.myClass = oldMethod.getContainingClass();
        this.myOldMethod = oldMethod;
    }

    public PhpMethodConflictDetector(@Nullable PhpClass clazz) {
        this.myClass = clazz;
        this.myOldMethod = null;
    }

    @Override
    @NlsContexts.DialogMessage
    public String findConflicts(@NotNull String newName) {
        Method methodByName;
        if (newName == null) {
            PhpMethodConflictDetector.$$$reportNull$$$0(1);
        }
        if (!PhpNameUtil.isValidMethodName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        Method method = methodByName = this.myClass == null ? null : this.myClass.findOwnMethodByName((CharSequence)newName);
        if (methodByName != null && methodByName != this.myOldMethod) {
            return PhpBundle.message("conflict.method.with.same.name.already.exists", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/validation/PhpMethodConflictDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

