/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.inplace.PhpVariableInplaceRenamer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpVariableRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof Variable;
    }

    @NotNull
    public RenameDialog createRenameDialog(final @NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(2);
        }
        PsiElement at = editor != null ? element.getContainingFile().findElementAt(editor.getCaretModel().getOffset()) : null;
        Variable variableAt = PhpPsiUtil.getParentOfClass(at, false, Variable.class);
        final SmartPsiElementPointer variableAtPtr = variableAt != null ? SmartPointerManager.createPointer((PsiElement)variableAt) : null;
        @Nullable PsiElement closestScope = PhpVariableInplaceRenamer.findNearestScopeWithDefiningVariable(PhpPsiUtil.getParentOfClass((PsiElement)variableAt, false, Variable.class));
        final SmartPsiElementPointer closestScopePtr = closestScope != null ? SmartPointerManager.createPointer((PsiElement)closestScope) : null;
        return new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchInNearestScope;

            protected void dispose() {
                SmartPointerManager instance = SmartPointerManager.getInstance((Project)project);
                if (variableAtPtr != null) {
                    instance.removePointer(variableAtPtr);
                }
                if (closestScopePtr != null) {
                    instance.removePointer(closestScopePtr);
                }
                super.dispose();
            }

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel, gbConstraints);
                if (closestScopePtr != null && closestScopePtr.getElement() != null) {
                    this.myCbSearchInNearestScope = new NonFocusableCheckBox(PhpBundle.message("checkbox.rename.only.nearest.scope", new Object[0]));
                    this.myCbSearchInNearestScope.setSelected(false);
                    panel.add((Component)this.myCbSearchInNearestScope, gbConstraints);
                }
            }

            protected void doAction() {
                if (closestScopePtr != null && closestScopePtr.getElement() != null) {
                    PhpRefactoringSettings.getInstance().RENAME_SEARCH_VARIABLE_IN_CLOSEST_SCOPE = this.myCbSearchInNearestScope.isSelected();
                }
                super.doAction();
            }

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                PsiElement closestScope;
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                newName = StringUtil.trimStart((String)newName, (String)"$");
                Variable variableAt = variableAtPtr != null ? (Variable)variableAtPtr.getElement() : null;
                PsiElement psiElement = closestScope = closestScopePtr != null ? closestScopePtr.getElement() : null;
                if (!PhpRefactoringSettings.getInstance().RENAME_SEARCH_VARIABLE_IN_CLOSEST_SCOPE || variableAt == null || closestScope == null) {
                    return super.createRenameProcessor(newName);
                }
                return new RenameProcessor(this.getProject(), (PsiElement)variableAt, newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    public UsageInfo @NotNull [] findUsages() {
                        UsageInfo[] usageInfoArray = this.filterUsagesInNearestScope(super.findUsages());
                        if (usageInfoArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return usageInfoArray;
                    }

                    private UsageInfo[] filterUsagesInNearestScope(UsageInfo[] usages) {
                        return ContainerUtil.filter((Object[])usages, u -> {
                            PsiElement e = u.getElement();
                            return e != null && PsiTreeUtil.isAncestor((PsiElement)closestScope, (PsiElement)e, (boolean)false);
                        }).toArray(UsageInfo.EMPTY_ARRAY);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/rename/PhpVariableRenameProcessor$1$1", "findUsages"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/php/refactoring/rename/PhpVariableRenameProcessor$1", "createRenameProcessor"));
            }
        };
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(4);
        }
        if (conflicts == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(5);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(element, true, null);
        for (PhpNamedElement phpNamedElement : declarations) {
            if (!newName.equals(phpNamedElement.getName())) continue;
            conflicts.putValue((Object)phpNamedElement, (Object)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]));
            break;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(6);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_VARIABLE;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(7);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(8);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_VARIABLE = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpVariableRenameProcessor.$$$reportNull$$$0(9);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpVariableRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

