/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParameterRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof Parameter;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(1);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_PARAMETER;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(2);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(3);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_PARAMETER = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(4);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER = enabled;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(7);
        }
        PhpParameterRenameProcessor.findExistingParameterNamesConflicts(element, newName, conflicts);
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(element, true, null);
        for (PhpNamedElement phpNamedElement : declarations) {
            if (!newName.equals(phpNamedElement.getName()) || phpNamedElement instanceof Parameter) continue;
            conflicts.putValue((Object)phpNamedElement, (Object)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]));
            break;
        }
    }

    static void findExistingParameterNamesConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiElement[] parameters;
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(10);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof ParameterList);
        for (PsiElement parameter : parameters = ((ParameterList)parent).getParameters()) {
            assert (parameter instanceof Parameter);
            if (parameter == element || !PhpLangUtil.equalsParameterNames(newName, ((Parameter)parameter).getName())) continue;
            conflicts.putValue((Object)parameter, (Object)PhpBundle.message("conflict.parameter.with.same.name.already.exists", new Object[0]));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(12);
        }
        Collection references = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        if (!PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(element.getProject())) {
            Collection collection = references;
            if (collection == null) {
                PhpParameterRenameProcessor.$$$reportNull$$$0(13);
            }
            return collection;
        }
        List<PsiReference> referenceFromNamedArguments = PhpParameterRenameProcessor.findReferencesFromNamedArguments(element);
        Set set = ContainerUtil.union((Collection)references, referenceFromNamedArguments);
        if (set == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    static @NotNull List<@NotNull PsiReference> findReferencesFromNamedArguments(@NotNull PsiElement element) {
        Function parentFunction;
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(15);
        }
        if ((parentFunction = PhpPsiUtil.getParentOfClass(element, Function.class)) != null) {
            PhpRenameSearchParameters searchParams = new PhpRenameSearchParameters((PsiElement)parentFunction, (SearchScope)GlobalSearchScope.allScope((Project)element.getProject()));
            List list = (List)((StreamEx)StreamEx.of((Collection)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParams).findAll()).map(PhpParameterRenameProcessor::extractParameterListOwner).nonNull().map(owner -> owner.getParameterList()).nonNull().flatMap(e -> Arrays.stream(e.getReferences())).filter(r -> r.isReferenceTo(element))).collect(Collectors.toList());
            if (list == null) {
                PhpParameterRenameProcessor.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<PsiReference> list = Collections.emptyList();
        if (list == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static ParameterListOwner extractParameterListOwner(PsiReference reference) {
        if (reference instanceof ParameterListOwner) {
            return (ParameterListOwner)reference;
        }
        if (reference instanceof ClassReference) {
            return (ParameterListOwner)ObjectUtils.tryCast((Object)((ClassReference)reference).getParent(), NewExpression.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/PhpParameterRenameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpParameterRenameProcessor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesFromNamedArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findExistingParameterNamesConflicts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesFromNamedArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 16, 17 -> new IllegalStateException(string);
        };
    }
}

