/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.ui.components.JBCheckBox;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpDependencyMemberInfoModel;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseDialog;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpClassCellRenderer;
import com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpProcessor;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPullUpDialog
extends PhpPullPushBaseDialog {
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.pullPush.pullUp.PhpPullUpDialog#";
    private JComboBox myClassCombo;
    private JBCheckBox myAddMethodsImplementation;
    @NotNull
    private final Collection<PhpClass> mySuperClasses;
    private final PhpMemberInfoStorage myStorage;
    @Nullable
    protected PhpMemberSelectionPanel myMemberSelectionPanel;
    protected PhpClass myClass;
    private final String myDimensionServiceKey;
    private final boolean myContainSuperInterfaces;

    public PhpPullUpDialog(@NotNull Project project, PhpClass clazz, @NotNull Collection<PhpClass> superClasses, PhpMemberInfoStorage storage) {
        if (project == null) {
            PhpPullUpDialog.$$$reportNull$$$0(0);
        }
        if (superClasses == null) {
            PhpPullUpDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myClass = clazz;
        this.myStorage = storage;
        this.mySuperClasses = new TreeSet<PhpClass>((o1, o2) -> {
            String name1 = o1.getFQN();
            String name2 = o2.getFQN();
            return name1.compareTo(name2);
        });
        this.mySuperClasses.addAll(superClasses);
        this.myMemberInfos = this.myStorage.getClassMemberInfos((PsiElement)clazz);
        this.myContainSuperInterfaces = PhpPullUpDialog.containInterfaces(superClasses);
        this.myDimensionServiceKey = DIMENSION_SERVICE_KEY_BASE + (this.myContainSuperInterfaces ? "0" : "1");
        this.setTitle(RefactoringBundle.message((String)"pull.members.up.title"));
        this.init();
    }

    private static boolean containInterfaces(@NotNull Collection<PhpClass> superClasses) {
        if (superClasses == null) {
            PhpPullUpDialog.$$$reportNull$$$0(2);
        }
        for (PhpClass clazz : superClasses) {
            if (!clazz.isInterface()) continue;
            return true;
        }
        return false;
    }

    protected void doAction() {
        PhpClass targetClass = this.getSuperClass();
        PhpPullUpProcessor processor2 = new PhpPullUpProcessor(this.getProject(), this.myClass, targetClass, this.addMethodImplementation(targetClass), this.getSelectedMemberInfos());
        this.invokeRefactoring(processor2);
    }

    private boolean addMethodImplementation(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpPullUpDialog.$$$reportNull$$$0(3);
        }
        return clazz.isInterface() && this.myAddMethodsImplementation.isSelected();
    }

    protected void configureClassComboSelection() {
        for (PhpClass clazz : this.mySuperClasses) {
            if (clazz.isInterface()) continue;
            this.myClassCombo.setSelectedItem(clazz);
            return;
        }
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        this.configureClassComboSelection();
        this.myClassCombo.setRenderer(new PhpClassCellRenderer());
        String fqn = this.myClass.getFQN();
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{fqn}));
        classComboLabel.setLabelFor(this.myClassCombo);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getStateChange() == 1) {
                    if (PhpPullUpDialog.this.myMemberSelectionPanel != null) {
                        ((PhpDependencyMemberInfoModel)PhpPullUpDialog.this.myMemberInfoModel).setSuperClass((PsiElement)PhpPullUpDialog.this.getSuperClass());
                        PhpPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(PhpPullUpDialog.this.myMemberInfos);
                        PhpPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                    PhpPullUpDialog.this.myAddMethodsImplementation.setEnabled(PhpPullUpDialog.this.getSuperClass().isInterface());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpDialog$1", "itemStateChanged"));
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.myClassCombo, gbConstraints);
        JPanel northPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 2, 1, true, true));
        this.myAddMethodsImplementation = new JBCheckBox(PhpBundle.message("refactoring.pull.up.implement.method", new Object[0]), true);
        this.myAddMethodsImplementation.setEnabled(this.getSuperClass().isInterface());
        this.myAddMethodsImplementation.setVisible(this.myContainSuperInterfaces);
        northPanel.add(panel);
        northPanel.add((Component)this.myAddMethodsImplementation);
        return northPanel;
    }

    @NotNull
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> createMemberInfoModel() {
        return new PhpDependencyMemberInfoModel(this.myClass);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new PhpMemberSelectionPanel(this.getMembersBorderTitle(), this.myMemberInfos, null);
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)this.myMemberSelectionPanel, "Center");
        return panel;
    }

    @NotNull
    public PhpClass getSuperClass() {
        PhpClass phpClass = (PhpClass)this.myClassCombo.getSelectedItem();
        if (phpClass == null) {
            PhpPullUpDialog.$$$reportNull$$$0(4);
        }
        return phpClass;
    }

    protected ValidationInfo doValidate() {
        PhpClass clazz = this.getSuperClass();
        boolean isInterface = clazz.isInterface();
        Collection<PhpMemberInfo> memberInfos = this.getSelectedMemberInfos();
        for (PhpMemberInfo memberInfo : memberInfos) {
            PhpClassMember member = (PhpClassMember)memberInfo.getMember();
            if (isInterface && member instanceof Field && !((Field)member).isConstant()) {
                return new ValidationInfo(PhpBundle.message("refactoring.pull.up.validation.field.into.interface", new Object[0]));
            }
            PhpModifier modifier = member.getModifier();
            PhpModifier.Access access = modifier.getAccess();
            if (access.isPrivate() || isInterface && access.isProtected()) {
                return new ValidationInfo(PhpBundle.message("refactoring.pull.up.private.access", StringUtil.capitalize((String)access.toString()), isInterface ? "public" : "protected"));
            }
            if (clazz.isAbstract() || !modifier.isAbstract()) continue;
            return new ValidationInfo(PhpBundle.message("refactoring.pull.up.abstract.method", clazz.getName()));
        }
        return super.doValidate();
    }

    @Nls
    protected String getMembersBorderTitle() {
        return RefactoringBundle.message((String)"members.to.be.pulled.up");
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.pullMembersUp";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containInterfaces";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMethodImplementation";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

