/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticHandler;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodToPredefinedTargetClassDialog;
import com.jetbrains.php.refactoring.move.member.instance.makeStaticThenMove.PhpMoveInstanceMethodDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpMoveInstanceMethodHandler
implements RefactoringActionHandler {
    public static final String MOVE_INSTANCE_METHOD_ID = "move.instance.method";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        assert (element instanceof Method);
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Method method;
        String error;
        if (project == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(2);
        }
        if ((error = PhpMoveInstanceMethodHandler.checkMethod(method = (Method)elements[0])) != null) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error, (String)PhpMoveInstanceMethodHandler.getRefactoringName(), null);
            return;
        }
        PhpMoveInstanceMethodHandler.showDialog(method);
    }

    public static void showDialog(@NotNull Method method) {
        boolean hasNoReferences;
        if (method == null) {
            PhpMoveInstanceMethodHandler.$$$reportNull$$$0(3);
        }
        boolean bl = hasNoReferences = !ReferencesSearch.search((PsiElement)method).anyMatch(ref -> ref instanceof MemberReference || ref instanceof PhpCallbackReferenceBase);
        if (hasNoReferences) {
            new PhpMoveInstanceMethodDialog(method, false).show();
            return;
        }
        List<PhpNamedElement> suitableVariables = PhpMoveInstanceMethodHandler.getParametersAndFieldsCandidate(method);
        if (!suitableVariables.isEmpty()) {
            new PhpMoveInstanceMethodToPredefinedTargetClassDialog(method, suitableVariables, true).show();
        } else if (PhpMakeStaticHandler.validateTarget(method) == null) {
            new PhpMoveInstanceMethodDialog(method, true).show();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NlsContexts.DialogMessage
    private static String checkMethod(Method method) {
        @NlsContexts.DialogMessage Ref error = new Ref();
        if (method instanceof PhpDocMethod) {
            return PhpBundle.message("refactoring.make.method.static.doc.method.is.not.supported", new Object[0]);
        }
        if (PhpRefactoringUtil.isConstructor(method)) {
            error.set((Object)PhpBundle.message("refactoring.move.method.cannot.move.constructor", new Object[0]));
        } else if (PhpLangUtil.isMagicMethod(method.getName())) {
            error.set((Object)PhpBundle.message("refactoring.move.method.cannot.move.magic.method", new Object[0]));
        }
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (member, subClass, baseClass) -> {
            error.set((Object)RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy"));
            return false;
        });
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (member, subClass, baseClass) -> {
            error.set((Object)RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy"));
            return false;
        });
        return (String)error.get();
    }

    private static boolean isSuitableType(Project project, PhpNamedElement element) {
        if (element instanceof Parameter && ((Parameter)element).isVariadic()) {
            return false;
        }
        PhpType type = element.getType();
        if (type.getTypes().size() != 1) {
            return false;
        }
        List stream = ContainerUtil.filter((Collection)type.getTypes(), e -> {
            if (PhpType.isNull((String)e) || PhpType.isMixedType((String)e) || PhpType.isCallableType((String)e)) {
                return false;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (!PhpType.isPrimitiveType((String)e) && !PhpType.isObject((String)StringUtil.toLowerCase((String)e))) {
                Collection classesByFQN = PhpIndex.getInstance((Project)project).getClassesByFQN(e);
                if (classesByFQN.size() == 1) {
                    PhpClass phpClass = (PhpClass)classesByFQN.iterator().next();
                    VirtualFile virtualFile = phpClass.getContainingFile().getVirtualFile();
                    return index.isInContent(virtualFile);
                }
                return !classesByFQN.isEmpty();
            }
            return false;
        });
        return !stream.isEmpty();
    }

    public static List<PhpNamedElement> getParametersAndFieldsCandidate(Method method) {
        List<Object> toReturn = new ArrayList<Parameter>(Arrays.asList(method.getParameters()));
        PhpClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            toReturn.addAll(ContainerUtil.filter((Collection)containingClass.getFields(), e -> !e.getModifier().isPrivate() || e.getContainingClass() == method.getContainingClass()));
        }
        toReturn = ContainerUtil.filter(toReturn, e -> PhpMoveInstanceMethodHandler.isSuitableType(method.getProject(), e));
        return toReturn;
    }

    @NlsContexts.DialogTitle
    static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.instance.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

