/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDelegate;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassProcessor;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveClassDialog
extends RefactoringDialog {
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.move.PhpMoveClassDialog#";
    private final PhpPsrNamespacePanel myDirectoryChoosePanel;
    private final JCheckBox myExtractClassIntoSeparateFile;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private final PhpClass myClass;
    private final boolean myIsScopeContainsMultipleClasses;
    private final String myDimensionServiceKey;

    protected PhpMoveClassDialog(@NotNull Project project, @NotNull PhpClass clazz, boolean canBeParent) {
        if (project == null) {
            PhpMoveClassDialog.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            PhpMoveClassDialog.$$$reportNull$$$0(1);
        }
        super(project, canBeParent);
        this.myClass = clazz;
        this.myIsScopeContainsMultipleClasses = PhpMoveClassDialog.isScopeHolderContainsMultipleClasses(clazz);
        this.myDimensionServiceKey = DIMENSION_SERVICE_KEY_BASE + (this.myIsScopeContainsMultipleClasses ? "0" : "1");
        this.setTitle(PhpMoveClassDelegate.getRefactoringNameText());
        this.myExtractClassIntoSeparateFile = new NonFocusableCheckBox(PhpBundle.message("refactoring.move.class.new.file", new Object[0]));
        this.myDirectoryChoosePanel = new PhpPsrNamespacePanel(this.myProject, this.myClass.getNamespaceName(), (PsiFileSystemItem)this.myClass.getContainingFile(), JBUI.insets((int)2)){

            @Override
            public void customizePanel() {
                if (PhpMoveClassDialog.this.myIsScopeContainsMultipleClasses) {
                    PhpMoveClassDialog.this.myExtractClassIntoSeparateFile.setSelected(true);
                    PhpMoveClassDialog.this.myExtractClassIntoSeparateFile.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            myDirectoryField.setEnabled(PhpMoveClassDialog.this.myExtractClassIntoSeparateFile.isSelected());
                        }
                    });
                    this.myDirectoryPanel.add((Component)PhpMoveClassDialog.this.myExtractClassIntoSeparateFile, "North");
                }
            }

            @Override
            @NotNull
            @Nls
            public String getNamespaceLabelText() {
                String string = PhpBundle.message("refactoring.move.class.title", PhpMoveClassDialog.this.myClass.getName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDialog$1", "getNamespaceLabelText"));
            }
        };
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDirectoryChoosePanel);
        this.init();
    }

    public static boolean isScopeHolderContainsMultipleClasses(@NotNull PhpClass clazz) {
        PhpPsiElement scopeHolder;
        GroupStatement groupStatement;
        PhpPsiElement child;
        if (clazz == null) {
            PhpMoveClassDialog.$$$reportNull$$$0(2);
        }
        PhpPsiElement phpPsiElement = child = (groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)(scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)clazz)), GroupStatement.class)) == null ? null : groupStatement.getFirstPsiChild();
        while (child != null) {
            if (child != clazz && (child instanceof PhpClass || child instanceof Function)) {
                return true;
            }
            child = child.getNextPsiSibling();
        }
        return false;
    }

    protected void doAction() {
        this.rememberSettings();
        String newNamespaceName = PhpLangUtil.toPresentableFQN(this.myDirectoryChoosePanel.getNamespaceName());
        if (this.myIsScopeContainsMultipleClasses && !this.myExtractClassIntoSeparateFile.isSelected() && PhpLangUtil.equalsNamespaceNames(newNamespaceName, PhpLangUtil.toName(this.myClass.getNamespaceName()))) {
            this.doCancelAction();
            return;
        }
        if (this.isSearchInComments() || this.isSearchInTextOccurrences()) {
            this.setPreviewResults(true);
        }
        if (StringUtil.isNotEmpty((String)newNamespaceName) && !PhpNameUtil.isValidNamespaceFullName(newNamespaceName, PhpLanguageLevel.current((Project)this.myProject))) {
            String message = PhpBundle.message("refactoring.common.validation.namespace.name", newNamespaceName);
            this.showErrorMessage(message);
            return;
        }
        if (!this.myClass.isValid()) {
            this.showErrorMessage(PhpBundle.message("refactoring.common.validation.class.psi", this.myClass.getNameCS()));
            return;
        }
        try {
            boolean extractClass = this.isExtractClassOptionEnabled();
            PhpFileCreationInfo newFileConfiguration = extractClass ? this.createNewFileConfig() : null;
            PhpMoveClassSettings settings = new PhpMoveClassSettings(this.myClass, newNamespaceName, newFileConfiguration, this.myIsScopeContainsMultipleClasses, extractClass);
            this.invokeRefactoring(new PhpMoveClassProcessor(this.myProject, settings, this.isSearchInComments(), this.isSearchInTextOccurrences()));
        }
        catch (PhpFilePathValidationException e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    public void doCancelAction() {
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(this.myProject, "move.class");
        super.doCancelAction();
    }

    private void rememberSettings() {
        PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_COMMENTS_AND_STRINGS = this.isSearchInComments();
        PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_TEXT_OCCURRENCES = this.isSearchInTextOccurrences();
    }

    @Nullable
    private PhpFileCreationInfo createNewFileConfig() throws PhpFilePathValidationException {
        PsiDirectory file = this.myClass.getContainingFile().getContainingDirectory();
        String directory = this.myDirectoryChoosePanel.getSelectedDirectory();
        if (!this.myIsScopeContainsMultipleClasses && FileUtil.pathsEqual((String)file.getVirtualFile().getPath(), (String)directory)) {
            return null;
        }
        String fileName = this.myClass.getName() + "." + PhpFileType.INSTANCE.getDefaultExtension();
        return PhpFileCreationInfo.generateConfiguration(this.myProject, directory, fileName);
    }

    private void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    private boolean isExtractClassOptionEnabled() {
        return !this.myIsScopeContainsMultipleClasses || this.myExtractClassIntoSeparateFile.isSelected();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 8, 0);
        gbConstraints.gridwidth = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        panel.add((Component)this.myDirectoryChoosePanel, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_COMMENTS_AND_STRINGS);
        panel.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 2;
        this.myCbSearchTextOccurrences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurrences.setSelected(PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_TEXT_OCCURRENCES);
        panel.add((Component)this.myCbSearchTextOccurrences, gbConstraints);
        return panel;
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInTextOccurrences() {
        return this.myCbSearchTextOccurrences.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDirectoryChoosePanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveClass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isScopeHolderContainsMultipleClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

