/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceField;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpFileConstantInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpFieldIntroducePanel;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldSettings;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldInplaceIntroducer
extends PhpBaseInplaceIntroducer<Field, PhpIntroduceFieldSettings> {
    private static final String LAST_SELECTED_INIT_PLACE = PhpFieldInplaceIntroducer.class.getName() + ".lastSelectedInitPlace";
    private static final int FIELD_ACCESS_PREFIX_LEN = "$this->".length();
    private final Set<String> mySuggestedNames;
    private final PhpFieldIntroducePanel myPanel;
    private RangeMarker myIntroducedFieldMarker;
    private RangeMarker myIntroducedFieldInitializerMarker;

    public PhpFieldInplaceIntroducer(@NotNull PhpIntroduceFieldHandler handler, @NotNull PhpIntroduceContext context, @NotNull PhpIntroduceFieldSettings settings) {
        if (handler == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(2);
        }
        super(handler, context, settings);
        PhpPsiElement scope = (PhpPsiElement)ObjectUtils.tryCast((Object)this.myContext.getScope(), PhpPsiElement.class);
        Set occupiedNames = scope != null ? ContainerUtil.map2Set(FieldImpl.collectFieldDeclarations(scope), PhpNamedElement::getName) : Collections.emptySet();
        this.mySuggestedNames = ContainerUtil.newLinkedHashSet((Object[])new PhpIntroduceFieldNameSuggestionProvider(context, occupiedNames).getSuggestedNames());
        this.myPanel = this.createPanel();
    }

    @Nullable
    protected Field createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(3);
        }
        PhpIntroduceBaseHandler.PhpIntroduceResult introduceResult = this.runRefactoring();
        PsiElement introducedElement = introduceResult.getIntroducedElement();
        assert (introducedElement instanceof Field) : introducedElement;
        this.myIntroducedFieldMarker = this.myEditor.getDocument().createRangeMarker(introducedElement.getTextRange());
        PsiElement initStatement = introduceResult.getInitStatement();
        assert (initStatement != null);
        this.myIntroducedFieldInitializerMarker = this.myEditor.getDocument().createRangeMarker(initStatement.getTextRange());
        PsiElement expressionForOriginalElement = introduceResult.getExpressionForOriginalElement();
        FieldReference reference = PhpFileConstantInplaceIntroducer.findIntroducedElementReference(expressionForOriginalElement, introducedElement, FieldReference.class);
        assert (reference != null) : expressionForOriginalElement;
        this.myExprMarker = this.myEditor.getDocument().createRangeMarker(reference.getTextRange());
        return (Field)introducedElement;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(4);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(6);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), reference.getElement());
        if (textRange == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    protected int adjustHighlightsStartOffset(int offset) {
        return offset + FIELD_ACCESS_PREFIX_LEN;
    }

    @Override
    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable Field variable) {
        String[] stringArray = new PhpIntroduceFieldNameSuggestionProvider(this.myContext, this.mySuggestedNames).getSuggestedNames();
        if (stringArray == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Nullable
    protected PhpFieldIntroducePanel createPanel() {
        boolean allowInitInConstructor = PhpFieldInplaceIntroducer.allowInitInConstructor(this.myContext);
        boolean allowInitInFieldDeclaration = PhpFieldInplaceIntroducer.allowInitInFieldDeclaration(this.myContext);
        boolean allowInitInSetUp = PhpFieldInplaceIntroducer.allowInitInSetUp(this.myContext);
        return allowInitInConstructor || allowInitInFieldDeclaration || allowInitInSetUp ? new PhpFieldIntroducePanel(this.myProject, allowInitInFieldDeclaration, allowInitInConstructor, allowInitInSetUp, ((PhpIntroduceFieldSettings)this.mySettings).getInitPlace()) : null;
    }

    protected int getCaretOffset() {
        return this.myExprMarker.getStartOffset() + FIELD_ACCESS_PREFIX_LEN;
    }

    @Override
    @Nullable
    protected Field getVariable() {
        return this.restoreElementFromMarker(this.myIntroducedFieldMarker, Field.class);
    }

    protected void moveOffsetAfter(boolean success) {
        if (this.myPanel == null) {
            return;
        }
        PhpIntroduceFieldSettings.InitPlace initPlace = this.myPanel.getInitPlace();
        if (success && initPlace != ((PhpIntroduceFieldSettings)this.mySettings).getInitPlace()) {
            if (initPlace == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION) {
                this.putDeclarationInField();
            } else {
                this.putDeclarationInMethod(initPlace);
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_INIT_PLACE, initPlace.toString());
        }
    }

    private void putDeclarationInField() {
        String name;
        Object field;
        AssignmentExpression initializer = this.restoreElementFromMarker(this.myIntroducedFieldInitializerMarker, AssignmentExpression.class);
        PhpClass clazz = PhpPsiUtil.getParentOfClass((PsiElement)initializer, PhpClass.class);
        if (clazz == null || !clazz.isValid()) {
            return;
        }
        PhpPsiElement createdVariable = initializer.getVariable();
        if (createdVariable != null && (field = PhpPsiUtil.getParentByCondition((PsiElement)clazz.findOwnFieldByName((CharSequence)(name = createdVariable.getName()), false), (Condition<? super PsiElement>)((Condition)f -> PhpPsiUtil.isOfType(f, PhpElementTypes.CLASS_FIELDS)), (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null) {
            WriteAction.run(() -> {
                field.replace(PhpIntroduceFieldHandler.getFieldDeclaration(this.myContext, (PhpIntroduceFieldSettings)this.mySettings, true, name));
                initializer.getParent().delete();
            });
        }
    }

    private void putDeclarationInMethod(PhpIntroduceFieldSettings.InitPlace initPlace) {
        if (((PhpIntroduceFieldSettings)this.mySettings).getInitPlace() == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION) {
            Field field = this.restoreElementFromMarker(this.myIntroducedFieldMarker, Field.class);
            if (field != null) {
                String name = field.getName();
                Statement initStatement = PhpIntroduceFieldHandler.getFieldInitialization(this.myProject, name, ((PhpIntroduceFieldSettings)this.mySettings).isStatic(), this.myContext.getElementDeclarationText());
                WriteAction.run(() -> {
                    PhpIntroduceFieldHandler.putInitStatementInMethodBlock(initPlace, initStatement, this.myContext, (PhpIntroduceFieldSettings)this.mySettings);
                    Object classFields = PhpPsiUtil.getParentByCondition((PsiElement)field, (Condition<? super PsiElement>)((Condition)f -> PhpPsiUtil.isOfType(f, PhpElementTypes.CLASS_FIELDS)), (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (classFields != null) {
                        classFields.replace(PhpIntroduceFieldHandler.getFieldDeclaration(this.myContext, (PhpIntroduceFieldSettings)this.mySettings, false, name));
                    }
                });
            }
        } else {
            PhpPsiElement createdVariable;
            AssignmentExpression initializer = this.restoreElementFromMarker(this.myIntroducedFieldInitializerMarker, AssignmentExpression.class);
            PhpPsiElement phpPsiElement = createdVariable = initializer != null ? initializer.getVariable() : null;
            if (createdVariable != null) {
                Statement initStatement = PhpIntroduceFieldHandler.getFieldInitialization(this.myProject, createdVariable.getName(), ((PhpIntroduceFieldSettings)this.mySettings).isStatic(), this.myContext.getElementDeclarationText());
                WriteAction.run(() -> {
                    PhpIntroduceFieldHandler.putInitStatementInMethodBlock(initPlace, initStatement, this.myContext, (PhpIntroduceFieldSettings)this.mySettings);
                    initializer.getParent().delete();
                });
            }
        }
    }

    public static boolean allowInitInFieldDeclaration(@NotNull PhpIntroduceContext introduceContext) {
        PsiElement initValue;
        if (introduceContext == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(9);
        }
        return (initValue = introduceContext.getInitializeValue()) == null || PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(initValue);
    }

    public static boolean allowInitInConstructor(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(10);
        }
        PsiElement initValue = introduceContext.getInitializeValue();
        boolean isStatic = PhpIntroduceFieldHandler.isStaticContext(introduceContext.getContext());
        boolean isMethodConstructor = introduceContext.getContext() instanceof Method && PhpRefactoringUtil.isConstructor((Method)introduceContext.getContext());
        return !isStatic && !isMethodConstructor && (initValue == null || !PhpRefactoringUtil.containsLocalVariables(initValue));
    }

    public static boolean allowInitInSetUp(PhpIntroduceContext introduceContext) {
        PsiElement scope = introduceContext.getScope();
        return scope instanceof PhpClass && PhpUnitUtil.isTestClass((PhpClass)scope);
    }

    @Nullable
    public static PhpIntroduceFieldSettings.InitPlace getLastSelectedInitPlace(@NotNull Project project) {
        if (project == null) {
            PhpFieldInplaceIntroducer.$$$reportNull$$$0(11);
        }
        return PhpIntroduceFieldSettings.InitPlace.fromString(PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_INIT_PLACE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceField/PhpFieldInplaceIntroducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceField/PhpFieldInplaceIntroducer";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allowInitInFieldDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allowInitInConstructor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLastSelectedInitPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

