/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.openapi.util.Pair;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseDisplay;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseSettings;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceRefactoringHandler;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpIntroduceBasePresenter<D extends PhpIntroduceBaseDisplay, S extends PhpIntroduceBaseSettings, R extends PhpIntroduceRefactoringHandler<S>> {
    protected PhpIntroduceContext myIntroduceContext;
    protected static final Pair<Boolean, String> EVERYTHING_IS_OK = new Pair((Object)true, null);
    protected D myDisplay;
    protected R myRefactoringHandler;
    protected Set<? extends PhpNamedElement> myDeclarations;
    protected Set<String> myOccupiedNames;

    public PhpIntroduceBasePresenter(D display, R refactoringHandler, PhpIntroduceContext introduceContext) {
        this.myDisplay = display;
        this.myRefactoringHandler = refactoringHandler;
        this.myIntroduceContext = introduceContext;
    }

    protected void handleDeclarations(@NotNull Set<? extends PhpNamedElement> declarations) {
        if (declarations == null) {
            PhpIntroduceBasePresenter.$$$reportNull$$$0(0);
        }
        this.myDeclarations = declarations;
        this.myOccupiedNames = new HashSet<String>();
        for (PhpNamedElement phpNamedElement : declarations) {
            this.myOccupiedNames.add(phpNamedElement.getName());
        }
    }

    protected void handleDeclarations(Set<? extends PhpNamedElement> declarations, Set<CharSequence> internalOccupiedNames) {
        this.myDeclarations = declarations;
        this.myOccupiedNames = new HashSet<String>();
        for (PhpNamedElement phpNamedElement : declarations) {
            this.myOccupiedNames.add(phpNamedElement.getName());
        }
        for (CharSequence charSequence : internalOccupiedNames) {
            this.myOccupiedNames.add(charSequence.toString());
        }
    }

    public void show() {
        this.initDisplay();
        this.myDisplay.show();
    }

    public boolean isOkExit() {
        return this.myDisplay.isOK();
    }

    protected abstract void initDisplay();

    public abstract S getSettings();

    public DisplayHandler.HandleReaction handleOKAction(D display) {
        return DisplayHandler.HandleReaction.ALLOW;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/jetbrains/php/refactoring/introduce/PhpIntroduceBasePresenter", "handleDeclarations"));
    }

    public static interface DisplayHandler<T extends PhpIntroduceBaseDisplay> {
        public @NotNull Pair<Boolean, @Nls String> validate(T var1);

        public HandleReaction handleOKAction(T var1);

        public static enum HandleReaction {
            ALLOW,
            RETURN,
            BREAK;

        }
    }
}

