/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.phpdoc.PhpMissingDocCommentInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionDialog;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInlineFunctionHandler
extends PhpInlineActionHandler {
    public static final String REFACTORING_HELP_ID = null;

    public boolean canInlineElement(PsiElement element) {
        if (element instanceof Function || element instanceof FunctionReference) {
            return true;
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER)) {
            PsiElement parent = element.getParent();
            return parent instanceof Function || parent instanceof FunctionReference;
        }
        return false;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        boolean inlineLocalThis;
        this.inlineElement(project, editor, element, inlineLocalThis, !(inlineLocalThis = PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS));
    }

    public void inlineElement(Project project, Editor editor, PsiElement element, boolean invokeThisOnly, boolean isDeleteTheDeclaration) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        if (psiReference instanceof PhpCallableFunction) {
            PhpInlineFunctionHandler.showCannotRefactorError(project, editor, PhpBundle.message("refactoring.inline.function.cannot.inline.first.class.callable.declaration", new Object[0]));
            return;
        }
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)psiReference, FunctionReference.class);
        Function[] declarations = PhpInlineFunctionHandler.getDeclarationsBySourceElement(element, functionReference);
        if (declarations.length == 0) {
            PhpInlineFunctionHandler.showCannotRefactorError(project, editor, PhpBundle.message("refactoring.inline.function.cannot.find.function.declaration", new Object[0]));
            return;
        }
        PsiElementProcessor<Function> processor2 = PhpInlineFunctionHandler.createProcessor(project, editor, functionReference, invokeThisOnly, isDeleteTheDeclaration);
        if (declarations.length == 1) {
            processor2.execute((PsiElement)declarations[0]);
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String fqns = Arrays.stream(declarations).map(d -> d.getFQN()).sorted().collect(Collectors.joining(","));
                throw new RuntimeException(new PhpRefactoringErrorException(fqns));
            }
            PhpInlineFunctionHandler.showChooser(editor, declarations, processor2);
        }
    }

    private static void showChooser(Editor editor, Function[] functions, PsiElementProcessor<Function> processor2) {
        NavigationUtil.getPsiElementPopup((PsiElement[])functions, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), processor2).showInBestPositionFor(editor);
    }

    @NotNull
    private static PsiElementProcessor<Function> createProcessor(Project project, Editor editor, FunctionReference functionReference, boolean invokeThisOnly, boolean isDeleteTheDeclaration) {
        PsiElementProcessor psiElementProcessor = e -> {
            try {
                PhpInlineFunctionHandler.invoke(project, editor, functionReference, e, invokeThisOnly, isDeleteTheDeclaration);
            }
            catch (PhpRefactoringErrorException ex) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(ex);
                }
                PhpInlineFunctionHandler.showCannotRefactorError(project, editor, ex.getMessage());
            }
            return false;
        };
        if (psiElementProcessor == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(0);
        }
        return psiElementProcessor;
    }

    private static void showCannotRefactorError(Project project, Editor editor, @NlsSafe String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)PhpBundle.message("dialog.title.inline.variable", new Object[0]), (String)REFACTORING_HELP_ID);
    }

    private static Function[] getDeclarationsBySourceElement(@NotNull PsiElement element, @Nullable FunctionReference functionReference) {
        if (element == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(1);
        }
        if (element instanceof Function) {
            return new Function[]{(Function)element};
        }
        PsiElement parent = element.getParent();
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER) && parent instanceof Function) {
            return new Function[]{(Function)parent};
        }
        assert (functionReference != null);
        return (Function[])StreamEx.of((Object[])functionReference.multiResolve(false)).map(r -> r.getElement()).select(Function.class).toArray(Function.class);
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable FunctionReference functionReference, Function function, boolean invokeThisOnly, boolean isDeleteTheDeclaration) throws PhpRefactoringErrorException {
        if (project == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(3);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        PhpInlineFunctionHandler.validate(project, function);
        if (ApplicationManager.getApplication().isUnitTestMode() || !EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
            new PhpInlineFunctionProcessor(project, function, functionReference, invokeThisOnly, isDeleteTheDeclaration).run();
        } else {
            PhpInlineFunctionDialog dialog = new PhpInlineFunctionDialog(project, editor, function, functionReference);
            dialog.show();
        }
    }

    public static void validate(@NotNull Project project, Function function) throws PhpRefactoringErrorException {
        Set<String> problems;
        VirtualFile virtualFile;
        GroupStatement groupStatement;
        if (project == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(4);
        }
        if ((groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) == null) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.parse.function.body", new Object[0]));
        }
        PsiFile containingFile = function.getContainingFile();
        if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null && !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.inline.library.function", new Object[0]));
        }
        if (function instanceof Method) {
            if (PhpMissingDocCommentInspection.isConstructor(function)) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.inline.constructor", new Object[0]));
            }
            if (PhpLangUtil.isMagicMethod(function.getName())) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.inline.magic.method", new Object[0]));
            }
            if (PhpInlineFunctionHandler.hasOverridingMethod((Method)function)) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.inline.overridden.method", new Object[0]));
            }
        }
        if (!(problems = PhpInlineFunctionHandler.validateBody(function)).isEmpty()) {
            throw new PhpRefactoringErrorException(problems.iterator().next());
        }
    }

    private static boolean hasOverridingMethod(Method method) {
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (m, subClass, baseClass) -> {
            result.set((Object)true);
            return false;
        });
        return (Boolean)result.get();
    }

    public static MultiMap<PsiElement, String> validateFunctionContext(Function function, final FunctionReference functionReference) {
        final PhpClass contextClass = PhpInlineFunctionHandler.getContextClass(functionReference);
        final MultiMap problems = new MultiMap();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpMethodReference(MethodReference methodReference) {
                this.validateVisibilityOfMemberReference((MemberReference)methodReference);
                super.visitPhpMethodReference(methodReference);
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.validateVisibilityOfMemberReference((MemberReference)fieldReference);
                super.visitPhpFieldReference(fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.validateVisibilityOfMemberReference((MemberReference)constantReference);
                super.visitPhpClassConstantReference(constantReference);
            }

            public void visitPhpNewExpression(NewExpression expression) {
                Method constructor;
                if (expression.getClassReference() != null && (constructor = (Method)ObjectUtils.tryCast((Object)expression.getClassReference().resolve(), Method.class)) != null) {
                    this.validateVisibilityOfClassMember((PhpClassMember)constructor, expression.getText());
                }
                super.visitPhpNewExpression(expression);
            }

            public void validateVisibilityOfMemberReference(MemberReference memberReference) {
                PsiElement resolve = memberReference.resolve();
                if (resolve instanceof PhpClassMember) {
                    PhpClassMember classMember = (PhpClassMember)resolve;
                    String refText = memberReference.getText();
                    this.validateVisibilityOfClassMember(classMember, refText);
                }
            }

            private void validateVisibilityOfClassMember(@NotNull PhpClassMember classMember, @NotNull String refText) {
                if (classMember == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refText == null) {
                    1.$$$reportNull$$$0(1);
                }
                PhpModifier modifier = classMember.getModifier();
                PhpClass declarationClass = classMember.getContainingClass();
                if (!(modifier.isPublic() || contextClass != null && declarationClass != null)) {
                    problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", refText));
                    return;
                }
                if (modifier.isPrivate() && contextClass != declarationClass) {
                    problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", refText));
                }
                if (modifier.isProtected() && !this.checkHierarchy(declarationClass)) {
                    problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", refText));
                }
            }

            public boolean checkHierarchy(PhpClass declarationClass) {
                return declarationClass != null && contextClass != null && (contextClass == declarationClass || PhpClassHierarchyUtils.isSuperClass((PhpClass)declarationClass, (PhpClass)contextClass, (boolean)true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "classMember";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "refText";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionHandler$1";
                objectArray[2] = "validateVisibilityOfClassMember";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return problems;
    }

    @Nullable
    private static PhpClass getContextClass(FunctionReference functionReference) {
        Method method = PhpPsiUtil.getParentOfClass((PsiElement)functionReference, Method.class);
        PhpClass contextClass = null;
        if (method != null) {
            contextClass = method.getContainingClass();
        }
        return contextClass;
    }

    private static Set<String> validateBody(final Function function) {
        final HashSet<String> problems = new HashSet<String>();
        final ArrayList<PhpReturn> returnStatements = new ArrayList<PhpReturn>();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFunction(Function function2) {
                if (function2.isClosure()) {
                    return;
                }
                super.visitPhpFunction(function2);
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                returnStatements.add(returnStatement);
                super.visitPhpReturn(returnStatement);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.isRecursive(reference);
                super.visitPhpFunctionCall(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.isRecursive((FunctionReference)reference);
                super.visitPhpMethodReference(reference);
            }

            public void visitPhpClassReference(ClassReference classReference) {
                if ("parent".equals(classReference.getName()) && classReference.resolve() == null) {
                    problems.add(PhpBundle.message("refactoring.inline.function.parent.reference.unresolved", PhpInlineFunctionPresenter.getElementDescription(function, false)));
                }
                super.visitPhpClassReference(classReference);
            }

            public void visitPhpGlobal(Global globalStatement) {
                problems.add(PhpBundle.message("refactoring.inline.function.cannot.inline.function.with.global.usage", PhpInlineFunctionPresenter.getElementDescription(function, false)));
                super.visitPhpGlobal(globalStatement);
            }

            public void visitPhpYield(PhpYield element) {
                problems.add(PhpBundle.message("refactoring.inline.function.yield.found.in.function.body", new Object[0]));
                super.visitPhpYield(element);
            }

            private void isRecursive(FunctionReference reference) {
                if (reference.resolve() == function) {
                    problems.add(PhpBundle.message("refactoring.inline.function.reference.is.recursive", new Object[0]));
                }
            }
        });
        if (!returnStatements.isEmpty() && PhpInlineFunctionHandler.analyzeFunctionFlow(function, returnStatements)) {
            problems.add(PhpBundle.message("refactoring.inline.function.inline.function.refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", new Object[0]));
        }
        return problems;
    }

    private static boolean analyzeFunctionFlow(Function function, Collection<PhpReturn> returns) {
        Function functionToProcess = PhpPsiElementFactory.createFunction(function.getProject(), function.getText());
        final LinkedHashSet statements = new LinkedHashSet();
        functionToProcess.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                statements.add(returnStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(returnStatement.getProject(), "$result = " + String.valueOf(returnStatement.getArgument()) + ";")));
            }
        });
        PhpControlFlow flow = functionToProcess.getControlFlow();
        StreamEx.of((Collection)flow.getExitPoint().getPredecessors()).map(i -> i.getAnchor()).select(Statement.class).into(statements);
        final Ref result = new Ref();
        result.set((Object)false);
        for (PsiElement it : statements) {
            PhpStatementInstruction instruction = PhpControlFlowUtil.getStatementInstruction(flow, (Statement)it);
            if (instruction == null) continue;
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                    if (statements.contains(instruction.getStatement())) {
                        result.set((Object)true);
                        return false;
                    }
                    return true;
                }
            });
        }
        return (Boolean)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsBySourceElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

